/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.time.calendar;

import io.deephaven.time.calendar.ReadOptimizedConcurrentCache;
import java.time.LocalDate;
import java.util.Iterator;
import java.util.function.IntFunction;

class YearMonthSummaryCache<T extends ReadOptimizedConcurrentCache.IntKeyedValue> {
    private final ReadOptimizedConcurrentCache<T> monthCache;
    private final ReadOptimizedConcurrentCache<T> yearCache;

    static int yearMonthKey(int year, int month) {
        return year * 100 + month;
    }

    static int yearFromYearMonthKey(int key) {
        return key / 100;
    }

    static int monthFromYearMonthKey(int key) {
        return key % 100;
    }

    YearMonthSummaryCache(IntFunction<T> computeMonthSummary, IntFunction<T> computeYearSummary) {
        this.monthCache = new ReadOptimizedConcurrentCache<T>(600, computeMonthSummary);
        this.yearCache = new ReadOptimizedConcurrentCache<T>(50, computeYearSummary);
    }

    synchronized void clear() {
        this.monthCache.clear();
        this.yearCache.clear();
    }

    T getMonthSummary(int year, int month) {
        return this.monthCache.computeIfAbsent(YearMonthSummaryCache.yearMonthKey(year, month));
    }

    T getYearSummary(int year) {
        return this.yearCache.computeIfAbsent(year);
    }

    Iterator<T> iterator(LocalDate start, LocalDate end, boolean startInclusive, boolean endInclusive) {
        return new YearMonthSummaryIterator(startInclusive ? start : start.plusDays(1L), endInclusive ? end : end.minusDays(1L));
    }

    private class YearMonthSummaryIterator
    implements Iterator<T> {
        private int currentYear;
        private int currentMonth;
        private int currentYearMonth;
        private int finalYear;
        private int finalMonth;
        private final int finalYearMonth;

        YearMonthSummaryIterator(LocalDate start, LocalDate end) {
            int startYear = start.getYear();
            int startMonth = start.getMonthValue();
            int endYear = end.getYear();
            int endMonth = end.getMonthValue();
            this.currentMonth = startMonth;
            this.currentYear = startYear;
            if (start.getDayOfMonth() != 1) {
                this.incrementCurrentByMonth();
            }
            this.currentYearMonth = YearMonthSummaryCache.yearMonthKey(this.currentYear, this.currentMonth);
            LocalDate endPlus1 = end.plusDays(1L);
            int endPlus1Month = endPlus1.getMonthValue();
            this.finalMonth = endMonth;
            this.finalYear = endYear;
            if (endPlus1Month == endMonth) {
                if (this.finalMonth == 1) {
                    this.finalMonth = 12;
                    --this.finalYear;
                } else {
                    --this.finalMonth;
                }
            }
            this.finalYearMonth = YearMonthSummaryCache.yearMonthKey(this.finalYear, this.finalMonth);
        }

        private void incrementCurrentByMonth() {
            if (this.currentMonth == 12) {
                this.currentMonth = 1;
                ++this.currentYear;
            } else {
                ++this.currentMonth;
            }
            this.currentYearMonth = YearMonthSummaryCache.yearMonthKey(this.currentYear, this.currentMonth);
        }

        private void incrementCurrentByYear() {
            ++this.currentYear;
            this.currentYearMonth = YearMonthSummaryCache.yearMonthKey(this.currentYear, this.currentMonth);
        }

        @Override
        public boolean hasNext() {
            return this.currentYearMonth <= this.finalYearMonth;
        }

        @Override
        public T next() {
            Object val;
            if (this.currentMonth == 1 && (this.currentYear != this.finalYear || this.finalMonth == 12)) {
                val = YearMonthSummaryCache.this.getYearSummary(this.currentYear);
                this.incrementCurrentByYear();
            } else {
                val = YearMonthSummaryCache.this.getMonthSummary(this.currentYear, this.currentMonth);
                this.incrementCurrentByMonth();
            }
            return val;
        }
    }
}

