/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.time.calendar;

import io.deephaven.time.calendar.CalendarDay;
import io.deephaven.time.calendar.Calendars;
import io.deephaven.util.annotations.UserInvocationPermitted;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Set;

@UserInvocationPermitted(value={"function_library"})
public class StaticCalendarMethods {
    public static String[] businessDates(String start, String end) {
        return Calendars.calendar().businessDates(start, end);
    }

    public static LocalDate[] businessDates(Instant start, Instant end) {
        return Calendars.calendar().businessDates(start, end);
    }

    public static LocalDate[] businessDates(LocalDate start, LocalDate end) {
        return Calendars.calendar().businessDates(start, end);
    }

    public static LocalDate[] businessDates(ZonedDateTime start, ZonedDateTime end) {
        return Calendars.calendar().businessDates(start, end);
    }

    public static String[] businessDates(String start, String end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().businessDates(start, end, startInclusive, endInclusive);
    }

    public static LocalDate[] businessDates(Instant start, Instant end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().businessDates(start, end, startInclusive, endInclusive);
    }

    public static LocalDate[] businessDates(LocalDate start, LocalDate end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().businessDates(start, end, startInclusive, endInclusive);
    }

    public static LocalDate[] businessDates(ZonedDateTime start, ZonedDateTime end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().businessDates(start, end, startInclusive, endInclusive);
    }

    public static LocalDate calendarDate() {
        return Calendars.calendar().calendarDate();
    }

    public static String[] calendarDates(String start, String end) {
        return Calendars.calendar().calendarDates(start, end);
    }

    public static LocalDate[] calendarDates(Instant start, Instant end) {
        return Calendars.calendar().calendarDates(start, end);
    }

    public static LocalDate[] calendarDates(LocalDate start, LocalDate end) {
        return Calendars.calendar().calendarDates(start, end);
    }

    public static LocalDate[] calendarDates(ZonedDateTime start, ZonedDateTime end) {
        return Calendars.calendar().calendarDates(start, end);
    }

    public static String[] calendarDates(String start, String end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().calendarDates(start, end, startInclusive, endInclusive);
    }

    public static LocalDate[] calendarDates(Instant start, Instant end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().calendarDates(start, end, startInclusive, endInclusive);
    }

    public static LocalDate[] calendarDates(LocalDate start, LocalDate end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().calendarDates(start, end, startInclusive, endInclusive);
    }

    public static LocalDate[] calendarDates(ZonedDateTime start, ZonedDateTime end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().calendarDates(start, end, startInclusive, endInclusive);
    }

    public static CalendarDay<Instant> calendarDay() {
        return Calendars.calendar().calendarDay();
    }

    public static CalendarDay<Instant> calendarDay(String date) {
        return Calendars.calendar().calendarDay(date);
    }

    public static CalendarDay<Instant> calendarDay(Instant time) {
        return Calendars.calendar().calendarDay(time);
    }

    public static CalendarDay<Instant> calendarDay(LocalDate date) {
        return Calendars.calendar().calendarDay(date);
    }

    public static CalendarDay<Instant> calendarDay(ZonedDateTime time) {
        return Calendars.calendar().calendarDay(time);
    }

    public static DayOfWeek calendarDayOfWeek() {
        return Calendars.calendar().dayOfWeek();
    }

    public static DayOfWeek calendarDayOfWeek(String date) {
        return Calendars.calendar().dayOfWeek(date);
    }

    public static DayOfWeek calendarDayOfWeek(Instant time) {
        return Calendars.calendar().dayOfWeek(time);
    }

    public static DayOfWeek calendarDayOfWeek(LocalDate date) {
        return Calendars.calendar().dayOfWeek(date);
    }

    public static DayOfWeek calendarDayOfWeek(ZonedDateTime time) {
        return Calendars.calendar().dayOfWeek(time);
    }

    public static int calendarDayOfWeekValue() {
        return Calendars.calendar().dayOfWeekValue();
    }

    public static int calendarDayOfWeekValue(String date) {
        return Calendars.calendar().dayOfWeekValue(date);
    }

    public static int calendarDayOfWeekValue(Instant time) {
        return Calendars.calendar().dayOfWeekValue(time);
    }

    public static int calendarDayOfWeekValue(LocalDate date) {
        return Calendars.calendar().dayOfWeekValue(date);
    }

    public static int calendarDayOfWeekValue(ZonedDateTime time) {
        return Calendars.calendar().dayOfWeekValue(time);
    }

    public static double diffBusinessDays(Instant start, Instant end) {
        return Calendars.calendar().diffBusinessDays(start, end);
    }

    public static double diffBusinessDays(ZonedDateTime start, ZonedDateTime end) {
        return Calendars.calendar().diffBusinessDays(start, end);
    }

    public static Duration diffBusinessDuration(Instant start, Instant end) {
        return Calendars.calendar().diffBusinessDuration(start, end);
    }

    public static Duration diffBusinessDuration(ZonedDateTime start, ZonedDateTime end) {
        return Calendars.calendar().diffBusinessDuration(start, end);
    }

    public static long diffBusinessNanos(Instant start, Instant end) {
        return Calendars.calendar().diffBusinessNanos(start, end);
    }

    public static long diffBusinessNanos(ZonedDateTime start, ZonedDateTime end) {
        return Calendars.calendar().diffBusinessNanos(start, end);
    }

    public static double diffBusinessYears(Instant start, Instant end) {
        return Calendars.calendar().diffBusinessYears(start, end);
    }

    public static double diffBusinessYears(ZonedDateTime start, ZonedDateTime end) {
        return Calendars.calendar().diffBusinessYears(start, end);
    }

    public static Duration diffNonBusinessDuration(Instant start, Instant end) {
        return Calendars.calendar().diffNonBusinessDuration(start, end);
    }

    public static Duration diffNonBusinessDuration(ZonedDateTime start, ZonedDateTime end) {
        return Calendars.calendar().diffNonBusinessDuration(start, end);
    }

    public static long diffNonBusinessNanos(Instant start, Instant end) {
        return Calendars.calendar().diffNonBusinessNanos(start, end);
    }

    public static long diffNonBusinessNanos(ZonedDateTime start, ZonedDateTime end) {
        return Calendars.calendar().diffNonBusinessNanos(start, end);
    }

    public static double fractionBusinessDayComplete() {
        return Calendars.calendar().fractionBusinessDayComplete();
    }

    public static double fractionBusinessDayComplete(Instant time) {
        return Calendars.calendar().fractionBusinessDayComplete(time);
    }

    public static double fractionBusinessDayComplete(ZonedDateTime time) {
        return Calendars.calendar().fractionBusinessDayComplete(time);
    }

    public static double fractionBusinessDayRemaining() {
        return Calendars.calendar().fractionBusinessDayRemaining();
    }

    public static double fractionBusinessDayRemaining(Instant time) {
        return Calendars.calendar().fractionBusinessDayRemaining(time);
    }

    public static double fractionBusinessDayRemaining(ZonedDateTime time) {
        return Calendars.calendar().fractionBusinessDayRemaining(time);
    }

    public static double fractionStandardBusinessDay() {
        return Calendars.calendar().fractionStandardBusinessDay();
    }

    public static double fractionStandardBusinessDay(String date) {
        return Calendars.calendar().fractionStandardBusinessDay(date);
    }

    public static double fractionStandardBusinessDay(Instant time) {
        return Calendars.calendar().fractionStandardBusinessDay(time);
    }

    public static double fractionStandardBusinessDay(LocalDate date) {
        return Calendars.calendar().fractionStandardBusinessDay(date);
    }

    public static double fractionStandardBusinessDay(ZonedDateTime time) {
        return Calendars.calendar().fractionStandardBusinessDay(time);
    }

    public static LocalDate futureBusinessDate(int days) {
        return Calendars.calendar().futureBusinessDate(days);
    }

    public static LocalDate futureDate(int days) {
        return Calendars.calendar().futureDate(days);
    }

    public static LocalDate futureNonBusinessDate(int days) {
        return Calendars.calendar().futureNonBusinessDate(days);
    }

    public static Map<LocalDate, CalendarDay<Instant>> holidays() {
        return Calendars.calendar().holidays();
    }

    public static boolean isBusinessDay() {
        return Calendars.calendar().isBusinessDay();
    }

    public static boolean isBusinessDay(String date) {
        return Calendars.calendar().isBusinessDay(date);
    }

    public static boolean isBusinessDay(DayOfWeek day) {
        return Calendars.calendar().isBusinessDay(day);
    }

    public static boolean isBusinessDay(Instant time) {
        return Calendars.calendar().isBusinessDay(time);
    }

    public static boolean isBusinessDay(LocalDate date) {
        return Calendars.calendar().isBusinessDay(date);
    }

    public static boolean isBusinessDay(ZonedDateTime time) {
        return Calendars.calendar().isBusinessDay(time);
    }

    public static boolean isBusinessTime() {
        return Calendars.calendar().isBusinessTime();
    }

    public static boolean isBusinessTime(Instant time) {
        return Calendars.calendar().isBusinessTime(time);
    }

    public static boolean isBusinessTime(ZonedDateTime time) {
        return Calendars.calendar().isBusinessTime(time);
    }

    public static boolean isLastBusinessDayOfMonth() {
        return Calendars.calendar().isLastBusinessDayOfMonth();
    }

    public static boolean isLastBusinessDayOfMonth(String date) {
        return Calendars.calendar().isLastBusinessDayOfMonth(date);
    }

    public static boolean isLastBusinessDayOfMonth(Instant time) {
        return Calendars.calendar().isLastBusinessDayOfMonth(time);
    }

    public static boolean isLastBusinessDayOfMonth(ZonedDateTime time) {
        return Calendars.calendar().isLastBusinessDayOfMonth(time);
    }

    public static boolean isLastBusinessDayOfWeek() {
        return Calendars.calendar().isLastBusinessDayOfWeek();
    }

    public static boolean isLastBusinessDayOfWeek(String date) {
        return Calendars.calendar().isLastBusinessDayOfWeek(date);
    }

    public static boolean isLastBusinessDayOfWeek(Instant time) {
        return Calendars.calendar().isLastBusinessDayOfWeek(time);
    }

    public static boolean isLastBusinessDayOfWeek(LocalDate date) {
        return Calendars.calendar().isLastBusinessDayOfWeek(date);
    }

    public static boolean isLastBusinessDayOfWeek(ZonedDateTime time) {
        return Calendars.calendar().isLastBusinessDayOfWeek(time);
    }

    public static boolean isLastBusinessDayOfYear() {
        return Calendars.calendar().isLastBusinessDayOfYear();
    }

    public static boolean isLastBusinessDayOfYear(Instant time) {
        return Calendars.calendar().isLastBusinessDayOfYear(time);
    }

    public static boolean isLastBusinessDayOfYear(ZonedDateTime time) {
        return Calendars.calendar().isLastBusinessDayOfYear(time);
    }

    public static String minusBusinessDays(String date, int days) {
        return Calendars.calendar().minusBusinessDays(date, days);
    }

    public static Instant minusBusinessDays(Instant time, int days) {
        return Calendars.calendar().minusBusinessDays(time, days);
    }

    public static LocalDate minusBusinessDays(LocalDate date, int days) {
        return Calendars.calendar().minusBusinessDays(date, days);
    }

    public static ZonedDateTime minusBusinessDays(ZonedDateTime time, int days) {
        return Calendars.calendar().minusBusinessDays(time, days);
    }

    public static String minusDays(String date, int days) {
        return Calendars.calendar().minusDays(date, days);
    }

    public static Instant minusDays(Instant time, int days) {
        return Calendars.calendar().minusDays(time, days);
    }

    public static LocalDate minusDays(LocalDate date, int days) {
        return Calendars.calendar().minusDays(date, days);
    }

    public static ZonedDateTime minusDays(ZonedDateTime time, int days) {
        return Calendars.calendar().minusDays(time, days);
    }

    public static String minusNonBusinessDays(String date, int days) {
        return Calendars.calendar().minusNonBusinessDays(date, days);
    }

    public static Instant minusNonBusinessDays(Instant time, int days) {
        return Calendars.calendar().minusNonBusinessDays(time, days);
    }

    public static LocalDate minusNonBusinessDays(LocalDate date, int days) {
        return Calendars.calendar().minusNonBusinessDays(date, days);
    }

    public static ZonedDateTime minusNonBusinessDays(ZonedDateTime time, int days) {
        return Calendars.calendar().minusNonBusinessDays(time, days);
    }

    public static String[] nonBusinessDates(String start, String end) {
        return Calendars.calendar().nonBusinessDates(start, end);
    }

    public static LocalDate[] nonBusinessDates(Instant start, Instant end) {
        return Calendars.calendar().nonBusinessDates(start, end);
    }

    public static LocalDate[] nonBusinessDates(LocalDate start, LocalDate end) {
        return Calendars.calendar().nonBusinessDates(start, end);
    }

    public static LocalDate[] nonBusinessDates(ZonedDateTime start, ZonedDateTime end) {
        return Calendars.calendar().nonBusinessDates(start, end);
    }

    public static String[] nonBusinessDates(String start, String end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().nonBusinessDates(start, end, startInclusive, endInclusive);
    }

    public static LocalDate[] nonBusinessDates(Instant start, Instant end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().nonBusinessDates(start, end, startInclusive, endInclusive);
    }

    public static LocalDate[] nonBusinessDates(LocalDate start, LocalDate end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().nonBusinessDates(start, end, startInclusive, endInclusive);
    }

    public static LocalDate[] nonBusinessDates(ZonedDateTime start, ZonedDateTime end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().nonBusinessDates(start, end, startInclusive, endInclusive);
    }

    public static int numberBusinessDates(String start, String end) {
        return Calendars.calendar().numberBusinessDates(start, end);
    }

    public static int numberBusinessDates(Instant start, Instant end) {
        return Calendars.calendar().numberBusinessDates(start, end);
    }

    public static int numberBusinessDates(LocalDate start, LocalDate end) {
        return Calendars.calendar().numberBusinessDates(start, end);
    }

    public static int numberBusinessDates(ZonedDateTime start, ZonedDateTime end) {
        return Calendars.calendar().numberBusinessDates(start, end);
    }

    public static int numberBusinessDates(String start, String end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().numberBusinessDates(start, end, startInclusive, endInclusive);
    }

    public static int numberBusinessDates(Instant start, Instant end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().numberBusinessDates(start, end, startInclusive, endInclusive);
    }

    public static int numberBusinessDates(LocalDate start, LocalDate end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().numberBusinessDates(start, end, startInclusive, endInclusive);
    }

    public static int numberBusinessDates(ZonedDateTime start, ZonedDateTime end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().numberBusinessDates(start, end, startInclusive, endInclusive);
    }

    public static int numberCalendarDates(String start, String end) {
        return Calendars.calendar().numberCalendarDates(start, end);
    }

    public static int numberCalendarDates(Instant start, Instant end) {
        return Calendars.calendar().numberCalendarDates(start, end);
    }

    public static int numberCalendarDates(LocalDate start, LocalDate end) {
        return Calendars.calendar().numberCalendarDates(start, end);
    }

    public static int numberCalendarDates(ZonedDateTime start, ZonedDateTime end) {
        return Calendars.calendar().numberCalendarDates(start, end);
    }

    public static int numberCalendarDates(String start, String end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().numberCalendarDates(start, end, startInclusive, endInclusive);
    }

    public static int numberCalendarDates(Instant start, Instant end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().numberCalendarDates(start, end, startInclusive, endInclusive);
    }

    public static int numberCalendarDates(LocalDate start, LocalDate end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().numberCalendarDates(start, end, startInclusive, endInclusive);
    }

    public static int numberCalendarDates(ZonedDateTime start, ZonedDateTime end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().numberCalendarDates(start, end, startInclusive, endInclusive);
    }

    public static int numberNonBusinessDates(String start, String end) {
        return Calendars.calendar().numberNonBusinessDates(start, end);
    }

    public static int numberNonBusinessDates(Instant start, Instant end) {
        return Calendars.calendar().numberNonBusinessDates(start, end);
    }

    public static int numberNonBusinessDates(LocalDate start, LocalDate end) {
        return Calendars.calendar().numberNonBusinessDates(start, end);
    }

    public static int numberNonBusinessDates(ZonedDateTime start, ZonedDateTime end) {
        return Calendars.calendar().numberNonBusinessDates(start, end);
    }

    public static int numberNonBusinessDates(String start, String end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().numberNonBusinessDates(start, end, startInclusive, endInclusive);
    }

    public static int numberNonBusinessDates(Instant start, Instant end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().numberNonBusinessDates(start, end, startInclusive, endInclusive);
    }

    public static int numberNonBusinessDates(LocalDate start, LocalDate end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().numberNonBusinessDates(start, end, startInclusive, endInclusive);
    }

    public static int numberNonBusinessDates(ZonedDateTime start, ZonedDateTime end, boolean startInclusive, boolean endInclusive) {
        return Calendars.calendar().numberNonBusinessDates(start, end, startInclusive, endInclusive);
    }

    public static LocalDate pastBusinessDate(int days) {
        return Calendars.calendar().pastBusinessDate(days);
    }

    public static LocalDate pastDate(int days) {
        return Calendars.calendar().pastDate(days);
    }

    public static LocalDate pastNonBusinessDate(int days) {
        return Calendars.calendar().pastNonBusinessDate(days);
    }

    public static String plusBusinessDays(String date, int days) {
        return Calendars.calendar().plusBusinessDays(date, days);
    }

    public static Instant plusBusinessDays(Instant time, int days) {
        return Calendars.calendar().plusBusinessDays(time, days);
    }

    public static LocalDate plusBusinessDays(LocalDate date, int days) {
        return Calendars.calendar().plusBusinessDays(date, days);
    }

    public static ZonedDateTime plusBusinessDays(ZonedDateTime time, int days) {
        return Calendars.calendar().plusBusinessDays(time, days);
    }

    public static String plusDays(String date, int days) {
        return Calendars.calendar().plusDays(date, days);
    }

    public static Instant plusDays(Instant time, int days) {
        return Calendars.calendar().plusDays(time, days);
    }

    public static LocalDate plusDays(LocalDate date, int days) {
        return Calendars.calendar().plusDays(date, days);
    }

    public static ZonedDateTime plusDays(ZonedDateTime time, int days) {
        return Calendars.calendar().plusDays(time, days);
    }

    public static String plusNonBusinessDays(String date, int days) {
        return Calendars.calendar().plusNonBusinessDays(date, days);
    }

    public static Instant plusNonBusinessDays(Instant time, int days) {
        return Calendars.calendar().plusNonBusinessDays(time, days);
    }

    public static LocalDate plusNonBusinessDays(LocalDate date, int days) {
        return Calendars.calendar().plusNonBusinessDays(date, days);
    }

    public static ZonedDateTime plusNonBusinessDays(ZonedDateTime time, int days) {
        return Calendars.calendar().plusNonBusinessDays(time, days);
    }

    public static CalendarDay<LocalTime> standardBusinessDay() {
        return Calendars.calendar().standardBusinessDay();
    }

    public static Duration standardBusinessDuration() {
        return Calendars.calendar().standardBusinessDuration();
    }

    public static long standardBusinessNanos() {
        return Calendars.calendar().standardBusinessNanos();
    }

    public static ZoneId calendarTimeZone() {
        return Calendars.calendar().timeZone();
    }

    public static Set<DayOfWeek> weekendDays() {
        return Calendars.calendar().weekendDays();
    }
}

