/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.time;

import io.deephaven.time.DateTimeUtils;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeLiteralReplacedExpression {
    private final String convertedFormula;
    private final String instanceVariablesString;
    private final HashMap<String, Class<?>> newVariables;

    private TimeLiteralReplacedExpression(String convertedFormula, String instanceVariablesString, HashMap<String, Class<?>> newVariables) {
        this.convertedFormula = convertedFormula;
        this.instanceVariablesString = instanceVariablesString;
        this.newVariables = newVariables;
    }

    public String getConvertedFormula() {
        return this.convertedFormula;
    }

    public String getInstanceVariablesString() {
        return this.instanceVariablesString;
    }

    public HashMap<String, Class<?>> getNewVariables() {
        return this.newVariables;
    }

    public static TimeLiteralReplacedExpression convertExpression(String expression) throws Exception {
        StringBuilder instanceVariablesString = new StringBuilder();
        HashMap newVariables = new HashMap();
        StringBuilder convertedFormula = new StringBuilder();
        int localDateIndex = 0;
        int dateTimeIndex = 0;
        int nanosIndex = 0;
        int periodIndex = 0;
        int durationIndex = 0;
        int tzIndex = 0;
        Matcher matcher = Pattern.compile("'[^']*'").matcher(expression);
        while (matcher.find()) {
            String s = expression.substring(matcher.start() + 1, matcher.end() - 1);
            if (s.length() <= 1) continue;
            if (DateTimeUtils.parseInstantQuiet(s) != null) {
                matcher.appendReplacement(convertedFormula, "_instant" + dateTimeIndex);
                instanceVariablesString.append("        private Instant _instant").append(dateTimeIndex).append("=DateTimeUtils.parseInstant(\"").append(expression, matcher.start() + 1, matcher.end() - 1).append("\");\n");
                newVariables.put("_instant" + dateTimeIndex, Instant.class);
                ++dateTimeIndex;
                continue;
            }
            if (DateTimeUtils.parsePeriodQuiet(s) != null) {
                matcher.appendReplacement(convertedFormula, "_period" + periodIndex);
                instanceVariablesString.append("        private java.time.Period _period").append(periodIndex).append("=DateTimeUtils.parsePeriod(\"").append(expression, matcher.start() + 1, matcher.end() - 1).append("\");\n");
                newVariables.put("_period" + periodIndex, Period.class);
                ++periodIndex;
                continue;
            }
            if (DateTimeUtils.parseDurationQuiet(s) != null) {
                matcher.appendReplacement(convertedFormula, "_duration" + durationIndex);
                instanceVariablesString.append("        private java.time.Duration _duration").append(durationIndex).append("=DateTimeUtils.parseDuration(\"").append(expression, matcher.start() + 1, matcher.end() - 1).append("\");\n");
                newVariables.put("_duration" + durationIndex, Duration.class);
                ++durationIndex;
                continue;
            }
            if (DateTimeUtils.parseLocalDateQuiet(s) != null) {
                matcher.appendReplacement(convertedFormula, "_localDate" + localDateIndex);
                instanceVariablesString.append("        private java.time.LocalDate _localDate").append(localDateIndex).append("=DateTimeUtils.parseLocalDate(\"").append(expression, matcher.start() + 1, matcher.end() - 1).append("\");\n");
                newVariables.put("_localDate" + localDateIndex, LocalDate.class);
                ++localDateIndex;
                continue;
            }
            if (DateTimeUtils.parseLocalTimeQuiet(s) != null) {
                matcher.appendReplacement(convertedFormula, "_localTime" + nanosIndex);
                instanceVariablesString.append("        private java.time.LocalTime _localTime").append(nanosIndex).append("=DateTimeUtils.parseLocalTime(\"").append(expression, matcher.start() + 1, matcher.end() - 1).append("\");\n");
                newVariables.put("_localTime" + nanosIndex, LocalTime.class);
                ++nanosIndex;
                continue;
            }
            if (DateTimeUtils.parseTimeZoneQuiet(s) != null) {
                matcher.appendReplacement(convertedFormula, "_timeZone" + tzIndex);
                instanceVariablesString.append("        private java.time.ZoneId _timeZone").append(tzIndex).append("=DateTimeUtils.parseTimeZone(\"").append(expression, matcher.start() + 1, matcher.end() - 1).append("\");\n");
                newVariables.put("_timeZone" + tzIndex, ZoneId.class);
                ++tzIndex;
                continue;
            }
            throw new Exception("Cannot parse literal as a datetime, date, time, duration, period, or timezone: " + s);
        }
        matcher.appendTail(convertedFormula);
        return new TimeLiteralReplacedExpression(convertedFormula.toString(), instanceVariablesString.toString(), newVariables);
    }
}

