package io.deephaven.appmode;

import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StaticClassApplication}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableStaticClassApplication.of()}.
 */
@Generated(from = "StaticClassApplication", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableStaticClassApplication<T extends Application.Factory>
    extends StaticClassApplication<T> {
  private final Class<T> clazz;
  private final boolean isEnabled;

  private ImmutableStaticClassApplication(Class<T> clazz, boolean isEnabled) {
    this.clazz = Objects.requireNonNull(clazz, "clazz");
    this.isEnabled = isEnabled;
  }

  /**
   * @return The value of the {@code clazz} attribute
   */
  @Override
  public Class<T> clazz() {
    return clazz;
  }

  /**
   * @return The value of the {@code isEnabled} attribute
   */
  @Override
  public boolean isEnabled() {
    return isEnabled;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStaticClassApplication} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStaticClassApplication<?>
        && equalsByValue((ImmutableStaticClassApplication<?>) another);
  }

  private boolean equalsByValue(ImmutableStaticClassApplication<?> another) {
    return clazz.equals(another.clazz)
        && isEnabled == another.isEnabled;
  }

  /**
   * Computes a hash code from attributes: {@code clazz}, {@code isEnabled}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + getClass().hashCode();
    h += (h << 5) + clazz.hashCode();
    h += (h << 5) + Boolean.hashCode(isEnabled);
    return h;
  }

  /**
   * Prints the immutable value {@code StaticClassApplication} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "StaticClassApplication{"
        + "clazz=" + clazz
        + ", isEnabled=" + isEnabled
        + "}";
  }

  /**
   * Construct a new immutable {@code StaticClassApplication} instance.
 * @param <T> generic parameter T
   * @param clazz The value for the {@code clazz} attribute
   * @param isEnabled The value for the {@code isEnabled} attribute
   * @return An immutable StaticClassApplication instance
   */
  public static <T extends Application.Factory> ImmutableStaticClassApplication<T> of(Class<T> clazz, boolean isEnabled) {
    return validate(new ImmutableStaticClassApplication<>(clazz, isEnabled));
  }

  private static <T extends Application.Factory> ImmutableStaticClassApplication<T> validate(ImmutableStaticClassApplication<T> instance) {
    instance.checkClazz();
    return instance;
  }
}
