package io.deephaven.appmode;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StandardField}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStandardField.builder()}.
 */
@Generated(from = "StandardField", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableStandardField<T> extends StandardField<T> {
  private final String name;
  private final T value;
  private final @Nullable String description;

  private ImmutableStandardField(ImmutableStandardField.Builder<T> builder) {
    this.name = builder.name;
    this.value = builder.value;
    this.description = builder.description;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public T value() {
    return value;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public Optional<String> description() {
    return Optional.ofNullable(description);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStandardField} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStandardField<?>
        && equalsByValue((ImmutableStandardField<?>) another);
  }

  private boolean equalsByValue(ImmutableStandardField<?> another) {
    return name.equals(another.name)
        && value.equals(another.value)
        && Objects.equals(description, another.description);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code value}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + getClass().hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + value.hashCode();
    h += (h << 5) + Objects.hashCode(description);
    return h;
  }

  /**
   * Prints the immutable value {@code StandardField} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("StandardField{");
    builder.append("name=").append(name);
    builder.append(", ");
    builder.append("value=").append(value);
    if (description != null) {
      builder.append(", ");
      builder.append("description=").append(description);
    }
    return builder.append("}").toString();
  }

  private static <T> ImmutableStandardField<T> validate(ImmutableStandardField<T> instance) {
    instance.checkDescription();
    instance.checkName();
    return instance;
  }

  /**
   * Creates a builder for {@link ImmutableStandardField ImmutableStandardField}.
   * <pre>
   * ImmutableStandardField.&lt;T&gt;builder()
   *    .name(String) // required {@link StandardField#name() name}
   *    .value(T) // required {@link StandardField#value() value}
   *    .description(Optional&lt;String&gt;) // optional {@link StandardField#description() description}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableStandardField builder
   */
  public static <T> ImmutableStandardField.Builder<T> builder() {
    return new ImmutableStandardField.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableStandardField ImmutableStandardField}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StandardField", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private static final long OPT_BIT_DESCRIPTION = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private @Nullable String name;
    private @Nullable T value;
    private @Nullable String description;

    private Builder() {
    }

    /**
     * Initializes the value for the {@link StandardField#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> name(String name) {
      checkNotIsSet(nameIsSet(), "name");
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link StandardField#value() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> value(T value) {
      checkNotIsSet(valueIsSet(), "value");
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the optional value {@link StandardField#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> description(String description) {
      checkNotIsSet(descriptionIsSet(), "description");
      this.description = Objects.requireNonNull(description, "description");
      optBits |= OPT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Initializes the optional value {@link StandardField#description() description} to description.
     * @param description The value for description
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> description(Optional<String> description) {
      checkNotIsSet(descriptionIsSet(), "description");
      this.description = description.orElse(null);
      optBits |= OPT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableStandardField ImmutableStandardField}.
     * @return An immutable instance of StandardField
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStandardField<T> build() {
      checkRequiredAttributes();
      return ImmutableStandardField.validate(new ImmutableStandardField<T>(this));
    }

    private boolean descriptionIsSet() {
      return (optBits & OPT_BIT_DESCRIPTION) != 0;
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private boolean valueIsSet() {
      return (initBits & INIT_BIT_VALUE) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of StandardField is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!nameIsSet()) attributes.add("name");
      if (!valueIsSet()) attributes.add("value");
      return "Cannot build StandardField, some of required attributes are not set " + attributes;
    }
  }
}
