package io.deephaven.appmode;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ScriptApplication}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableScriptApplication.builder()}.
 */
@Generated(from = "ScriptApplication", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableScriptApplication extends ScriptApplication {
  private final String id;
  private final String name;
  private final List<Path> files;
  private final boolean isEnabled;
  private final String scriptType;

  private ImmutableScriptApplication(ImmutableScriptApplication.Builder builder) {
    this.id = builder.id;
    this.name = builder.name;
    this.files = createUnmodifiableList(true, builder.files);
    this.scriptType = builder.scriptType;
    this.isEnabled = builder.isEnabledIsSet()
        ? builder.isEnabled
        : super.isEnabled();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code files} attribute
   */
  @Override
  public List<Path> files() {
    return files;
  }

  /**
   * @return The value of the {@code isEnabled} attribute
   */
  @Override
  public boolean isEnabled() {
    return isEnabled;
  }

  /**
   * @return The value of the {@code scriptType} attribute
   */
  @Override
  public String scriptType() {
    return scriptType;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableScriptApplication} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableScriptApplication
        && equalsByValue((ImmutableScriptApplication) another);
  }

  private boolean equalsByValue(ImmutableScriptApplication another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && files.equals(another.files)
        && isEnabled == another.isEnabled
        && scriptType.equals(another.scriptType);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code files}, {@code isEnabled}, {@code scriptType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + getClass().hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + files.hashCode();
    h += (h << 5) + Boolean.hashCode(isEnabled);
    h += (h << 5) + scriptType.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ScriptApplication} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ScriptApplication{"
        + "id=" + id
        + ", name=" + name
        + ", files=" + files
        + ", isEnabled=" + isEnabled
        + ", scriptType=" + scriptType
        + "}";
  }

  private static ImmutableScriptApplication validate(ImmutableScriptApplication instance) {
    instance.checkNotEmpty();
    return instance;
  }

  /**
   * Creates a builder for {@link ImmutableScriptApplication ImmutableScriptApplication}.
   * <pre>
   * ImmutableScriptApplication.builder()
   *    .id(String) // required {@link ScriptApplication#id() id}
   *    .name(String) // required {@link ScriptApplication#name() name}
   *    .addFiles|addAllFiles(java.nio.file.Path) // {@link ScriptApplication#files() files} elements
   *    .isEnabled(boolean) // optional {@link ScriptApplication#isEnabled() isEnabled}
   *    .scriptType(String) // required {@link ScriptApplication#scriptType() scriptType}
   *    .build();
   * </pre>
   * @return A new ImmutableScriptApplication builder
   */
  public static ImmutableScriptApplication.Builder builder() {
    return new ImmutableScriptApplication.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableScriptApplication ImmutableScriptApplication}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ScriptApplication", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder implements ScriptApplication.Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_SCRIPT_TYPE = 0x4L;
    private static final long OPT_BIT_IS_ENABLED = 0x1L;
    private long initBits = 0x7L;
    private long optBits;

    private @Nullable String id;
    private @Nullable String name;
    private final List<Path> files = new ArrayList<Path>();
    private boolean isEnabled;
    private @Nullable String scriptType;

    private Builder() {
    }

    /**
     * Initializes the value for the {@link ScriptApplication#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      checkNotIsSet(idIsSet(), "id");
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ScriptApplication#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      checkNotIsSet(nameIsSet(), "name");
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link ScriptApplication#files() files} list.
     * @param element A files element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFiles(Path element) {
      this.files.add(Objects.requireNonNull(element, "files element"));
      return this;
    }

    /**
     * Adds elements to {@link ScriptApplication#files() files} list.
     * @param elements An array of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFiles(Path... elements) {
      for (Path element : elements) {
        this.files.add(Objects.requireNonNull(element, "files element"));
      }
      return this;
    }


    /**
     * Adds elements to {@link ScriptApplication#files() files} list.
     * @param elements An iterable of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFiles(Iterable<? extends Path> elements) {
      for (Path element : elements) {
        this.files.add(Objects.requireNonNull(element, "files element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ScriptApplication#isEnabled() isEnabled} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ScriptApplication#isEnabled() isEnabled}.</em>
     * @param isEnabled The value for isEnabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isEnabled(boolean isEnabled) {
      checkNotIsSet(isEnabledIsSet(), "isEnabled");
      this.isEnabled = isEnabled;
      optBits |= OPT_BIT_IS_ENABLED;
      return this;
    }

    /**
     * Initializes the value for the {@link ScriptApplication#scriptType() scriptType} attribute.
     * @param scriptType The value for scriptType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder scriptType(String scriptType) {
      checkNotIsSet(scriptTypeIsSet(), "scriptType");
      this.scriptType = Objects.requireNonNull(scriptType, "scriptType");
      initBits &= ~INIT_BIT_SCRIPT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableScriptApplication ImmutableScriptApplication}.
     * @return An immutable instance of ScriptApplication
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableScriptApplication build() {
      checkRequiredAttributes();
      return ImmutableScriptApplication.validate(new ImmutableScriptApplication(this));
    }

    private boolean isEnabledIsSet() {
      return (optBits & OPT_BIT_IS_ENABLED) != 0;
    }

    private boolean idIsSet() {
      return (initBits & INIT_BIT_ID) == 0;
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private boolean scriptTypeIsSet() {
      return (initBits & INIT_BIT_SCRIPT_TYPE) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of ScriptApplication is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!idIsSet()) attributes.add("id");
      if (!nameIsSet()) attributes.add("name");
      if (!scriptTypeIsSet()) attributes.add("scriptType");
      return "Cannot build ScriptApplication, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
