package io.deephaven.appmode;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Fields}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFields.builder()}.
 */
@Generated(from = "Fields", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableFields extends Fields {
  private final Map<String, Field<?>> fields;

  private ImmutableFields(ImmutableFields.Builder builder) {
    this.fields = createUnmodifiableMap(false, false, builder.fields);
  }

  /**
   * @return The value of the {@code fields} attribute
   */
  @Override
  Map<String, Field<?>> fields() {
    return fields;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFields} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFields
        && equalsByValue((ImmutableFields) another);
  }

  private boolean equalsByValue(ImmutableFields another) {
    return fields.equals(another.fields);
  }

  /**
   * Computes a hash code from attributes: {@code fields}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + getClass().hashCode();
    h += (h << 5) + fields.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Fields} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Fields{"
        + "fields=" + fields
        + "}";
  }

  private static ImmutableFields validate(ImmutableFields instance) {
    instance.checkKeys();
    return instance;
  }

  /**
   * Creates a builder for {@link ImmutableFields ImmutableFields}.
   * <pre>
   * ImmutableFields.builder()
   *    .putFields|putAllFields(String =&gt; io.deephaven.appmode.Field&lt;?&gt;) // {@link Fields#fields() fields} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableFields builder
   */
  public static ImmutableFields.Builder builder() {
    return new ImmutableFields.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFields ImmutableFields}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Fields", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder implements Fields.Builder {
    private final Map<String, Field<?>> fields = new LinkedHashMap<String, Field<?>>();

    private Builder() {
    }

    /**
     * Put one entry to the {@link Fields#fields() fields} map.
     * @param key The key in the fields map
     * @param value The associated value in the fields map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putFields(String key, Field<?> value) {
      this.fields.put(
          Objects.requireNonNull(key, "fields key"),
          Objects.requireNonNull(value, value == null ? "fields value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link Fields#fields() fields} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putFields(Map.Entry<String, ? extends Field<?>> entry) {
      String k = entry.getKey();
      Field<?> v = entry.getValue();
      this.fields.put(
          Objects.requireNonNull(k, "fields key"),
          Objects.requireNonNull(v, v == null ? "fields value for key: " + k : null));
      return this;
    }

    /**
     * Put all mappings from the specified map as entries to {@link Fields#fields() fields} map. Nulls are not permitted
     * @param entries The entries that will be added to the fields map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllFields(Map<String, ? extends Field<?>> entries) {
      for (Map.Entry<String, ? extends Field<?>> e : entries.entrySet()) {
        String k = e.getKey();
        Field<?> v = e.getValue();
        this.fields.put(
            Objects.requireNonNull(k, "fields key"),
            Objects.requireNonNull(v, v == null ? "fields value for key: " + k : null));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableFields ImmutableFields}.
     * @return An immutable instance of Fields
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFields build() {
      return ImmutableFields.validate(new ImmutableFields(this));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
