package io.deephaven.appmode;

import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DynamicApplication}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableDynamicApplication.of()}.
 */
@Generated(from = "DynamicApplication", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableDynamicApplication<T extends ApplicationState.Factory>
    extends DynamicApplication<T> {
  private final Class<T> clazz;
  private final boolean isEnabled;

  private ImmutableDynamicApplication(Class<T> clazz, boolean isEnabled) {
    this.clazz = Objects.requireNonNull(clazz, "clazz");
    this.isEnabled = isEnabled;
  }

  /**
   * @return The value of the {@code clazz} attribute
   */
  @Override
  public Class<T> clazz() {
    return clazz;
  }

  /**
   * @return The value of the {@code isEnabled} attribute
   */
  @Override
  public boolean isEnabled() {
    return isEnabled;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDynamicApplication} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDynamicApplication<?>
        && equalsByValue((ImmutableDynamicApplication<?>) another);
  }

  private boolean equalsByValue(ImmutableDynamicApplication<?> another) {
    return clazz.equals(another.clazz)
        && isEnabled == another.isEnabled;
  }

  /**
   * Computes a hash code from attributes: {@code clazz}, {@code isEnabled}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + getClass().hashCode();
    h += (h << 5) + clazz.hashCode();
    h += (h << 5) + Boolean.hashCode(isEnabled);
    return h;
  }

  /**
   * Prints the immutable value {@code DynamicApplication} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DynamicApplication{"
        + "clazz=" + clazz
        + ", isEnabled=" + isEnabled
        + "}";
  }

  /**
   * Construct a new immutable {@code DynamicApplication} instance.
 * @param <T> generic parameter T
   * @param clazz The value for the {@code clazz} attribute
   * @param isEnabled The value for the {@code isEnabled} attribute
   * @return An immutable DynamicApplication instance
   */
  public static <T extends ApplicationState.Factory> ImmutableDynamicApplication<T> of(Class<T> clazz, boolean isEnabled) {
    return validate(new ImmutableDynamicApplication<>(clazz, isEnabled));
  }

  private static <T extends ApplicationState.Factory> ImmutableDynamicApplication<T> validate(ImmutableDynamicApplication<T> instance) {
    instance.checkClazz();
    return instance;
  }
}
