package io.deephaven.appmode;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Application}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableApplication.builder()}.
 */
@Generated(from = "Application", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableApplication extends Application {
  private final String id;
  private final String name;
  private final Fields fields;

  private ImmutableApplication(ImmutableApplication.Builder builder) {
    this.id = builder.id;
    this.name = builder.name;
    this.fields = builder.fields;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code fields} attribute
   */
  @Override
  public Fields fields() {
    return fields;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableApplication} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableApplication
        && equalsByValue((ImmutableApplication) another);
  }

  private boolean equalsByValue(ImmutableApplication another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && fields.equals(another.fields);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code fields}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + getClass().hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + fields.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Application} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Application{"
        + "id=" + id
        + ", name=" + name
        + ", fields=" + fields
        + "}";
  }

  /**
   * Creates a builder for {@link ImmutableApplication ImmutableApplication}.
   * <pre>
   * ImmutableApplication.builder()
   *    .id(String) // required {@link Application#id() id}
   *    .name(String) // required {@link Application#name() name}
   *    .fields(io.deephaven.appmode.Fields) // required {@link Application#fields() fields}
   *    .build();
   * </pre>
   * @return A new ImmutableApplication builder
   */
  public static ImmutableApplication.Builder builder() {
    return new ImmutableApplication.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableApplication ImmutableApplication}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Application", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder implements Application.Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_FIELDS = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String id;
    private @Nullable String name;
    private @Nullable Fields fields;

    private Builder() {
    }

    /**
     * Initializes the value for the {@link Application#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      checkNotIsSet(idIsSet(), "id");
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Application#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      checkNotIsSet(nameIsSet(), "name");
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Application#fields() fields} attribute.
     * @param fields The value for fields 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder fields(Fields fields) {
      checkNotIsSet(fieldsIsSet(), "fields");
      this.fields = Objects.requireNonNull(fields, "fields");
      initBits &= ~INIT_BIT_FIELDS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableApplication ImmutableApplication}.
     * @return An immutable instance of Application
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableApplication build() {
      checkRequiredAttributes();
      return new ImmutableApplication(this);
    }

    private boolean idIsSet() {
      return (initBits & INIT_BIT_ID) == 0;
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private boolean fieldsIsSet() {
      return (initBits & INIT_BIT_FIELDS) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of Application is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!idIsSet()) attributes.add("id");
      if (!nameIsSet()) attributes.add("name");
      if (!fieldsIsSet()) attributes.add("fields");
      return "Cannot build Application, some of required attributes are not set " + attributes;
    }
  }
}
