/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.util.tables;

import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.plot.errors.PlotIllegalStateException;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.PartitionedTableHandle;
import io.deephaven.plot.util.tables.TableHandle;
import java.util.Collection;

public class TableBackedPartitionedTableHandle
extends PartitionedTableHandle {
    private transient Table table;
    private final TableDefinition tableDefinition;

    public TableBackedPartitionedTableHandle(TableHandle tableHandle, String[] keyColumns, PlotInfo plotInfo) {
        this(tableHandle.getTable(), tableHandle.getColumns(), keyColumns, plotInfo);
    }

    public TableBackedPartitionedTableHandle(Table table, Collection<String> columns, String[] keyColumns, PlotInfo plotInfo) {
        super(columns, keyColumns, plotInfo);
        ArgumentValidations.assertNotNull(table, "table", plotInfo);
        this.table = table;
        this.tableDefinition = table.getDefinition();
    }

    public Table getTable() {
        if (this.table == null) {
            throw new PlotIllegalStateException("Null table", this);
        }
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public TableDefinition getTableDefinition() {
        return this.tableDefinition;
    }
}

