/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.util.tables;

import io.deephaven.engine.table.PartitionedTable;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.plot.errors.PlotExceptionCause;
import io.deephaven.plot.errors.PlotInfo;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

public abstract class PartitionedTableHandle
implements Serializable,
PlotExceptionCause {
    private static final AtomicInteger nextId = new AtomicInteger();
    private transient PartitionedTable partitionedTable;
    private String[] orderedKeyColumns;
    private final Set<String> requiredColumns;
    private final Set<String> keyColumns;
    private final int id = nextId.incrementAndGet();
    private boolean oneClickMap = false;
    private final PlotInfo plotInfo;

    protected PartitionedTableHandle(Collection<String> columns, String[] keyColumns, PlotInfo plotInfo) {
        this.requiredColumns = new LinkedHashSet<String>(columns);
        Collections.addAll(this.requiredColumns, keyColumns);
        this.keyColumns = new LinkedHashSet<String>(Arrays.asList(keyColumns));
        this.plotInfo = plotInfo;
    }

    public abstract TableDefinition getTableDefinition();

    public PartitionedTable getPartitionedTable() {
        return this.partitionedTable;
    }

    public void setPartitionedTable(PartitionedTable partitionedTable) {
        this.partitionedTable = partitionedTable;
    }

    public void setKeyColumnsOrdered(String[] orderedKeyColumns) {
        this.orderedKeyColumns = orderedKeyColumns;
    }

    public int id() {
        return this.id;
    }

    public void addColumn(String column) {
        this.requiredColumns.add(column);
    }

    public Set<String> getColumns() {
        return this.requiredColumns;
    }

    public Set<String> getFetchViewColumns() {
        return this.getColumns();
    }

    public Set<String> getKeyColumns() {
        return this.keyColumns;
    }

    public String[] getKeyColumnsOrdered() {
        return this.orderedKeyColumns;
    }

    @Override
    public PlotInfo getPlotInfo() {
        return this.plotInfo;
    }

    public void setOneClickMap(boolean isOneClick) {
        this.oneClickMap = isOneClick;
    }

    public boolean isOneClickMap() {
        return this.oneClickMap;
    }

    public void applyFunction(Function<Table, Table> function) {
    }
}

