/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.util;

import io.deephaven.base.verify.Require;
import java.io.Serializable;

public class Range
implements Serializable {
    private static final long serialVersionUID = 5886019742599081727L;
    private final double min;
    private final double max;
    private final boolean minOpen;
    private final boolean maxOpen;

    public Range(double min, double max) {
        this(min, max, false, true);
    }

    public Range(double min, double max, boolean minOpen, boolean maxOpen) {
        Require.geq((double)max, (String)"max", (double)min, (String)"min");
        this.min = min;
        this.max = max;
        this.minOpen = minOpen;
        this.maxOpen = maxOpen;
    }

    public boolean inRange(double d) {
        if (this.minOpen ? d <= this.min : d < this.min) {
            return false;
        }
        return !(this.maxOpen ? d >= this.max : d > this.max);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }
}

