/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.util;

import io.deephaven.api.ColumnName;
import io.deephaven.api.agg.Aggregation;
import io.deephaven.base.verify.Require;
import io.deephaven.engine.context.QueryScope;
import io.deephaven.engine.table.ColumnSource;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.engine.table.impl.BaseTable;
import io.deephaven.engine.table.impl.QueryTable;
import io.deephaven.engine.table.impl.util.ColumnHolder;
import io.deephaven.engine.table.vectors.ColumnVectors;
import io.deephaven.engine.util.TableTools;
import io.deephaven.function.Numeric;
import io.deephaven.gui.color.Color;
import io.deephaven.gui.color.ColorPalette;
import io.deephaven.gui.color.ColorPaletteArray;
import io.deephaven.gui.color.Paint;
import io.deephaven.gui.table.filters.Condition;
import io.deephaven.plot.ChartImpl;
import io.deephaven.plot.datasets.data.IndexableData;
import io.deephaven.plot.datasets.data.IndexableDataArray;
import io.deephaven.plot.datasets.data.IndexableDataArrayNullCategory;
import io.deephaven.plot.datasets.data.IndexableDataByte;
import io.deephaven.plot.datasets.data.IndexableDataCharacter;
import io.deephaven.plot.datasets.data.IndexableDataDouble;
import io.deephaven.plot.datasets.data.IndexableDataInstant;
import io.deephaven.plot.datasets.data.IndexableDataInteger;
import io.deephaven.plot.datasets.data.IndexableDataListNullCategory;
import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayDate;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayDouble;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayFloat;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayInstant;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayInt;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayLong;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayNumber;
import io.deephaven.plot.datasets.data.IndexableNumericDataArrayShort;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.TableBackedPartitionedTableHandle;
import io.deephaven.plot.util.tables.TableHandle;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.vector.Vector;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class PlotUtils {
    private static final ColorPaletteArray MATPLOT_COLORS = new ColorPaletteArray(ColorPaletteArray.Palette.MATPLOTLIB);
    private static final Random rng = new Random();
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final short[] EMPTY_SHORT_ARRAY = new short[0];
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Number[] EMPTY_NUMBER_ARRAY = new Number[0];
    private static final Date[] EMPTY_DATE_ARRAY = new Date[0];
    private static final Instant[] EMPTY_INSTANT_ARRAY = new Instant[0];

    private PlotUtils() {
    }

    private static int randVar() {
        return Numeric.abs((int)rng.nextInt());
    }

    public static String uniqueVarName(String root) {
        while (true) {
            String name = root + PlotUtils.randVar();
            try {
                QueryScope.getParamValue((String)name);
            }
            catch (QueryScope.MissingVariableException e) {
                return name;
            }
        }
    }

    @Deprecated
    public static Paint intToColor(ChartImpl chart, Integer color) {
        return PlotUtils.intToColor(color);
    }

    public static Paint intToColor(Integer color) {
        return color == null || color == Integer.MIN_VALUE || color < 0 ? null : MATPLOT_COLORS.get(color.intValue());
    }

    public static double numberToDouble(Number n) {
        if (n == null) {
            return Double.NaN;
        }
        if (n instanceof Short) {
            return n.shortValue() == Short.MIN_VALUE ? Double.NaN : n.doubleValue();
        }
        if (n instanceof Integer) {
            return n.intValue() == Integer.MIN_VALUE ? Double.NaN : n.doubleValue();
        }
        if (n instanceof Long) {
            return n.longValue() == Long.MIN_VALUE ? Double.NaN : n.doubleValue();
        }
        if (n instanceof Float) {
            return n.floatValue() == -3.4028235E38f ? Double.NaN : n.doubleValue();
        }
        if (n instanceof Double) {
            return n.doubleValue() == -1.7976931348623157E308 ? Double.NaN : n.doubleValue();
        }
        if (n instanceof BigDecimal) {
            return n.doubleValue() == -1.7976931348623157E308 ? Double.NaN : n.doubleValue();
        }
        throw new UnsupportedOperationException("Unsupported Number type: " + String.valueOf(n.getClass()));
    }

    public static <T> Table table(T[] x, String colName) {
        Require.neqNull(x, (String)"x");
        return TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.col((String)colName, (Object[])x)});
    }

    public static <T> Table table(List<T> x, String colName) {
        Require.neqNull(x, (String)"x");
        Object[] xx = x.toArray();
        return TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.col((String)colName, (Object[])xx)});
    }

    public static Table table(short[] x, String colName) {
        Require.neqNull((Object)x, (String)"x");
        return TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.shortCol((String)colName, (short[])x)});
    }

    public static Table table(int[] x, String colName) {
        Require.neqNull((Object)x, (String)"x");
        return TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.intCol((String)colName, (int[])x)});
    }

    public static Table table(long[] x, String colName) {
        Require.neqNull((Object)x, (String)"x");
        return TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.longCol((String)colName, (long[])x)});
    }

    public static Table table(float[] x, String colName) {
        Require.neqNull((Object)x, (String)"x");
        return TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.floatCol((String)colName, (float[])x)});
    }

    public static Table table(double[] x, String colName) {
        Require.neqNull((Object)x, (String)"x");
        return TableTools.newTable((ColumnHolder[])new ColumnHolder[]{TableTools.doubleCol((String)colName, (double[])x)});
    }

    public static <T extends Number> Table doubleTable(T[] x, String colName) {
        return (Table)PlotUtils.table(x, "X").view(new String[]{colName + " = X==null ? Double.NaN : X.doubleValue()"});
    }

    public static <T extends Number> Table doubleTable(List<T> x, String colName) {
        return (Table)((Table)PlotUtils.table(x, "X").updateView(new String[]{"__Class__ = X.getClass()"})).view(new String[]{colName + " = __Class__==Double.class ? X=NULL_DOUBLE ? Double.NaN : ((Double) X).doubleValue() : __Class__==Short.class ? X=NULL_SHORT ? Double.NaN : ((Short) X).doubleValue() : __Class__==Long.class ? X=NULL_LONG ? Double.NaN : ((Long) X).doubleValue() : __Class__==Integer.class ? X=NULL_INT ? Double.NaN : ((Integer) X).doubleValue() : __Class__==Float.class ? X==NULL_FLOAT ? Double.NaN : ((Float) X).doubleValue(): Double.NaN"});
    }

    public static Table doubleTable(short[] x, String colName) {
        return (Table)PlotUtils.table(x, "X").view(new String[]{colName + " = isNull(X) ? Double.NaN : X"});
    }

    public static Table doubleTable(int[] x, String colName) {
        return (Table)PlotUtils.table(x, "X").view(new String[]{colName + " = isNull(X) ? Double.NaN : X"});
    }

    public static Table doubleTable(long[] x, String colName) {
        return (Table)PlotUtils.table(x, "X").view(new String[]{colName + " = isNull(X) ? Double.NaN : X"});
    }

    public static Table doubleTable(float[] x, String colName) {
        return (Table)PlotUtils.table(x, "X").view(new String[]{colName + " = isNull(X) ? Double.NaN : X"});
    }

    public static Table doubleTable(double[] x, String colName) {
        return (Table)PlotUtils.table(x, "X").view(new String[]{colName + " = isNull(X) ? Double.NaN : X"});
    }

    public static Table doubleTable(Double[] x, String colName) {
        return (Table)PlotUtils.table(x, "X").view(new String[]{colName + " = isNull(X) ? Double.NaN : X"});
    }

    public static Table doubleTable(Short[] x, String colName) {
        return (Table)PlotUtils.table(x, "X").view(new String[]{colName + " = isNull(X) ? Double.NaN : X"});
    }

    public static Table doubleTable(Long[] x, String colName) {
        return (Table)PlotUtils.table(x, "X").view(new String[]{colName + " = isNull(X) ? Double.NaN : X"});
    }

    public static Table doubleTable(Float[] x, String colName) {
        return (Table)PlotUtils.table(x, "X").view(new String[]{colName + " = isNull(X) ? Double.NaN : X"});
    }

    public static Table doubleTable(Integer[] x, String colName) {
        return (Table)PlotUtils.table(x, "X").view(new String[]{colName + " = isNull(X) ? Double.NaN : X"});
    }

    public static float[] toFloat(double[] x) {
        if (x == null) {
            return null;
        }
        float[] result = new float[x.length];
        IntStream.range(0, x.length).forEach(i -> {
            result[i] = x[i] == -1.7976931348623157E308 ? Float.NaN : (float)x[i];
        });
        return result;
    }

    public static float[] toFloat(int[] x) {
        if (x == null) {
            return null;
        }
        float[] result = new float[x.length];
        IntStream.range(0, x.length).forEach(i -> {
            result[i] = x[i] == Integer.MIN_VALUE ? Float.NaN : (float)x[i];
        });
        return result;
    }

    public static float[] toFloat(long[] x) {
        if (x == null) {
            return null;
        }
        float[] result = new float[x.length];
        IntStream.range(0, x.length).forEach(i -> {
            result[i] = x[i] == Long.MIN_VALUE ? Float.NaN : (float)x[i];
        });
        return result;
    }

    public static <T extends Number> float[] toFloat(T[] x) {
        if (x == null) {
            return null;
        }
        float[] result = new float[x.length];
        IntStream.range(0, x.length).forEach(i -> {
            result[i] = x[i] == null ? Float.NaN : x[i].floatValue();
        });
        return result;
    }

    public static double[] toDouble(float[] x) {
        if (x == null) {
            return null;
        }
        double[] result = new double[x.length];
        IntStream.range(0, x.length).forEach(i -> {
            result[i] = x[i] == -3.4028235E38f ? Double.NaN : (double)x[i];
        });
        return result;
    }

    public static double[] toDouble(int[] x) {
        if (x == null) {
            return null;
        }
        double[] result = new double[x.length];
        IntStream.range(0, x.length).forEach(i -> {
            result[i] = x[i] == Integer.MIN_VALUE ? Double.NaN : (double)x[i];
        });
        return result;
    }

    public static double[] toDouble(long[] x) {
        if (x == null) {
            return null;
        }
        double[] result = new double[x.length];
        IntStream.range(0, x.length).forEach(i -> {
            result[i] = x[i] == Long.MIN_VALUE ? Double.NaN : (double)x[i];
        });
        return result;
    }

    public static <T extends Number> double[] toDouble(T[] x) {
        if (x == null) {
            return null;
        }
        double[] result = new double[x.length];
        IntStream.range(0, x.length).forEach(i -> {
            result[i] = x[i] == null ? Double.NaN : x[i].doubleValue();
        });
        return result;
    }

    public static Color[] getNColors(ColorPalette colorPalette, int n) {
        Require.neqNull((Object)colorPalette, (String)"colorPalette");
        Require.gt((int)n, (String)"n", (int)0);
        Color[] colors = new Color[n];
        for (int counter = 0; counter < n; ++counter) {
            colors[counter] = colorPalette.get(counter);
        }
        return colors;
    }

    public static double minIgnoreNaN(double ... values) {
        double min = Double.NaN;
        if (values == null) {
            return min;
        }
        for (double value : values) {
            min = PlotUtils.minIgnoreNaN(min, value);
        }
        return min;
    }

    public static double minIgnoreNaN(double oldMin, double value) {
        if (oldMin == -1.7976931348623157E308) {
            return value;
        }
        if (value == -1.7976931348623157E308) {
            return oldMin;
        }
        return Double.isNaN(oldMin) || value < oldMin ? value : oldMin;
    }

    public static double maxIgnoreNaN(double ... values) {
        double max = Double.NaN;
        if (values == null) {
            return max;
        }
        for (double value : values) {
            max = PlotUtils.maxIgnoreNaN(max, value);
        }
        return max;
    }

    public static double maxIgnoreNaN(double oldMin, double value) {
        if (oldMin == -1.7976931348623157E308) {
            return value;
        }
        if (value == -1.7976931348623157E308) {
            return oldMin;
        }
        return Double.isNaN(oldMin) || value > oldMin ? value : oldMin;
    }

    public static float minIgnoreNaN(float oldMin, float value) {
        if (oldMin == -3.4028235E38f) {
            return value;
        }
        if (value == -3.4028235E38f) {
            return oldMin;
        }
        return Float.isNaN(oldMin) || value < oldMin ? value : oldMin;
    }

    public static float maxIgnoreNaN(float oldMin, float value) {
        if (oldMin == -3.4028235E38f) {
            return value;
        }
        if (value == -3.4028235E38f) {
            return oldMin;
        }
        return Float.isNaN(oldMin) || value > oldMin ? value : oldMin;
    }

    public static int minIgnoreNull(int oldMin, int value) {
        if (oldMin == Integer.MIN_VALUE) {
            return value;
        }
        if (value == Integer.MIN_VALUE) {
            return oldMin;
        }
        return Math.min(value, oldMin);
    }

    public static int maxIgnoreNull(int oldMin, int value) {
        if (oldMin == Integer.MIN_VALUE) {
            return value;
        }
        if (value == Integer.MIN_VALUE) {
            return oldMin;
        }
        return Math.max(value, oldMin);
    }

    public static short minIgnoreNull(short oldMin, short value) {
        if (oldMin == Short.MIN_VALUE) {
            return value;
        }
        if (value == Short.MIN_VALUE) {
            return oldMin;
        }
        return value < oldMin ? value : oldMin;
    }

    public static short maxIgnoreNull(short oldMin, short value) {
        if (oldMin == Short.MIN_VALUE) {
            return value;
        }
        if (value == Short.MIN_VALUE) {
            return oldMin;
        }
        return value > oldMin ? value : oldMin;
    }

    public static long minIgnoreNull(long oldMin, long value) {
        if (oldMin == Long.MIN_VALUE) {
            return value;
        }
        if (value == Long.MIN_VALUE) {
            return oldMin;
        }
        return Math.min(value, oldMin);
    }

    public static long maxIgnoreNull(long oldMin, long value) {
        if (oldMin == Long.MIN_VALUE) {
            return value;
        }
        if (value == Long.MIN_VALUE) {
            return oldMin;
        }
        return Math.max(value, oldMin);
    }

    public static TableHandle createCategoryTableHandle(Table t, String catColumn, String ... otherColumns) {
        return PlotUtils.createCategoryTableHandle(t, new String[]{catColumn}, otherColumns);
    }

    public static TableHandle createCategoryTableHandle(Table t, String[] catColumns, String ... otherColumns) {
        t = PlotUtils.createCategoryTable(t, catColumns);
        String[] cols = new String[otherColumns.length + catColumns.length + 1];
        System.arraycopy(catColumns, 0, cols, 0, catColumns.length);
        System.arraycopy(otherColumns, 0, cols, catColumns.length, otherColumns.length);
        cols[cols.length - 1] = "__CAT_ORDER";
        return new TableHandle(t, cols);
    }

    public static TableBackedPartitionedTableHandle createCategoryPartitionedTableHandle(Table t, String catColumn, String[] otherColumns, String[] byColumns, PlotInfo plotInfo) {
        return PlotUtils.createCategoryPartitionedTableHandle(t, new String[]{catColumn}, otherColumns, byColumns, plotInfo);
    }

    public static TableBackedPartitionedTableHandle createCategoryPartitionedTableHandle(Table t, String[] catColumns, String[] otherColumns, String[] byColumns, PlotInfo plotInfo) {
        String[] lastByColumns = new String[catColumns.length + byColumns.length];
        System.arraycopy(catColumns, 0, lastByColumns, 0, catColumns.length);
        System.arraycopy(byColumns, 0, lastByColumns, catColumns.length, byColumns.length);
        t = PlotUtils.createCategoryTable(t, lastByColumns);
        HashSet<String> columns = new HashSet<String>();
        Collections.addAll(columns, otherColumns);
        Collections.addAll(columns, lastByColumns);
        columns.add("__CAT_ORDER");
        return new TableBackedPartitionedTableHandle(t, columns, byColumns, plotInfo);
    }

    public static Table createCategoryTable(Table t, String[] catColumns) {
        List lastColumns = t.getDefinition().getColumnNames();
        lastColumns.removeAll(Arrays.asList(catColumns));
        QueryTable result = (QueryTable)t.aggBy(PlotUtils.createCategoryAggs(Aggregation.AggLast((String[])((String[])lastColumns.toArray(String[]::new)))), (Collection)ColumnName.from((String[])catColumns));
        ((BaseTable)t).copyAttributes((BaseTable)result, BaseTable.CopyAttributeOperation.LastBy);
        return result;
    }

    public static Table createCategoryHistogramTable(Table t, String ... byColumns) {
        return (Table)t.aggBy(PlotUtils.createCategoryAggs((Aggregation)Aggregation.AggCount((String)"Count")), (Collection)ColumnName.from((String[])byColumns));
    }

    public static Collection<? extends Aggregation> createCategoryAggs(Aggregation agg) {
        return List.of(Aggregation.AggFirstRowKey((String)"__CAT_ORDER"), agg);
    }

    public static List<Condition> getColumnConditions(Table arg, String column) {
        return Collections.singletonList(Condition.EQUALS);
    }

    public static Function<Long, Number> getNumberFromNumericOrTimeSource(Table t, String numericCol, PlotInfo plotInfo) {
        ArgumentValidations.isNumericOrTime(t, numericCol, plotInfo);
        ColumnSource columnSource = t.getColumnSource(numericCol);
        if (columnSource.getType() == Instant.class) {
            return key -> {
                Instant instant = (Instant)columnSource.get(key.longValue());
                return instant == null ? Long.MIN_VALUE : DateTimeUtils.epochNanos((Instant)instant);
            };
        }
        if (columnSource.getType() == Date.class) {
            return key -> {
                Date instant = (Date)columnSource.get(key.longValue());
                return instant == null ? Long.MIN_VALUE : instant.getTime() * 1000000L;
            };
        }
        return key -> (Number)columnSource.get(key.longValue());
    }

    public static <T> IndexableData createIndexableData(Table t, String column, PlotInfo plotInfo) {
        Vector vector = ColumnVectors.of((Table)t, (String)column);
        Object o = vector.copyToArray();
        return new IndexableDataArray<Object>((Object[])o, plotInfo);
    }

    public static <T> IndexableData createIndexableData(Map<String, Object> snapshotData, @NotNull TableDefinition tableDefinition, String column, PlotInfo plotInfo) {
        return PlotUtils.createIndexableData(snapshotData, tableDefinition.getColumn(column).getDataType(), column, plotInfo);
    }

    public static <T> IndexableData createIndexableData(Map<String, Object> snapshotData, Class<T> c, String column, PlotInfo plotInfo) {
        if (snapshotData == null) {
            return PlotUtils.createEmptyIndexableData(c, plotInfo);
        }
        return PlotUtils.createIndexableData(snapshotData.get(column), c, plotInfo);
    }

    public static <T> IndexableData createEmptyIndexableData(Class<T> c, PlotInfo plotInfo) {
        if (c.equals(Integer.TYPE)) {
            return new IndexableDataInteger(EMPTY_INT_ARRAY, plotInfo);
        }
        if (c.equals(Double.TYPE)) {
            return new IndexableDataDouble(EMPTY_DOUBLE_ARRAY, false, plotInfo);
        }
        if (c.equals(Float.TYPE)) {
            return new IndexableDataDouble(EMPTY_FLOAT_ARRAY, false, plotInfo);
        }
        if (c.equals(Long.TYPE)) {
            return new IndexableDataDouble(EMPTY_LONG_ARRAY, false, plotInfo);
        }
        if (c.equals(Short.TYPE)) {
            return new IndexableDataDouble(EMPTY_SHORT_ARRAY, false, plotInfo);
        }
        if (c.equals(Character.TYPE)) {
            return new IndexableDataCharacter(EMPTY_CHAR_ARRAY, plotInfo);
        }
        if (c.equals(Byte.TYPE)) {
            return new IndexableDataByte(EMPTY_BYTE_ARRAY, plotInfo);
        }
        return new IndexableDataListNullCategory(Collections.emptyList(), plotInfo);
    }

    public static <T> IndexableData createIndexableData(Object data, PlotInfo plotInfo) {
        if (data instanceof int[]) {
            return new IndexableDataInteger((int[])data, plotInfo);
        }
        if (data instanceof double[]) {
            return new IndexableDataDouble((double[])data, false, plotInfo);
        }
        if (data instanceof float[]) {
            return new IndexableDataDouble((float[])data, false, plotInfo);
        }
        if (data instanceof long[]) {
            return new IndexableDataDouble((long[])data, false, plotInfo);
        }
        if (data instanceof short[]) {
            return new IndexableDataDouble((short[])data, false, plotInfo);
        }
        if (data instanceof char[]) {
            return new IndexableDataCharacter((char[])data, plotInfo);
        }
        if (data instanceof byte[]) {
            return new IndexableDataByte((byte[])data, plotInfo);
        }
        return new IndexableDataArrayNullCategory<Object>((Object[])data, plotInfo);
    }

    public static <T> IndexableData createIndexableData(Object data, Class<T> c, PlotInfo plotInfo) {
        if (c.equals(Integer.TYPE)) {
            return new IndexableDataInteger((int[])data, plotInfo);
        }
        if (c.equals(Double.TYPE)) {
            return new IndexableDataDouble((double[])data, false, plotInfo);
        }
        if (c.equals(Float.TYPE)) {
            return new IndexableDataDouble((float[])data, false, plotInfo);
        }
        if (c.equals(Long.TYPE)) {
            return new IndexableDataDouble((long[])data, false, plotInfo);
        }
        if (c.equals(Short.TYPE)) {
            return new IndexableDataDouble((short[])data, false, plotInfo);
        }
        if (c.equals(Character.TYPE)) {
            return new IndexableDataCharacter((char[])data, plotInfo);
        }
        if (c.equals(Byte.TYPE)) {
            return new IndexableDataByte((byte[])data, plotInfo);
        }
        if (c.equals(Instant.class) && data instanceof long[]) {
            return new IndexableDataInstant((long[])data, plotInfo);
        }
        return new IndexableDataArrayNullCategory<Object>((Object[])data, plotInfo);
    }

    public static <T extends Comparable> IndexableData createIndexableData(T[] data, PlotInfo plotInfo) {
        return new IndexableDataArray<T>(data, plotInfo);
    }

    public static IndexableNumericData createIndexableNumericDataArray(Map<String, Object> data, @NotNull TableHandle th, String column, PlotInfo plotInfo) {
        return PlotUtils.createIndexableNumericDataArray(data, th.getTable(), column, plotInfo);
    }

    public static IndexableNumericData createIndexableNumericDataArray(Map<String, Object> data, @NotNull Table t, String column, PlotInfo plotInfo) {
        return PlotUtils.createIndexableNumericDataArray(data, t.getDefinition(), column, plotInfo);
    }

    public static IndexableNumericData createIndexableNumericDataArray(Map<String, Object> data, @NotNull TableDefinition tableDefinition, String column, PlotInfo plotInfo) {
        if (data == null) {
            if (tableDefinition.getColumn(column) == null) {
                return PlotUtils.createEmptyIndexableNumericDataArray(Double.TYPE, plotInfo);
            }
            return PlotUtils.createEmptyIndexableNumericDataArray(tableDefinition.getColumn(column).getDataType(), plotInfo);
        }
        return PlotUtils.createIndexableNumericDataArray(data.get(column), tableDefinition.getColumn(column).getDataType(), plotInfo);
    }

    public static IndexableNumericData createEmptyIndexableNumericDataArray(Class dataType, PlotInfo plotInfo) {
        if (dataType == Integer.TYPE) {
            return new IndexableNumericDataArrayInt(EMPTY_INT_ARRAY, plotInfo);
        }
        if (dataType == Double.TYPE) {
            return new IndexableNumericDataArrayDouble(EMPTY_DOUBLE_ARRAY, plotInfo);
        }
        if (dataType == Float.TYPE) {
            return new IndexableNumericDataArrayFloat(EMPTY_FLOAT_ARRAY, plotInfo);
        }
        if (dataType == Long.TYPE) {
            return new IndexableNumericDataArrayLong(EMPTY_LONG_ARRAY, plotInfo);
        }
        if (dataType == Short.TYPE) {
            return new IndexableNumericDataArrayShort(EMPTY_SHORT_ARRAY, plotInfo);
        }
        if (dataType == Instant.class) {
            return new IndexableNumericDataArrayInstant(EMPTY_INSTANT_ARRAY, plotInfo);
        }
        if (dataType == Date.class) {
            return new IndexableNumericDataArrayDate(EMPTY_DATE_ARRAY, plotInfo);
        }
        if (Number.class.isAssignableFrom(dataType)) {
            return new IndexableNumericDataArrayNumber(EMPTY_NUMBER_ARRAY, plotInfo);
        }
        throw new UnsupportedOperationException("Can not create IndexableNumericDataArray from type " + String.valueOf(dataType));
    }

    public static IndexableNumericData createIndexableNumericDataArray(Object data, Class dataType, PlotInfo plotInfo) {
        if (dataType == Integer.TYPE) {
            return new IndexableNumericDataArrayInt((int[])data, plotInfo);
        }
        if (dataType == Double.TYPE) {
            return new IndexableNumericDataArrayDouble((double[])data, plotInfo);
        }
        if (dataType == Float.TYPE) {
            return new IndexableNumericDataArrayFloat((float[])data, plotInfo);
        }
        if (dataType == Long.TYPE) {
            return new IndexableNumericDataArrayLong((long[])data, plotInfo);
        }
        if (dataType == Short.TYPE) {
            return new IndexableNumericDataArrayShort((short[])data, plotInfo);
        }
        if (dataType == Instant.class) {
            if (data instanceof long[]) {
                return new IndexableNumericDataArrayLong((long[])data, plotInfo);
            }
            return new IndexableNumericDataArrayInstant((Instant[])data, plotInfo);
        }
        if (dataType == Date.class) {
            return new IndexableNumericDataArrayDate((Date[])data, plotInfo);
        }
        if (Number.class.isAssignableFrom(dataType)) {
            return new IndexableNumericDataArrayNumber((Number[])data, plotInfo);
        }
        throw new UnsupportedOperationException("Can not create IndexableNumericDataArray from type " + String.valueOf(dataType));
    }

    public static class HashMapWithDefault<K, V>
    extends HashMap<K, V> {
        private V def = null;

        public HashMapWithDefault() {
        }

        private HashMapWithDefault(HashMapWithDefault<K, V> map) {
            super(map);
            this.def = map.def;
        }

        public <T> void runIfKeyExistsCast(Consumer<T> consumer, K key) {
            V obj = this.get(key);
            if (obj != null) {
                consumer.accept(obj);
            }
        }

        public void setDefault(V def) {
            this.def = def;
        }

        public V getDefault() {
            return this.def;
        }

        @Override
        public V get(Object key) {
            return super.getOrDefault(key, this.def);
        }

        public HashMapWithDefault<K, V> copy() {
            return new HashMapWithDefault<K, V>(this);
        }
    }
}

