/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.util;

import io.deephaven.base.verify.Require;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.table.ColumnDefinition;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.TableDefinition;
import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.errors.PlotIllegalArgumentException;
import io.deephaven.plot.errors.PlotIllegalStateException;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.errors.PlotRuntimeException;
import io.deephaven.plot.filters.SelectableDataSet;
import io.deephaven.plot.util.tables.TableHandle;
import io.deephaven.util.type.NumericTypeUtils;
import io.deephaven.util.type.TypeUtils;
import java.time.Instant;
import java.util.Date;
import java.util.HashSet;
import org.apache.commons.lang3.ClassUtils;

public class ArgumentValidations {
    private static final boolean ENABLE_X_VALUE_ASSERTIONS = Configuration.getInstance().getBooleanWithDefault("plotting.enableXValueAssertions", true);

    public static void assertGreaterThan0(double d, String name, PlotInfo plotInfo) {
        if (!(d > 0.0)) {
            throw new PlotIllegalArgumentException(name + " must be > 0", plotInfo);
        }
    }

    public static void assertNotNull(Object o, String message, PlotInfo plotInfo) {
        if (o == null) {
            throw new PlotIllegalArgumentException("Null input: " + message, plotInfo);
        }
    }

    public static <T> void assertNotNullAndNotEmpty(T[] o, String message, PlotInfo plotInfo) {
        if (o == null || o.length == 0) {
            throw new PlotIllegalArgumentException("Null or empty input: " + message, plotInfo);
        }
    }

    public static void assertNull(Object o, String message, PlotInfo plotInfo) {
        if (o != null) {
            throw new PlotIllegalArgumentException("Null input: " + message, plotInfo);
        }
    }

    public static void assertInstance(Class c1, Class c2, String message, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(c1, "c1", plotInfo);
        ArgumentValidations.assertNotNull(c2, "c2", plotInfo);
        if (!c1.isAssignableFrom(c2)) {
            throw new PlotRuntimeException(message, plotInfo);
        }
    }

    public static void assertInstance(Table t, String column, Class c, String message, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ColumnDefinition colDef = t.getDefinition().getColumn(column);
        if (colDef == null) {
            throw new PlotRuntimeException("Column not present in table: column=" + column, plotInfo);
        }
        ArgumentValidations.assertInstance(c, ClassUtils.primitiveToWrapper((Class)colDef.getDataType()), message, plotInfo);
    }

    public static void assertInstance(TableDefinition t, String column, Class c, String message, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ColumnDefinition col = t.getColumn(column);
        if (col == null) {
            throw new PlotRuntimeException("Column not present in table: column=" + column, plotInfo);
        }
        ArgumentValidations.assertInstance(c, ClassUtils.primitiveToWrapper((Class)col.getDataType()), message, plotInfo);
    }

    public static void assertInstance(SelectableDataSet sds, String column, Class c, String message, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(sds, "sds", plotInfo);
        ColumnDefinition colDef = sds.getTableDefinition().getColumn(column);
        if (colDef == null) {
            throw new PlotRuntimeException("Column not present in table: column=" + column, plotInfo);
        }
        ArgumentValidations.assertInstance(c, ClassUtils.primitiveToWrapper((Class)colDef.getDataType()), message, plotInfo);
    }

    public static void assertIsNumericOrTimeOrCharOrComparableInstance(Table t, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ArgumentValidations.assertIsNumericOrTimeOrCharOrComparableInstance(t, column, ArgumentValidations.createWrongColumnTypeErrorMessage(t, column, plotInfo, "Numeric", "Time", "Character", "Comparable"), plotInfo);
    }

    public static void assertIsNumericOrTimeOrCharOrComparableInstance(TableDefinition t, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ArgumentValidations.assertIsNumericOrTimeOrCharOrComparableInstance(t, column, ArgumentValidations.createWrongColumnTypeErrorMessage(t, column, plotInfo, "Numeric", "Time", "Character", "Comparable"), plotInfo);
    }

    public static void assertIsNumericOrTimeOrCharOrComparableInstance(Table t, String column, String message, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ColumnDefinition colDef = t.getDefinition().getColumn(column);
        if (colDef == null) {
            throw new PlotRuntimeException("Column not present in table: column=" + column, plotInfo);
        }
        if (!(ArgumentValidations.isNumericOrTime(colDef.getDataType(), plotInfo) || Comparable.class.isAssignableFrom(colDef.getDataType()) || TypeUtils.isCharacter((Class)colDef.getDataType()))) {
            throw new PlotRuntimeException(message, plotInfo);
        }
    }

    public static void assertIsNumericOrTimeOrCharOrComparableInstance(TableDefinition t, String column, String message, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ColumnDefinition colDef = t.getColumn(column);
        if (colDef == null) {
            throw new PlotRuntimeException("Column not present in table: column=" + column, plotInfo);
        }
        if (!(ArgumentValidations.isNumericOrTime(colDef.getDataType(), plotInfo) || Comparable.class.isAssignableFrom(colDef.getDataType()) || TypeUtils.isCharacter((Class)colDef.getDataType()))) {
            throw new PlotRuntimeException(message, plotInfo);
        }
    }

    public static void assertSameSize(IndexableNumericData[] data, String[] dataNames, PlotInfo plotInfo) {
        int i;
        ArgumentValidations.assertNotNull(data, "data", plotInfo);
        ArgumentValidations.assertNotNull(dataNames, "dataNames", plotInfo);
        if (data.length != dataNames.length) {
            throw new PlotIllegalStateException("Inputs must be of the same dimension", plotInfo);
        }
        for (i = 0; i < data.length; ++i) {
            ArgumentValidations.assertNotNull(data[i], dataNames[i], plotInfo);
        }
        for (i = 0; i < data.length; ++i) {
            if (data[i].size() == data[0].size()) continue;
            throw new PlotIllegalArgumentException("Input data is of inconsistent size: (" + dataNames[i] + "=" + String.valueOf(data[i]) + "," + dataNames[0] + "=" + String.valueOf(data[0]) + ")", plotInfo);
        }
    }

    public static Class getColumnType(Table t, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ColumnDefinition colDef = t.getDefinition().getColumn(column);
        if (colDef == null) {
            throw new PlotRuntimeException("Column not present in table: column=" + column, plotInfo);
        }
        return colDef.getDataType();
    }

    public static Class getColumnType(TableDefinition t, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ColumnDefinition col = t.getColumn(column);
        if (col == null) {
            throw new PlotRuntimeException("Column not present in table: column=" + column, plotInfo);
        }
        return col.getDataType();
    }

    public static Class getColumnType(SelectableDataSet sds, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(sds, "sds", plotInfo);
        ColumnDefinition col = sds.getTableDefinition().getColumn(column);
        if (col == null) {
            throw new PlotRuntimeException("Column not present in table: column=" + column, plotInfo);
        }
        return col.getDataType();
    }

    public static boolean isTime(Class c, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(c, "c", plotInfo);
        return c == Date.class || c == Instant.class;
    }

    public static boolean isNumericOrTime(Class c) {
        return NumericTypeUtils.isNumeric((Class)c) || ArgumentValidations.isTime(c, null);
    }

    public static boolean isNumericOrTime(Class c, PlotInfo plotInfo) {
        return NumericTypeUtils.isNumeric((Class)c) || ArgumentValidations.isTime(c, plotInfo);
    }

    public static boolean isTime(Table t, String column, PlotInfo plotInfo) {
        return ArgumentValidations.isTime(ArgumentValidations.getColumnType(t, column, plotInfo), plotInfo);
    }

    public static boolean isTime(TableDefinition t, String column, PlotInfo plotInfo) {
        return ArgumentValidations.isTime(ArgumentValidations.getColumnType(t, column, plotInfo), plotInfo);
    }

    public static boolean isTime(SelectableDataSet sds, String column, PlotInfo plotInfo) {
        return ArgumentValidations.isTime(ArgumentValidations.getColumnType(sds, column, plotInfo), plotInfo);
    }

    public static boolean isPrimitiveNumeric(Table t, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        return NumericTypeUtils.isPrimitiveNumeric((Class)ArgumentValidations.getColumnType(t, column, plotInfo));
    }

    public static boolean isBoxedNumeric(Table t, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        return NumericTypeUtils.isBoxedNumeric((Class)ArgumentValidations.getColumnType(t, column, plotInfo));
    }

    public static boolean isNumeric(Table t, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        return NumericTypeUtils.isNumeric((Class)ArgumentValidations.getColumnType(t, column, plotInfo));
    }

    public static boolean isNumeric(TableDefinition t, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        return NumericTypeUtils.isNumeric((Class)ArgumentValidations.getColumnType(t, column, plotInfo));
    }

    public static boolean isNumeric(SelectableDataSet sds, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(sds, "t", plotInfo);
        return NumericTypeUtils.isNumeric((Class)ArgumentValidations.getColumnType(sds, column, plotInfo));
    }

    public static boolean isNumericOrTime(Table t, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        return ArgumentValidations.isNumericOrTime(ArgumentValidations.getColumnType(t, column, plotInfo), plotInfo);
    }

    public static boolean isNumericOrTime(TableDefinition t, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        return ArgumentValidations.isNumericOrTime(ArgumentValidations.getColumnType(t, column, plotInfo), plotInfo);
    }

    public static boolean isNumericOrTime(SelectableDataSet sds, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(sds, "sds", plotInfo);
        return ArgumentValidations.isNumericOrTime(ArgumentValidations.getColumnType(sds, column, plotInfo), plotInfo);
    }

    public static void assertIsTime(Table t, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ArgumentValidations.assertIsTime(t, column, ArgumentValidations.createWrongColumnTypeErrorMessage(t, column, plotInfo, "Time"), plotInfo);
    }

    public static void assertIsTime(TableDefinition t, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ArgumentValidations.assertIsTime(t, column, ArgumentValidations.createWrongColumnTypeErrorMessage(t, column, plotInfo, "Time"), plotInfo);
    }

    public static void assertIsTime(Table t, String column, String message, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        if (!ArgumentValidations.isTime(t, column, plotInfo)) {
            throw new PlotRuntimeException(message, plotInfo);
        }
    }

    public static void assertIsTime(TableDefinition t, String column, String message, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        if (!ArgumentValidations.isTime(t, column, plotInfo)) {
            throw new PlotRuntimeException(message, plotInfo);
        }
    }

    public static void assertIsPrimitiveNumeric(Table t, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ArgumentValidations.assertIsPrimitiveNumeric(t, column, ArgumentValidations.createWrongColumnTypeErrorMessage(t, column, plotInfo, "primitive Numeric"), plotInfo);
    }

    public static void assertIsPrimitiveNumeric(Table t, String column, String message, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        if (!ArgumentValidations.isPrimitiveNumeric(t, column, plotInfo)) {
            throw new PlotRuntimeException(message, plotInfo);
        }
    }

    public static void assertIsBoxedNumeric(Table t, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ArgumentValidations.assertIsBoxedNumeric(t, column, ArgumentValidations.createWrongColumnTypeErrorMessage(t, column, plotInfo, "boxed Numeric"), plotInfo);
    }

    public static void assertIsBoxedNumeric(Table t, String column, String message, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        if (!ArgumentValidations.isBoxedNumeric(t, column, plotInfo)) {
            throw new PlotRuntimeException(message, plotInfo);
        }
    }

    public static void assertIsNumeric(Table t, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ArgumentValidations.assertIsNumeric(t, column, ArgumentValidations.createWrongColumnTypeErrorMessage(t, column, plotInfo, "Numeric"), plotInfo);
    }

    public static void assertIsNumeric(TableDefinition t, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ArgumentValidations.assertIsNumeric(t, column, ArgumentValidations.createWrongColumnTypeErrorMessage(t, column, plotInfo, "Numeric"), plotInfo);
    }

    public static void assertIsNumeric(Table t, String column, String message, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        if (!ArgumentValidations.isNumeric(t, column, plotInfo)) {
            throw new PlotRuntimeException(message, plotInfo);
        }
    }

    public static void assertIsNumeric(TableDefinition t, String column, String message, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        if (!ArgumentValidations.isNumeric(t, column, plotInfo)) {
            throw new PlotRuntimeException(message, plotInfo);
        }
    }

    public static void assertIsNumeric(SelectableDataSet sds, String column, String message, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(sds, "t", plotInfo);
        if (!ArgumentValidations.isNumeric(sds, column, plotInfo)) {
            throw new PlotRuntimeException(message, plotInfo);
        }
    }

    public static void assertIsNumericOrTime(Table t, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ArgumentValidations.assertIsNumericOrTime(t, column, ArgumentValidations.createWrongColumnTypeErrorMessage(t, column, plotInfo, "Numeric, Time"), plotInfo);
    }

    public static void assertIsNumericOrTime(TableDefinition t, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ArgumentValidations.assertIsNumericOrTime(t, column, ArgumentValidations.createWrongColumnTypeErrorMessage(t, column, plotInfo, "Numeric", "Time"), plotInfo);
    }

    public static void assertIsNumericOrTime(SelectableDataSet sds, String column, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(sds, "sds", plotInfo);
        ArgumentValidations.assertIsNumericOrTime(sds, column, ArgumentValidations.createWrongColumnTypeErrorMessage(sds, column, plotInfo, "Numeric", "Time"), plotInfo);
    }

    public static void assertIsNumericOrTime(Table t, String column, String message, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        if (!ArgumentValidations.isNumericOrTime(t, column, plotInfo)) {
            throw new PlotRuntimeException(message, plotInfo);
        }
    }

    public static void assertIsNumericOrTime(TableDefinition t, String column, String message, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        if (!ArgumentValidations.isNumericOrTime(t, column, plotInfo)) {
            throw new PlotRuntimeException(message, plotInfo);
        }
    }

    public static void assertIsNumericOrTime(SelectableDataSet sds, String column, String message, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(sds, "t", plotInfo);
        if (!ArgumentValidations.isNumericOrTime(sds, column, plotInfo)) {
            throw new PlotRuntimeException(message, plotInfo);
        }
    }

    public static void assertColumnsInTable(Table t, PlotInfo plotInfo, String ... cols) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ArgumentValidations.assertNotNull(cols, "cols", plotInfo);
        for (String c : cols) {
            if (t.hasColumns(new String[]{c})) continue;
            throw new PlotIllegalArgumentException("Column " + c + " could not be found in table.", plotInfo);
        }
    }

    public static void assertColumnsInTable(TableDefinition t, PlotInfo plotInfo, String ... cols) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ArgumentValidations.assertNotNull(cols, "cols", plotInfo);
        for (String c : cols) {
            if (t.getColumn(c) != null) continue;
            throw new PlotIllegalArgumentException("Column " + c + " could not be found in table.", plotInfo);
        }
    }

    public static void assertColumnsInTable(SelectableDataSet sds, PlotInfo plotInfo, String ... cols) {
        ArgumentValidations.assertNotNull(sds, "t", plotInfo);
        ArgumentValidations.assertNotNull(cols, "cols", plotInfo);
        HashSet colnames = new HashSet(sds.getTableDefinition().getColumnNames());
        for (String c : cols) {
            if (colnames.contains(c)) continue;
            throw new PlotIllegalArgumentException("Column " + c + " could not be found in selectable dataset.", plotInfo);
        }
    }

    public static void assertColumnsInTable(TableHandle t, PlotInfo plotInfo, String ... cols) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        ArgumentValidations.assertNotNull(cols, "cols", plotInfo);
        for (String c : cols) {
            if (t.hasColumns(c)) continue;
            throw new PlotIllegalArgumentException("Column " + c + " could not be found in table.", plotInfo);
        }
    }

    public static boolean nanSafeEquals(double x, double x1) {
        return x == x1 || Double.isNaN(x) && Double.isNaN(x1);
    }

    private static String wrongColumnTypeErrorMessage(String column, Class columnType, String ... expectedTypes) {
        Require.geqZero((int)expectedTypes.length, (String)"expectedTypes.length");
        StringBuilder sb = new StringBuilder();
        sb.append("Invalid data type in column = ").append(column).append(".");
        if (expectedTypes.length == 1) {
            sb.append(" Expected a ").append(expectedTypes[0]).append(" but was a ").append(columnType.getName());
        } else {
            sb.append(" Expected the type to be ");
            for (int i = 0; i < expectedTypes.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                if (i == expectedTypes.length) {
                    sb.append("or ");
                }
                sb.append(expectedTypes[i]);
            }
            sb.append(" but was a ").append(columnType.getName());
        }
        return sb.toString();
    }

    private static String createWrongColumnTypeErrorMessage(Table t, String column, PlotInfo plotInfo, String ... types) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        return ArgumentValidations.wrongColumnTypeErrorMessage(column, ArgumentValidations.getColumnType(t, column, plotInfo), types);
    }

    private static String createWrongColumnTypeErrorMessage(TableDefinition t, String column, PlotInfo plotInfo, String ... types) {
        ArgumentValidations.assertNotNull(t, "t", plotInfo);
        return ArgumentValidations.wrongColumnTypeErrorMessage(column, ArgumentValidations.getColumnType(t, column, plotInfo), types);
    }

    private static String createWrongColumnTypeErrorMessage(SelectableDataSet sds, String column, PlotInfo plotInfo, String ... types) {
        ArgumentValidations.assertNotNull(sds, "sds", plotInfo);
        return ArgumentValidations.wrongColumnTypeErrorMessage(column, ArgumentValidations.getColumnType(sds, column, plotInfo), types);
    }
}

