/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.filters;

import io.deephaven.base.verify.Require;
import io.deephaven.engine.table.PartitionedTable;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.util.parametrized.TableSupplier;
import io.deephaven.plot.filters.SelectableDataSetOneClick;

public class Selectables {
    private Selectables() {
    }

    public static SelectableDataSetOneClick oneClick(Table t, String ... byColumns) {
        return Selectables.oneClick(t, true, byColumns);
    }

    public static SelectableDataSetOneClick oneClick(PartitionedTable pTable) {
        return Selectables.oneClick(pTable, true);
    }

    public static SelectableDataSetOneClick oneClick(Table t, boolean requireAllFiltersToDisplay, String ... byColumns) {
        if (byColumns == null || byColumns.length < 1) {
            throw new IllegalArgumentException("byColumns can not be empty");
        }
        Require.neqNull((Object)t, (String)"t");
        Table table = TableSupplier.complete((Table)t);
        return Selectables.oneClick(t.partitionBy(byColumns), requireAllFiltersToDisplay);
    }

    public static SelectableDataSetOneClick oneClick(PartitionedTable pTable, boolean requireAllFiltersToDisplay) {
        if (pTable.keyColumnNames().isEmpty()) {
            throw new IllegalArgumentException("byColumns can not be empty");
        }
        Require.neqNull((Object)pTable, (String)"pTable");
        return new SelectableDataSetOneClick(pTable, requireAllFiltersToDisplay);
    }
}

