/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.errors;

import io.deephaven.base.log.LogOutput;
import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.BaseFigureImpl;
import io.deephaven.plot.ChartImpl;
import io.deephaven.plot.SeriesInternal;
import java.io.Serializable;

public class PlotInfo
implements Serializable,
LogOutputAppendable {
    private String info;

    public PlotInfo(AxesImpl axes, Comparable seriesName) {
        this(PlotInfo.getAxesFigure(axes), PlotInfo.getAxesChart(axes), seriesName);
    }

    public PlotInfo(BaseFigureImpl figure, ChartImpl chart, SeriesInternal series) {
        this(figure, chart, series == null ? null : series.name());
    }

    public PlotInfo(BaseFigureImpl figure, ChartImpl chart, Comparable seriesName) {
        this(figure, chart, seriesName == null ? null : seriesName.toString());
    }

    public PlotInfo(BaseFigureImpl figure, ChartImpl chart, String seriesName) {
        this(figure == null ? null : figure.getTitle(), chart == null ? null : chart.getTitle(), seriesName);
    }

    public PlotInfo(String figureName, String chartName, String seriesName) {
        this.info = this.encodeInfo(figureName, chartName, seriesName);
    }

    private static BaseFigureImpl getAxesFigure(AxesImpl axes) {
        ChartImpl chart = PlotInfo.getAxesChart(axes);
        return chart == null ? null : chart.figure();
    }

    private static ChartImpl getAxesChart(AxesImpl axes) {
        return axes == null ? null : axes.chart();
    }

    private String encodeInfo(String figureName, String chartName, String seriesName) {
        Object info = "";
        if (figureName != null) {
            info = (String)info + "Figure: " + figureName + ".";
        }
        if (chartName != null) {
            if (figureName != null) {
                info = (String)info + " ";
            }
            info = (String)info + "Chart: " + chartName + ".";
        }
        if (seriesName != null) {
            if (figureName != null || chartName != null) {
                info = (String)info + " ";
            }
            info = (String)info + "Series: " + seriesName + ".";
        }
        return ((String)info).isEmpty() ? null : info;
    }

    public String toString() {
        return this.info;
    }

    public LogOutput append(LogOutput logOutput) {
        return logOutput.append((CharSequence)this.info);
    }
}

