/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.multiseries;

import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.context.QueryScope;
import io.deephaven.engine.table.PartitionedTable;
import io.deephaven.engine.table.Table;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.datasets.DataSeriesInternal;
import io.deephaven.plot.datasets.multiseries.AbstractMultiSeries;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.SwappableTable;
import io.deephaven.plot.util.tables.TableHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public abstract class AbstractSwappableMultiSeries<SERIES extends DataSeriesInternal>
extends AbstractMultiSeries<SERIES> {
    private static final long serialVersionUID = 3034015389062108370L;
    private Table localTable;
    private final SwappableTable swappableTable;
    private final String x;
    private final String y;
    private final List<TableHandle> tableHandlesList = new ArrayList<TableHandle>();

    AbstractSwappableMultiSeries(AxesImpl axes, int id, Comparable name, SwappableTable swappableTable, String x, String y, String[] byColumns) {
        super(axes, id, name, byColumns);
        this.swappableTable = swappableTable;
        this.x = x;
        this.y = y;
        this.addSwappableTable(swappableTable);
        this.applyNamingFunction();
    }

    AbstractSwappableMultiSeries(AbstractSwappableMultiSeries series, AxesImpl axes) {
        super(series, axes);
        this.namingFunction = series.namingFunction;
        this.swappableTable = series.swappableTable;
        this.initialized = series.initialized;
        this.x = series.x;
        this.y = series.y;
        this.setDynamicSeriesNamer(series.getDynamicSeriesNamer());
    }

    @Override
    public String getX() {
        return this.x;
    }

    @Override
    public String getY() {
        return this.y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionedTable getPartitionedTable() {
        if (this.localTable == null) {
            return EMPTY_PARTITIONED_TABLE;
        }
        if (this.partitionedTable == null) {
            Object object = this.partitionedTableLock;
            synchronized (object) {
                if (this.partitionedTable != null) {
                    return this.partitionedTable;
                }
                this.partitionedTable = this.localTable.partitionBy(this.byColumns);
            }
        }
        return this.partitionedTable;
    }

    @Override
    public void addTableHandle(TableHandle tableHandle) {
        this.tableHandlesList.add(tableHandle);
        super.addTableHandle(tableHandle);
    }

    public SwappableTable getSwappableTable() {
        return this.swappableTable;
    }

    @Override
    protected <T, R> void applyFunction(Function<? super T, ? extends R> function, String columnName, String functionInput, Class<R> resultClass) {
        ArgumentValidations.assertNotNull(function, "function", this.getPlotInfo());
        String queryFunction = columnName + "Function";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(queryFunction, function);
        String update = columnName + " = (" + resultClass.getSimpleName() + ") " + queryFunction + ".apply(" + functionInput + ")";
        this.applyTransform(columnName, update, new Class[]{resultClass}, params, true);
    }

    @Override
    public void applyTransform(String columnName, String update, Class[] classesToImport, Map<String, Object> params, boolean columnTypesPreserved) {
        ArgumentValidations.assertNull(this.partitionedTable, "partitionedTable must be null", this.getPlotInfo());
        this.swappableTable.addColumn(columnName);
        Function<Table, Table> tableTransform = t -> {
            Arrays.stream(classesToImport).forEach(aClass -> ExecutionContext.getContext().getQueryLibrary().importClass(aClass));
            params.forEach(QueryScope::addParam);
            return (Table)t.update(new String[]{update});
        };
        this.chart().figure().registerPartitionedTableFunction(this.swappableTable.getPartitionedTableHandle(), tableTransform);
    }
}

