/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.multiseries;

import groovy.lang.Closure;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.table.PartitionedTable;
import io.deephaven.engine.table.Table;
import io.deephaven.engine.table.impl.BaseTable;
import io.deephaven.engine.util.TableTools;
import io.deephaven.gui.color.Paint;
import io.deephaven.gui.shape.Shape;
import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.plot.AbstractSeriesInternal;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.ChartImpl;
import io.deephaven.plot.LineStyle;
import io.deephaven.plot.TableSnapshotSeries;
import io.deephaven.plot.datasets.DataSeriesInternal;
import io.deephaven.plot.datasets.DynamicSeriesNamer;
import io.deephaven.plot.datasets.data.IndexableData;
import io.deephaven.plot.datasets.multiseries.MultiSeriesInternal;
import io.deephaven.plot.errors.PlotIllegalStateException;
import io.deephaven.plot.errors.PlotRuntimeException;
import io.deephaven.plot.errors.PlotUnsupportedOperationException;
import io.deephaven.plot.filters.SelectableDataSet;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.functions.ClosureFunction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

public abstract class AbstractMultiSeries<SERIES extends DataSeriesInternal>
extends AbstractSeriesInternal
implements MultiSeriesInternal<SERIES>,
TableSnapshotSeries {
    private static final long serialVersionUID = 3548896765688007362L;
    private static final Logger log = LoggerFactory.getLogger(AbstractMultiSeries.class);
    protected static final PartitionedTable EMPTY_PARTITIONED_TABLE = TableTools.emptyTable((long)0L).partitionBy(new String[0]);
    protected final String[] byColumns;
    protected transient Object partitionedTableLock;
    protected transient PartitionedTable partitionedTable;
    private transient Object seriesLock;
    private transient List<SERIES> series;
    private transient Set<Object> seriesKeys;
    private transient Map<String, Object> seriesNames;
    private final transient Function<Object, String> DEFAULT_NAMING_FUNCTION = key -> {
        Object[] keyArray;
        String keyString = key instanceof Object[] ? ((keyArray = (Object[])key).length == 1 ? Objects.toString(keyArray[0]) : Arrays.toString(keyArray)) : Objects.toString(key);
        return String.valueOf(this.name()) + ": " + keyString;
    };
    transient Function<Object, String> namingFunction;
    private DynamicSeriesNamer seriesNamer;
    private transient Object seriesNamerLock;
    private boolean allowInitialization = false;
    protected boolean initialized;
    private String seriesNameColumnName = null;

    AbstractMultiSeries(AxesImpl axes, int id, Comparable name, String[] byColumns) {
        super(axes, id, name);
        this.byColumns = byColumns;
        this.namingFunction = this.DEFAULT_NAMING_FUNCTION;
        this.initializeTransient();
    }

    AbstractMultiSeries(AbstractMultiSeries series, AxesImpl axes) {
        super(series, axes);
        this.byColumns = series.byColumns;
        this.namingFunction = series.namingFunction;
        this.seriesNamer = series.seriesNamer;
        this.allowInitialization = series.allowInitialization;
        this.seriesNameColumnName = series.seriesNameColumnName;
        this.initializeTransient();
    }

    @Override
    public ChartImpl chart() {
        return this.axes().chart();
    }

    @Override
    public DynamicSeriesNamer getDynamicSeriesNamer() {
        return this.seriesNamer;
    }

    @Override
    public void setDynamicSeriesNamer(DynamicSeriesNamer seriesNamer) {
        this.seriesNamer = seriesNamer;
    }

    @Override
    public String[] getByColumns() {
        return this.byColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String makeSeriesName(String seriesName, DynamicSeriesNamer seriesNamer) {
        if (seriesNamer == null) {
            throw new PlotIllegalStateException("seriesNamer null " + String.valueOf(this), this);
        }
        Object object = this.seriesNamerLock;
        synchronized (object) {
            return seriesNamer.makeUnusedName(seriesName, this.getPlotInfo());
        }
    }

    @Override
    public AbstractMultiSeries<SERIES> seriesNamingFunction(Function<Object, String> namingFunction) {
        this.namingFunction = namingFunction == null ? this.DEFAULT_NAMING_FUNCTION : namingFunction;
        this.applyNamingFunction(namingFunction);
        return this;
    }

    @Override
    public AbstractMultiSeries<SERIES> seriesNamingFunction(Closure<String> namingFunction) {
        return this.seriesNamingFunction((Function)(namingFunction == null ? null : new ClosureFunction(namingFunction)));
    }

    protected void applyNamingFunction() {
        this.applyNamingFunction(this.namingFunction);
    }

    private void applyNamingFunction(Function<Object, String> namingFunction) {
        ArgumentValidations.assertNotNull(namingFunction, "namingFunction", this.getPlotInfo());
        this.seriesNameColumnName = this.seriesNameColumnName == null ? "__SERIES_NAME" + this.hashCode() : this.seriesNameColumnName;
        Object functionInput = this.byColumns.length > 1 ? "new Object[] {" + String.join((CharSequence)", ", this.byColumns) + "}" : this.byColumns[0];
        this.applyFunction(namingFunction, this.seriesNameColumnName, (String)functionInput, String.class);
    }

    protected <T, R> void applyFunction(Function<? super T, ? extends R> function, String columnName, String functionInput, Class<R> resultClass) {
        ArgumentValidations.assertNotNull(function, "function", this.getPlotInfo());
        String queryFunction = columnName + "Function";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(queryFunction, function);
        String update = columnName + " = (" + resultClass.getSimpleName() + ") " + queryFunction + ".apply(" + functionInput + ")";
        this.applyTransform(columnName, update, new Class[]{resultClass}, params, true);
    }

    @Override
    public void initializeSeries(SERIES series) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SERIES> getSeries() {
        if (this.series == null) {
            Object object = this.seriesLock;
            synchronized (object) {
                if (this.series != null) {
                    return this.series;
                }
                this.series = new CopyOnWriteArrayList<SERIES>();
            }
        }
        return this.series;
    }

    @Override
    public void addSeries(SERIES series, Object key) {
        Assert.assertion((boolean)Thread.holdsLock(this.seriesLock), (String)"Thread.holdsLock(seriesLock)");
        if (this.seriesKeys == null) {
            this.seriesKeys = new HashSet<Object>();
        }
        if (this.seriesNames == null) {
            this.seriesNames = new HashMap<String, Object>();
        }
        if (this.seriesKeys.contains(key)) {
            log.warn((Object)("MultiSeries: attempting to add a series with the same key as an existing series.  key=" + String.valueOf(key)));
            return;
        }
        if (this.seriesNames.containsKey(series.name().toString())) {
            throw new PlotRuntimeException("MultiSeries: attempting to add a series with the same name as an existing series.   name=" + String.valueOf(series.name()) + "oldKey=" + this.seriesNames.containsKey(series.name()) + " newKey=" + String.valueOf(key), this);
        }
        this.initializeSeries(series);
        this.seriesKeys.add(key);
        this.seriesNames.put(series.name().toString(), key);
        this.getSeries().add(series);
    }

    @Override
    public SERIES get(int series) {
        int size = this.getSeries().size();
        if (series < 0 || series >= size) {
            throw new PlotRuntimeException("Series index is out of range: key=" + series + " range=[0," + size + "]", this);
        }
        return (SERIES)((DataSeriesInternal)this.getSeries().get(series));
    }

    @Override
    public int getSeriesCount() {
        return this.getSeries().size();
    }

    @Override
    public SERIES createSeries(String seriesName, BaseTable t) {
        return (SERIES)this.createSeries(seriesName, t, this.seriesNamer);
    }

    private void initializeTransient() {
        this.partitionedTableLock = new Object();
        this.seriesLock = new Object();
        this.seriesNamerLock = new Object();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    @Override
    public <COLOR extends Paint> AbstractMultiSeries<SERIES> pointColor(Closure<COLOR> pointColor, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColor for arguments [groovy.lang.Closure<COLOR>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public <COLOR extends Paint> AbstractMultiSeries<SERIES> pointColor(Function<Comparable, COLOR> pointColor, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColor for arguments [java.util.function.Function<java.lang.Comparable, COLOR>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public <COLOR extends Integer> AbstractMultiSeries<SERIES> pointColorInteger(Closure<COLOR> colors, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColorInteger for arguments [groovy.lang.Closure<COLOR>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public <COLOR extends Integer> AbstractMultiSeries<SERIES> pointColorInteger(Function<Comparable, COLOR> colors, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColorInteger for arguments [java.util.function.Function<java.lang.Comparable, COLOR>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public <LABEL> AbstractMultiSeries<SERIES> pointLabel(Closure<LABEL> pointLabels, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointLabel for arguments [groovy.lang.Closure<LABEL>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public <LABEL> AbstractMultiSeries<SERIES> pointLabel(Function<Comparable, LABEL> pointLabels, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointLabel for arguments [java.util.function.Function<java.lang.Comparable, LABEL>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointShape(Closure<String> pointShapes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointShape for arguments [groovy.lang.Closure<java.lang.String>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointShape(Function<Comparable, String> pointShapes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointShape for arguments [java.util.function.Function<java.lang.Comparable, java.lang.String>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public <NUMBER extends Number> AbstractMultiSeries<SERIES> pointSize(Closure<NUMBER> pointSizes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [groovy.lang.Closure<NUMBER>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public <NUMBER extends Number> AbstractMultiSeries<SERIES> pointSize(Function<Comparable, NUMBER> pointSizes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [java.util.function.Function<java.lang.Comparable, NUMBER>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> errorBarColor(String errorBarColor, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method errorBarColor for arguments [class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> errorBarColor(int errorBarColor, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method errorBarColor for arguments [int]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> errorBarColor(Paint errorBarColor, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method errorBarColor for arguments [interface io.deephaven.gui.color.Paint]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> gradientVisible(boolean gradientVisible, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method gradientVisible for arguments [boolean]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> lineColor(String color, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method lineColor for arguments [class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> lineColor(int color, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method lineColor for arguments [int]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> lineColor(Paint color, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method lineColor for arguments [interface io.deephaven.gui.color.Paint]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> lineStyle(LineStyle lineStyle, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method lineStyle for arguments [class io.deephaven.plot.LineStyle]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> linesVisible(Boolean visible, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method linesVisible for arguments [class java.lang.Boolean]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointColor(String pointColor, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColor for arguments [class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointColor(int pointColor, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColor for arguments [int]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointColor(Paint pointColor, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColor for arguments [interface io.deephaven.gui.color.Paint]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointLabel(Object pointLabel, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointLabel for arguments [class java.lang.Object]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointLabelFormat(String pointLabelFormat, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointLabelFormat for arguments [class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointShape(String pointShape, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointShape for arguments [class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointShape(Shape pointShape, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointShape for arguments [interface io.deephaven.gui.shape.Shape]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointSize(Number pointSize, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [class java.lang.Number]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointsVisible(Boolean visible, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointsVisible for arguments [class java.lang.Boolean]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> seriesColor(String color, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method seriesColor for arguments [class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> seriesColor(int color, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method seriesColor for arguments [int]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> seriesColor(Paint color, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method seriesColor for arguments [interface io.deephaven.gui.color.Paint]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> toolTipPattern(String toolTipPattern, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method toolTipPattern for arguments [class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> xToolTipPattern(String xToolTipPattern, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method xToolTipPattern for arguments [class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> yToolTipPattern(String yToolTipPattern, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method yToolTipPattern for arguments [class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> group(int group, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method group for arguments [int]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> piePercentLabelFormat(String pieLabelFormat, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method piePercentLabelFormat for arguments [class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public <CATEGORY extends Comparable, COLOR extends Paint> AbstractMultiSeries<SERIES> pointColor(Map<CATEGORY, COLOR> pointColor, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColor for arguments [java.util.Map<CATEGORY, COLOR>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointColor(Comparable category, String pointColor, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColor for arguments [interface java.lang.Comparable, class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointColor(Comparable category, int pointColor, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColor for arguments [interface java.lang.Comparable, int]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointColor(Comparable category, Paint pointColor, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColor for arguments [interface java.lang.Comparable, interface io.deephaven.gui.color.Paint]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointColor(Table t, String category, String pointColor, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColor for arguments [interface io.deephaven.engine.table.Table, class java.lang.String, class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointColor(SelectableDataSet sds, String category, String pointColor, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColor for arguments [interface io.deephaven.plot.filters.SelectableDataSet, class java.lang.String, class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public <CATEGORY extends Comparable, COLOR extends Integer> AbstractMultiSeries<SERIES> pointColorInteger(Map<CATEGORY, COLOR> colors, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColorInteger for arguments [java.util.Map<CATEGORY, COLOR>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public <CATEGORY extends Comparable, LABEL> AbstractMultiSeries<SERIES> pointLabel(Map<CATEGORY, LABEL> pointLabels, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointLabel for arguments [java.util.Map<CATEGORY, LABEL>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointLabel(Comparable category, Object pointLabel, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointLabel for arguments [interface java.lang.Comparable, class java.lang.Object]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointLabel(Table t, String category, String pointLabel, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointLabel for arguments [interface io.deephaven.engine.table.Table, class java.lang.String, class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointLabel(SelectableDataSet sds, String category, String pointLabel, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointLabel for arguments [interface io.deephaven.plot.filters.SelectableDataSet, class java.lang.String, class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public <CATEGORY extends Comparable> AbstractMultiSeries<SERIES> pointShape(Map<CATEGORY, String> pointShapes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointShape for arguments [java.util.Map<CATEGORY, java.lang.String>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointShape(Comparable category, String pointShape, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointShape for arguments [interface java.lang.Comparable, class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointShape(Comparable category, Shape pointShape, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointShape for arguments [interface java.lang.Comparable, interface io.deephaven.gui.shape.Shape]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointShape(Table t, String category, String pointShape, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointShape for arguments [interface io.deephaven.engine.table.Table, class java.lang.String, class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointShape(SelectableDataSet sds, String category, String pointShape, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointShape for arguments [interface io.deephaven.plot.filters.SelectableDataSet, class java.lang.String, class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public <CATEGORY extends Comparable, NUMBER extends Number> AbstractMultiSeries<SERIES> pointSize(Map<CATEGORY, NUMBER> pointSizes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [java.util.Map<CATEGORY, NUMBER>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public <CATEGORY extends Comparable, NUMBER extends Number> AbstractMultiSeries<SERIES> pointSize(CATEGORY[] categories, NUMBER[] pointSizes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [CATEGORY[], NUMBER[]]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public <CATEGORY extends Comparable> AbstractMultiSeries<SERIES> pointSize(CATEGORY[] categories, double[] pointSizes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [CATEGORY[], class [D]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public <CATEGORY extends Comparable> AbstractMultiSeries<SERIES> pointSize(CATEGORY[] categories, int[] pointSizes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [CATEGORY[], class [I]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public <CATEGORY extends Comparable> AbstractMultiSeries<SERIES> pointSize(CATEGORY[] categories, long[] pointSizes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [CATEGORY[], class [J]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointSize(Comparable category, Number pointSize, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [interface java.lang.Comparable, class java.lang.Number]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointSize(Comparable category, double pointSize, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [interface java.lang.Comparable, double]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointSize(Comparable category, int pointSize, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [interface java.lang.Comparable, int]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointSize(Comparable category, long pointSize, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [interface java.lang.Comparable, long]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointSize(Table t, String category, String pointSize, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [interface io.deephaven.engine.table.Table, class java.lang.String, class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointSize(SelectableDataSet sds, String category, String pointSize, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [interface io.deephaven.plot.filters.SelectableDataSet, class java.lang.String, class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointColor(int[] pointColors, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColor for arguments [class [I]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointColor(Paint[] pointColor, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColor for arguments [class [Lio.deephaven.gui.color.Paint;]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointColor(Integer[] pointColors, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColor for arguments [class [Ljava.lang.Integer;]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointColor(String[] pointColors, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColor for arguments [class [Ljava.lang.String;]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public <T extends Paint> AbstractMultiSeries<SERIES> pointColor(IndexableData<T> pointColor, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColor for arguments [io.deephaven.plot.datasets.data.IndexableData<T>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointColor(Table t, String pointColors, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColor for arguments [interface io.deephaven.engine.table.Table, class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointColor(SelectableDataSet sds, String pointColors, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColor for arguments [interface io.deephaven.plot.filters.SelectableDataSet, class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointColorInteger(IndexableData<Integer> colors, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointColorInteger for arguments [io.deephaven.plot.datasets.data.IndexableData<java.lang.Integer>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointLabel(Object[] pointLabels, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointLabel for arguments [class [Ljava.lang.Object;]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointLabel(IndexableData<?> pointLabels, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointLabel for arguments [io.deephaven.plot.datasets.data.IndexableData<?>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointLabel(Table t, String pointLabel, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointLabel for arguments [interface io.deephaven.engine.table.Table, class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointLabel(SelectableDataSet sds, String pointLabel, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointLabel for arguments [interface io.deephaven.plot.filters.SelectableDataSet, class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointShape(Shape[] pointShapes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointShape for arguments [class [Lio.deephaven.gui.shape.Shape;]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointShape(String[] pointShapes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointShape for arguments [class [Ljava.lang.String;]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointShape(IndexableData<String> pointShapes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointShape for arguments [io.deephaven.plot.datasets.data.IndexableData<java.lang.String>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointShape(Table t, String pointShape, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointShape for arguments [interface io.deephaven.engine.table.Table, class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointShape(SelectableDataSet sds, String pointShape, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointShape for arguments [interface io.deephaven.plot.filters.SelectableDataSet, class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public <T extends Number> AbstractMultiSeries<SERIES> pointSize(T[] pointSizes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [T[]]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointSize(double[] pointSizes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [class [D]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointSize(int[] pointSizes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [class [I]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointSize(long[] pointSizes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [class [J]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointSize(IndexableData<Double> pointSizes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [io.deephaven.plot.datasets.data.IndexableData<java.lang.Double>]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointSize(Table t, String pointSizes, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [interface io.deephaven.engine.table.Table, class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }

    @Override
    public AbstractMultiSeries<SERIES> pointSize(SelectableDataSet sds, String pointSize, Object ... multiSeriesKey) {
        throw new PlotUnsupportedOperationException("DataSeries " + String.valueOf(this.getClass()) + " does not support method pointSize for arguments [interface io.deephaven.plot.filters.SelectableDataSet, class java.lang.String]. If you think this method should work, try placing your multiSeriesKey into an Object array", this);
    }
}

