/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.interval;

import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.TableSnapshotSeries;
import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.datasets.interval.IntervalXYDataSeriesInternal;
import io.deephaven.plot.datasets.xy.XYDataSeriesArray;
import io.deephaven.plot.errors.PlotIllegalArgumentException;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.SwappableTable;
import io.deephaven.plot.util.tables.TableHandle;
import org.jetbrains.annotations.NotNull;

public class IntervalXYDataSeriesArray
extends XYDataSeriesArray
implements IntervalXYDataSeriesInternal,
TableSnapshotSeries {
    private static final long serialVersionUID = 5911383536377254715L;
    public static final String BIN_MIN = "BinMin";
    public static final String BIN_MID = "BinMid";
    public static final String BIN_MAX = "BinMax";
    public static final String COUNT = "Count";
    private final IndexableNumericData startX;
    private final IndexableNumericData midX;
    private final IndexableNumericData endX;
    private final IndexableNumericData startY;
    private final IndexableNumericData midY;
    private final IndexableNumericData endY;
    private final TableHandle tableHandle;
    private final SwappableTable swappableTable;

    public IntervalXYDataSeriesArray(AxesImpl axes, int id, Comparable name, @NotNull TableHandle tableHandle, IndexableNumericData startX, IndexableNumericData midX, IndexableNumericData endX, IndexableNumericData startY, IndexableNumericData midY, IndexableNumericData endY) {
        this(axes, id, name, tableHandle, null, startX, midX, endX, startY, midY, endY);
    }

    public IntervalXYDataSeriesArray(AxesImpl axes, int id, Comparable name, @NotNull SwappableTable swappableTable, IndexableNumericData startX, IndexableNumericData midX, IndexableNumericData endX, IndexableNumericData startY, IndexableNumericData midY, IndexableNumericData endY) {
        this(axes, id, name, null, swappableTable, startX, midX, endX, startY, midY, endY);
    }

    private IntervalXYDataSeriesArray(AxesImpl axes, int id, Comparable name, TableHandle tableHandle, SwappableTable swappableTable, IndexableNumericData startX, IndexableNumericData midX, IndexableNumericData endX, IndexableNumericData startY, IndexableNumericData midY, IndexableNumericData endY) {
        this(axes, id, name, tableHandle, swappableTable, startX, midX, endX, startY, midY, endY, null);
    }

    public IntervalXYDataSeriesArray(AxesImpl axes, int id, Comparable name, TableHandle tableHandle, SwappableTable swappableTable, IndexableNumericData startX, IndexableNumericData midX, IndexableNumericData endX, IndexableNumericData startY, IndexableNumericData midY, IndexableNumericData endY, XYDataSeriesArray series) {
        super(axes, id, name, midX, midY, series);
        ArgumentValidations.assertNotNull(startX, "startX", this.getPlotInfo());
        ArgumentValidations.assertNotNull(startY, "startY", this.getPlotInfo());
        ArgumentValidations.assertNotNull(midX, "midX", this.getPlotInfo());
        ArgumentValidations.assertNotNull(midY, "midY", this.getPlotInfo());
        ArgumentValidations.assertNotNull(endX, "endX", this.getPlotInfo());
        ArgumentValidations.assertNotNull(endY, "endY", this.getPlotInfo());
        if (tableHandle == null && swappableTable == null) {
            throw new PlotIllegalArgumentException("One of tableHandle or swappableTable must be non null!", this);
        }
        this.tableHandle = tableHandle;
        this.swappableTable = swappableTable;
        this.startX = startX;
        this.midX = midX;
        this.endX = endX;
        this.startY = startY;
        this.midY = midY;
        this.endY = endY;
        ArgumentValidations.assertSameSize(new IndexableNumericData[]{startX, midX, endX, startY, midY, endY}, new String[]{"startX", "midX", "endX", "startY", "midY", "endY"}, this.getPlotInfo());
    }

    private IntervalXYDataSeriesArray(IntervalXYDataSeriesArray series, AxesImpl axes) {
        super(series, axes);
        this.tableHandle = series.tableHandle;
        this.swappableTable = series.swappableTable;
        this.startX = series.startX;
        this.midX = series.midX;
        this.endX = series.endX;
        this.startY = series.startY;
        this.midY = series.midY;
        this.endY = series.endY;
    }

    @Override
    public IntervalXYDataSeriesArray copy(AxesImpl axes) {
        return new IntervalXYDataSeriesArray(this, axes);
    }

    @Override
    public double getStartX(int item) {
        return this.startX.get(item);
    }

    @Override
    public double getEndX(int item) {
        return this.endX.get(item);
    }

    @Override
    public double getStartY(int item) {
        return this.startY.get(item);
    }

    @Override
    public double getEndY(int item) {
        return this.endY.get(item);
    }

    public IndexableNumericData getStartX() {
        return this.startX;
    }

    public IndexableNumericData getEndX() {
        return this.endX;
    }

    public IndexableNumericData getStartY() {
        return this.startY;
    }

    public IndexableNumericData getEndY() {
        return this.endY;
    }
}

