/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import io.deephaven.plot.datasets.data.LiveIndexableNumericData;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.errors.PlotUnsupportedOperationException;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.ColumnHandlerFactory;
import io.deephaven.plot.util.tables.TableHandle;

public class IndexableNumericDataTable
extends LiveIndexableNumericData {
    private static final long serialVersionUID = -6514312046355753066L;
    private final ColumnHandlerFactory.ColumnHandler columnHandler;

    public IndexableNumericDataTable(ColumnHandlerFactory.ColumnHandler columnHandler, PlotInfo plotInfo) {
        super(plotInfo);
        ArgumentValidations.assertNotNull(columnHandler, "columnHandler", this.getPlotInfo());
        this.columnHandler = columnHandler;
        if (!this.columnHandler.typeClassification().isNumeric()) {
            throw new PlotUnsupportedOperationException("Attempting to create a dataseries with a non-numeric column: column=" + columnHandler.getColumnName(), this);
        }
    }

    public IndexableNumericDataTable(TableHandle tableHandle, String column, PlotInfo plotInfo) {
        this(ColumnHandlerFactory.newNumericHandler(tableHandle, column, plotInfo), plotInfo);
    }

    @Override
    public int size() {
        return this.columnHandler.size();
    }

    @Override
    public double get(int i) {
        return this.columnHandler.getDouble(i);
    }

    public ColumnHandlerFactory.ColumnHandler getColumnHandler() {
        return this.columnHandler;
    }
}

