/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;

public class IndexableNumericDataArrayInt
extends IndexableNumericData {
    private static final long serialVersionUID = -980842236353746501L;
    private final int[] data;

    public IndexableNumericDataArrayInt(int[] data, PlotInfo plotInfo) {
        super(plotInfo);
        ArgumentValidations.assertNotNull(data, "data", this.getPlotInfo());
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public double get(int i) {
        if (i >= this.data.length) {
            return Double.NaN;
        }
        return this.data[i] == Integer.MIN_VALUE ? Double.NaN : (double)this.data[i];
    }
}

