/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.time.DateTimeUtils;
import java.time.Instant;

public class IndexableNumericDataArrayInstant
extends IndexableNumericData {
    private static final long serialVersionUID = 2006200987348909028L;
    private final Instant[] data;

    public IndexableNumericDataArrayInstant(Instant[] data, PlotInfo plotInfo) {
        super(plotInfo);
        ArgumentValidations.assertNotNull(data, "data", this.getPlotInfo());
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public double get(int i) {
        if (i >= this.data.length) {
            return Double.NaN;
        }
        double result = Double.NaN;
        Instant v = this.data[i];
        if (v != null) {
            result = DateTimeUtils.epochNanos((Instant)v);
        }
        return result;
    }
}

