/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;

public class IndexableNumericDataArrayFloat
extends IndexableNumericData {
    private static final long serialVersionUID = -1243064714255448279L;
    private final float[] data;

    public IndexableNumericDataArrayFloat(float[] data, PlotInfo plotInfo) {
        super(plotInfo);
        ArgumentValidations.assertNotNull(data, "data", this.getPlotInfo());
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public double get(int i) {
        if (i >= this.data.length) {
            return Double.NaN;
        }
        return this.data[i] == -3.4028235E38f ? Double.NaN : (double)this.data[i];
    }
}

