/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;

public class IndexableNumericDataArrayDouble
extends IndexableNumericData {
    private static final long serialVersionUID = 6885562283145177741L;
    private final double[] data;

    public IndexableNumericDataArrayDouble(double[] data, PlotInfo plotInfo) {
        super(plotInfo);
        ArgumentValidations.assertNotNull(data, "data", this.getPlotInfo());
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public double get(int i) {
        if (i >= this.data.length) {
            return Double.NaN;
        }
        return this.data[i] == -1.7976931348623157E308 ? Double.NaN : this.data[i];
    }
}

