/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import io.deephaven.plot.errors.PlotExceptionCause;
import io.deephaven.plot.errors.PlotInfo;
import java.io.Serializable;
import java.util.Spliterator;
import java.util.function.DoubleConsumer;
import java.util.stream.DoubleStream;
import java.util.stream.StreamSupport;

public abstract class IndexableNumericData
implements PlotExceptionCause,
Serializable {
    private final PlotInfo plotInfo;

    public IndexableNumericData(PlotInfo plotInfo) {
        this.plotInfo = plotInfo;
    }

    @Override
    public PlotInfo getPlotInfo() {
        return this.plotInfo;
    }

    public abstract int size();

    public abstract double get(int var1);

    public Spliterator.OfDouble doubleIterator() {
        return new Spliterator.OfDouble(){
            private int index = 0;

            @Override
            public Spliterator.OfDouble trySplit() {
                return null;
            }

            @Override
            public boolean tryAdvance(DoubleConsumer action) {
                if (this.index >= IndexableNumericData.this.size()) {
                    return false;
                }
                action.accept(IndexableNumericData.this.get(this.index++));
                return true;
            }

            @Override
            public long estimateSize() {
                return IndexableNumericData.this.size();
            }

            @Override
            public int characteristics() {
                return 1024;
            }
        };
    }

    public DoubleStream stream() {
        return StreamSupport.doubleStream(this.doubleIterator(), false);
    }
}

