/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import io.deephaven.plot.datasets.data.LiveIndexableData;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.ColumnHandlerFactory;

public class IndexableDataTable<T>
extends LiveIndexableData<T> {
    private static final long serialVersionUID = 8328713615740315451L;
    private final ColumnHandlerFactory.ColumnHandler columnHandler;

    public IndexableDataTable(ColumnHandlerFactory.ColumnHandler columnHandler, PlotInfo plotInfo) {
        super(plotInfo);
        ArgumentValidations.assertNotNull(columnHandler, "columnHandler", this.getPlotInfo());
        this.columnHandler = columnHandler;
    }

    @Override
    public int size() {
        return this.columnHandler.size();
    }

    @Override
    public T get(int index) {
        return this.convert(this.columnHandler.get(index));
    }

    public T convert(Object v) {
        return (T)v;
    }
}

