/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.data;

import gnu.trove.map.hash.TLongObjectHashMap;
import io.deephaven.plot.datasets.data.IndexableData;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.time.DateTimeUtils;
import java.time.Instant;

public class IndexableDataInstant
extends IndexableData<Instant> {
    private static final long serialVersionUID = 8122162323328323447L;
    private final long[] data;
    private final TLongObjectHashMap<Instant> instantMap = new TLongObjectHashMap();

    public IndexableDataInstant(long[] data, PlotInfo plotInfo) {
        super(plotInfo);
        ArgumentValidations.assertNotNull(data, "data", this.getPlotInfo());
        this.data = data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public Instant get(int index) {
        long dataValue = this.data[index];
        if (dataValue == Long.MIN_VALUE) {
            return null;
        }
        Instant cachedVal = (Instant)this.instantMap.get(dataValue);
        if (cachedVal == null) {
            cachedVal = DateTimeUtils.epochNanosToInstant((long)dataValue);
            this.instantMap.put(dataValue, (Object)cachedVal);
        }
        return cachedVal;
    }
}

