/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.categoryerrorbar;

import io.deephaven.engine.table.Table;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.TableSnapshotSeries;
import io.deephaven.plot.datasets.category.AbstractSwappableTableBasedCategoryDataSeries;
import io.deephaven.plot.datasets.category.CategorySwappableTableDataSeriesInternal;
import io.deephaven.plot.datasets.categoryerrorbar.CategoryErrorBarDataSeriesInternal;
import io.deephaven.plot.datasets.categoryerrorbar.CategoryErrorBarDataSeriesKernel;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.SwappableTable;
import java.util.Collection;

public class CategoryErrorBarDataSeriesSwappablePartitionedTable
extends AbstractSwappableTableBasedCategoryDataSeries
implements CategoryErrorBarDataSeriesInternal,
CategorySwappableTableDataSeriesInternal,
TableSnapshotSeries {
    private static final long serialVersionUID = 2L;
    private transient Table localTable;
    private final SwappableTable swappableTable;
    private final String categoryCol;
    private final String valueCol;
    private final String errorBarLowCol;
    private final String errorBarHighCol;
    private transient CategoryErrorBarDataSeriesKernel kernel;

    public <T extends Comparable> CategoryErrorBarDataSeriesSwappablePartitionedTable(AxesImpl axes, int id, Comparable name, SwappableTable swappableTable, String categories, String valueCol, String errorBarLowCol, String errorBarHighCol) {
        super(axes, id, name);
        ArgumentValidations.assertNotNull(axes, "axes", this.getPlotInfo());
        ArgumentValidations.assertNotNull(swappableTable, "swappableTable", this.getPlotInfo());
        ArgumentValidations.assertInstance(swappableTable.getTableDefinition(), categories, Comparable.class, "Invalid data type in category column: column=" + categories, this.getPlotInfo());
        ArgumentValidations.assertIsNumericOrTime(swappableTable.getTableDefinition(), valueCol, "Invalid data type in data column: column=" + valueCol, this.getPlotInfo());
        ArgumentValidations.assertIsNumericOrTime(swappableTable.getTableDefinition(), errorBarLowCol, "Invalid data type in data column: column=" + errorBarLowCol, this.getPlotInfo());
        ArgumentValidations.assertIsNumericOrTime(swappableTable.getTableDefinition(), errorBarHighCol, "Invalid data type in data column: column=" + errorBarHighCol, this.getPlotInfo());
        this.swappableTable = swappableTable;
        this.categoryCol = categories;
        this.valueCol = valueCol;
        this.errorBarLowCol = errorBarLowCol;
        this.errorBarHighCol = errorBarHighCol;
        this.kernel = new CategoryErrorBarDataSeriesKernel(categories, valueCol, errorBarLowCol, errorBarHighCol, this.getPlotInfo());
    }

    private CategoryErrorBarDataSeriesSwappablePartitionedTable(CategoryErrorBarDataSeriesSwappablePartitionedTable series, AxesImpl axes) {
        super(series, axes);
        this.swappableTable = series.swappableTable;
        this.categoryCol = series.categoryCol;
        this.valueCol = series.valueCol;
        this.errorBarLowCol = series.errorBarLowCol;
        this.errorBarHighCol = series.errorBarHighCol;
        this.kernel = new CategoryErrorBarDataSeriesKernel(this.categoryCol, this.valueCol, this.errorBarLowCol, this.errorBarHighCol, this.getPlotInfo());
    }

    @Override
    public CategoryErrorBarDataSeriesSwappablePartitionedTable copy(AxesImpl axes) {
        return new CategoryErrorBarDataSeriesSwappablePartitionedTable(this, axes);
    }

    @Override
    public int size() {
        return this.kernel.size();
    }

    @Override
    public Collection<Comparable> categories() {
        return this.kernel.categories();
    }

    @Override
    public Number getValue(Comparable category) {
        return this.kernel.getValue(category);
    }

    @Override
    public long getCategoryLocation(Comparable category) {
        return this.kernel.getCategoryKey(category);
    }

    @Override
    public Number getStartY(Comparable category) {
        return this.kernel.getStartY(category);
    }

    @Override
    public Number getEndY(Comparable category) {
        return this.kernel.getEndY(category);
    }

    @Override
    protected SwappableTable getSwappableTable() {
        return this.swappableTable;
    }

    @Override
    protected String getCategoryCol() {
        return this.categoryCol;
    }

    @Override
    protected String getNumericCol() {
        return this.valueCol;
    }
}

