/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.categoryerrorbar;

import io.deephaven.engine.table.Table;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.SeriesInternal;
import io.deephaven.plot.datasets.category.AbstractTableBasedCategoryDataSeries;
import io.deephaven.plot.datasets.category.CategoryTableDataSeriesInternal;
import io.deephaven.plot.datasets.categoryerrorbar.CategoryErrorBarDataSeriesInternal;
import io.deephaven.plot.datasets.categoryerrorbar.CategoryErrorBarDataSeriesKernel;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.TableHandle;
import java.util.Collection;

public class CategoryErrorBarDataSeriesPartitionedTable
extends AbstractTableBasedCategoryDataSeries
implements CategoryErrorBarDataSeriesInternal,
CategoryTableDataSeriesInternal,
SeriesInternal {
    private static final long serialVersionUID = 2L;
    private final TableHandle tableHandle;
    private transient boolean isInit = false;
    private final String categoryCol;
    private final String valueCol;
    private final String errorBarLowCol;
    private final String errorBarHighCol;
    private transient CategoryErrorBarDataSeriesKernel kernel;

    public CategoryErrorBarDataSeriesPartitionedTable(AxesImpl axes, int id, Comparable name, TableHandle tableHandle, String categoryCol, String valueCol, String errorBarLowCol, String errorBarHighCol) {
        super(axes, id, name);
        ArgumentValidations.assertNotNull(axes, "axes", this.getPlotInfo());
        ArgumentValidations.assertNotNull(tableHandle, "table", this.getPlotInfo());
        ArgumentValidations.assertIsNumericOrTimeOrCharOrComparableInstance(tableHandle.getFinalTableDefinition(), categoryCol, "Invalid data type in category column: column=" + categoryCol, this.getPlotInfo());
        ArgumentValidations.assertIsNumericOrTime(tableHandle.getFinalTableDefinition(), valueCol, "Invalid data type in data column: column=" + valueCol, this.getPlotInfo());
        ArgumentValidations.assertIsNumericOrTime(tableHandle.getFinalTableDefinition(), errorBarLowCol, "Invalid data type in data column: column=" + errorBarLowCol, this.getPlotInfo());
        ArgumentValidations.assertIsNumericOrTime(tableHandle.getFinalTableDefinition(), errorBarHighCol, "Invalid data type in data column: column=" + errorBarHighCol, this.getPlotInfo());
        this.tableHandle = tableHandle;
        this.categoryCol = categoryCol;
        this.valueCol = valueCol;
        this.errorBarLowCol = errorBarLowCol;
        this.errorBarHighCol = errorBarHighCol;
        this.kernel = new CategoryErrorBarDataSeriesKernel(categoryCol, valueCol, errorBarLowCol, errorBarHighCol, this.getPlotInfo());
    }

    private CategoryErrorBarDataSeriesPartitionedTable(CategoryErrorBarDataSeriesPartitionedTable series, AxesImpl axes) {
        super(series, axes);
        this.tableHandle = series.tableHandle;
        this.categoryCol = series.categoryCol;
        this.valueCol = series.valueCol;
        this.errorBarLowCol = series.errorBarLowCol;
        this.errorBarHighCol = series.errorBarHighCol;
        this.kernel = new CategoryErrorBarDataSeriesKernel(this.categoryCol, this.valueCol, this.errorBarLowCol, this.errorBarHighCol, this.getPlotInfo());
    }

    @Override
    public CategoryErrorBarDataSeriesPartitionedTable copy(AxesImpl axes) {
        return new CategoryErrorBarDataSeriesPartitionedTable(this, axes);
    }

    @Override
    public int size() {
        return this.kernel.size();
    }

    @Override
    public Collection<Comparable> categories() {
        return this.kernel.categories();
    }

    @Override
    public Number getValue(Comparable category) {
        return this.kernel.getValue(category);
    }

    @Override
    public long getCategoryLocation(Comparable category) {
        return this.kernel.getCategoryKey(category);
    }

    @Override
    public Number getStartY(Comparable category) {
        return this.kernel.getStartY(category);
    }

    @Override
    public Number getEndY(Comparable category) {
        return this.kernel.getEndY(category);
    }

    @Override
    protected Table getTable() {
        return this.tableHandle.getTable();
    }

    @Override
    protected String getCategoryCol() {
        return this.categoryCol;
    }

    @Override
    protected String getValueCol() {
        return this.valueCol;
    }

    public TableHandle getTableHandle() {
        return this.tableHandle;
    }

    public String getCategoryColumn() {
        return this.categoryCol;
    }

    public String getValueColumn() {
        return this.valueCol;
    }

    public String getErrorBarLowColumn() {
        return this.errorBarLowCol;
    }

    public String getErrorBarHighColumn() {
        return this.errorBarHighCol;
    }
}

