/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.categoryerrorbar;

import gnu.trove.map.hash.TObjectLongHashMap;
import io.deephaven.engine.table.Table;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CategoryErrorBarDataSeriesKernel {
    private transient Table listenedToTable;
    private final String categoryCol;
    private final String valueColumn;
    private final String errorBarLowColumn;
    private final String errorBarHighColumn;
    private Collection<Comparable> categories = Collections.emptyList();
    private final TObjectLongHashMap<Comparable> catIndex = new TObjectLongHashMap(10, 0.75f, -1L);
    private final Map<Comparable, Number> data = new HashMap<Comparable, Number>();
    private final Map<Comparable, Number> yLowData = new HashMap<Comparable, Number>();
    private final Map<Comparable, Number> yHighData = new HashMap<Comparable, Number>();
    private double yMin;
    private double yMax;

    public CategoryErrorBarDataSeriesKernel(@NotNull String categoryCol, @NotNull String valueColumn, @NotNull String errorBarLowColumn, @NotNull String errorBarHighColumn, @NotNull PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(this.categories, "categories", plotInfo);
        ArgumentValidations.assertNotNull(valueColumn, "values", plotInfo);
        ArgumentValidations.assertNotNull(errorBarLowColumn, "yLow", plotInfo);
        ArgumentValidations.assertNotNull(errorBarHighColumn, "yHigh", plotInfo);
        this.categoryCol = categoryCol;
        this.valueColumn = valueColumn;
        this.errorBarLowColumn = errorBarLowColumn;
        this.errorBarHighColumn = errorBarHighColumn;
        this.initMinMax();
    }

    public synchronized void initMinMax() {
        this.yMin = Double.NaN;
        this.yMax = Double.NaN;
    }

    public synchronized int size() {
        return this.data.size();
    }

    public synchronized Collection<Comparable> categories() {
        return this.categories;
    }

    @Nullable
    public synchronized Number getValue(Comparable<?> category) {
        return this.data.get(category);
    }

    public synchronized long getCategoryKey(Comparable<?> category) {
        return this.catIndex.get(category);
    }

    public Number getStartY(Comparable<?> category) {
        return this.yLowData.get(category);
    }

    public Number getEndY(Comparable<?> category) {
        return this.yHighData.get(category);
    }
}

