/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.category;

import gnu.trove.map.hash.TObjectLongHashMap;
import io.deephaven.engine.table.Table;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.ArgumentValidations;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CategoryDataSeriesKernel {
    private transient Table listenedToTable;
    private final String categoryCol;
    private final String valueColumn;
    private List<Comparable> categories = Collections.emptyList();
    private final TObjectLongHashMap<Comparable> catIndex = new TObjectLongHashMap(10, 0.75f, -1L);
    private final Map<Comparable, Number> data = new HashMap<Comparable, Number>();
    private double yMin;
    private double yMax;

    public CategoryDataSeriesKernel(@NotNull String categoryCol, @NotNull String valueColumn, @NotNull PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(this.categories, "categories", plotInfo);
        ArgumentValidations.assertNotNull(valueColumn, "values", plotInfo);
        this.categoryCol = categoryCol;
        this.valueColumn = valueColumn;
        this.initMinMax();
    }

    public synchronized void initMinMax() {
        this.yMin = Double.NaN;
        this.yMax = Double.NaN;
    }

    public synchronized int size() {
        return this.data.size();
    }

    public synchronized Collection<Comparable> categories() {
        return this.categories;
    }

    @Nullable
    public synchronized Number getValue(Comparable<?> category) {
        return this.data.get(category);
    }

    public synchronized long getCategoryKey(Comparable<?> category) {
        return this.catIndex.get(category);
    }
}

