/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets.category;

import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.context.QueryScope;
import io.deephaven.engine.table.Table;
import io.deephaven.gui.color.Paint;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.datasets.category.AbstractCategoryDataSeries;
import io.deephaven.plot.datasets.category.CategoryDataSeries;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.functions.FigureImplFunction;
import java.util.function.Function;

public abstract class AbstractTableBasedCategoryDataSeries
extends AbstractCategoryDataSeries {
    public AbstractTableBasedCategoryDataSeries(AxesImpl axes, int id, Comparable name) {
        super(axes, id, name);
    }

    public AbstractTableBasedCategoryDataSeries(AxesImpl axes, int id, Comparable name, AbstractCategoryDataSeries series) {
        super(axes, id, name, series);
    }

    public AbstractTableBasedCategoryDataSeries(AbstractCategoryDataSeries series, AxesImpl axes) {
        super(series, axes);
    }

    @Override
    public CategoryDataSeries pointShape(Function<Comparable, String> pointShapes) {
        String colName = "__POINT_SHAPE" + this.hashCode();
        this.chart().figure().registerTableFunction(this.getTable(), t -> this.constructTableFromFunctionOnCategoryCol((Table)t, (Function)pointShapes, String.class, colName));
        this.chart().figure().registerFigureFunction(new FigureImplFunction(f -> f.pointShape(this.getTable(), this.getCategoryCol(), colName), this));
        return this;
    }

    @Override
    public <NUMBER extends Number> CategoryDataSeries pointSize(Function<Comparable, NUMBER> pointSizes) {
        String colName = "__POINT_SIZE" + this.hashCode();
        this.chart().figure().registerTableFunction(this.getTable(), t -> this.constructTableFromFunctionOnCategoryCol((Table)t, pointSizes, Number.class, colName));
        this.chart().figure().registerFigureFunction(new FigureImplFunction(f -> f.pointSize(this.getTable(), this.getCategoryCol(), colName), this));
        return this;
    }

    @Override
    public <COLOR extends Paint> CategoryDataSeries pointColor(Function<Comparable, COLOR> pointColor) {
        String colName = "__POINT_COLOR" + this.hashCode();
        this.chart().figure().registerTableFunction(this.getTable(), t -> this.constructTableFromFunctionOnCategoryCol((Table)t, pointColor, Paint.class, colName));
        this.chart().figure().registerFigureFunction(new FigureImplFunction(f -> f.pointColor(this.getTable(), this.getCategoryCol(), colName), this));
        return this;
    }

    @Override
    public <COLOR extends Integer> CategoryDataSeries pointColorInteger(Function<Comparable, COLOR> colors) {
        String colName = "__POINT_COLOR" + this.hashCode();
        this.chart().figure().registerTableFunction(this.getTable(), t -> this.constructTableFromFunctionOnCategoryCol((Table)t, colors, Integer.class, colName));
        this.chart().figure().registerFigureFunction(new FigureImplFunction(f -> f.pointColor(this.getTable(), this.getCategoryCol(), colName), this));
        return this;
    }

    @Override
    public <LABEL> CategoryDataSeries pointLabel(Function<Comparable, LABEL> pointLabels) {
        String colName = "__POINT_LABEL" + this.hashCode();
        this.chart().figure().registerTableFunction(this.getTable(), t -> this.constructTableFromFunctionOnCategoryCol((Table)t, pointLabels, Object.class, colName));
        this.chart().figure().registerFigureFunction(new FigureImplFunction(f -> f.pointLabel(this.getTable(), this.getCategoryCol(), colName), this));
        return this;
    }

    private <S, T> Table constructTableFromFunctionOnCategoryCol(Table t, Function<S, T> function, Class resultClass, String columnName) {
        return this.constructTableFromFunction(t, function, resultClass, this.getCategoryCol(), columnName);
    }

    private <S, T> Table constructTableFromFunctionOnNumericalCol(Table t, Function<S, T> function, Class resultClass, String columnName) {
        return this.constructTableFromFunction(t, function, resultClass, this.getValueCol(), columnName);
    }

    protected <S, T> Table constructTableFromFunction(Table t, Function<S, T> function, Class resultClass, String onColumn, String columnName) {
        ArgumentValidations.assertNotNull(function, "function", this.getPlotInfo());
        String queryFunction = columnName + "Function";
        QueryScope.addParam((String)queryFunction, function);
        ExecutionContext.getContext().getQueryLibrary().importClass(resultClass);
        return (Table)t.update(new String[]{columnName + " = (" + resultClass.getSimpleName() + ") " + queryFunction + ".apply(" + onColumn + ")"});
    }

    protected abstract Table getTable();

    protected abstract String getCategoryCol();

    protected abstract String getValueCol();
}

