/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets;

import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.errors.PlotUnsupportedOperationException;
import io.deephaven.plot.util.ArgumentValidations;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DynamicSeriesNamer
implements Serializable {
    private static final long serialVersionUID = 1512466762187163906L;
    private final Set<String> names = new LinkedHashSet<String>();
    private final List<String> namesList = new ArrayList<String>();
    private final Map<String, Integer> generatedNames = new LinkedHashMap<String, Integer>();

    public synchronized void add(Comparable name, PlotInfo plotInfo) {
        String nameString = name.toString();
        boolean inSet = this.names.add(nameString);
        if (!inSet) {
            throw new PlotUnsupportedOperationException("Series with the same name already exists in the collection.  name=" + nameString, plotInfo);
        }
        this.namesList.add(nameString);
    }

    public synchronized void removeAll(Collection<? extends Comparable> names) {
        for (Comparable comparable : names) {
            this.names.remove(comparable.toString());
            this.namesList.remove(comparable.toString());
            this.generatedNames.remove(comparable.toString());
        }
    }

    public synchronized String makeUnusedName(String potentialName, PlotInfo plotInfo) {
        ArgumentValidations.assertNotNull(potentialName, "SeriesName must not be null", plotInfo);
        Object tempName = potentialName;
        while (this.names.contains(tempName)) {
            int index = this.generatedNames.getOrDefault(potentialName, 1);
            this.generatedNames.put(potentialName, index + 1);
            tempName = potentialName + " " + index;
        }
        this.names.add((String)tempName);
        this.namesList.add((String)tempName);
        return tempName;
    }

    public synchronized List<Comparable> getNames() {
        return Collections.unmodifiableList(this.namesList);
    }

    public synchronized void clear() {
        this.names.clear();
        this.namesList.clear();
        this.generatedNames.clear();
    }
}

