/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.datasets;

import io.deephaven.gui.color.Color;
import io.deephaven.gui.color.Paint;
import io.deephaven.plot.AbstractSeriesInternal;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.ChartImpl;
import io.deephaven.plot.LineStyle;
import io.deephaven.plot.datasets.DataSeriesInternal;
import io.deephaven.plot.util.PlotUtils;
import java.io.Serializable;

public abstract class AbstractDataSeries
extends AbstractSeriesInternal
implements DataSeriesInternal,
Serializable {
    private static final long serialVersionUID = 8733895549099825055L;
    private Boolean linesVisible = null;
    private Boolean shapesVisible = null;
    private boolean gradientVisible = false;
    private Paint lineColor = null;
    private Paint errorBarColor = null;
    private LineStyle lineStyle = null;
    private String pointLabelFormat = null;
    private String xToolTipPattern = null;
    private String yToolTipPattern = null;

    public AbstractDataSeries(AxesImpl axes, int id, Comparable name, AbstractDataSeries series) {
        super(axes, id, name);
        if (series != null) {
            this.pointLabelFormat = series.pointLabelFormat;
            this.linesVisible = series.linesVisible;
            this.shapesVisible = series.shapesVisible;
            this.gradientVisible = series.gradientVisible;
            this.lineColor = series.lineColor;
            this.errorBarColor = series.errorBarColor;
            this.lineStyle = series.lineStyle;
            this.pointLabelFormat = series.pointLabelFormat;
            this.xToolTipPattern = series.xToolTipPattern;
            this.yToolTipPattern = series.yToolTipPattern;
        }
    }

    protected AbstractDataSeries(AbstractDataSeries series, AxesImpl axes) {
        super(series, axes);
        this.pointLabelFormat = series.pointLabelFormat;
        this.linesVisible = series.linesVisible;
        this.shapesVisible = series.shapesVisible;
        this.gradientVisible = series.gradientVisible;
        this.lineColor = series.lineColor;
        this.errorBarColor = series.errorBarColor;
        this.lineStyle = series.lineStyle;
        this.pointLabelFormat = series.pointLabelFormat;
        this.xToolTipPattern = series.xToolTipPattern;
        this.yToolTipPattern = series.yToolTipPattern;
    }

    @Override
    public ChartImpl chart() {
        return this.axes().chart();
    }

    @Override
    public Paint getLineColor() {
        return this.lineColor;
    }

    @Override
    public Paint getErrorBarColor() {
        return this.errorBarColor;
    }

    @Override
    public LineStyle getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public Boolean getLinesVisible() {
        return this.linesVisible;
    }

    @Override
    public Boolean getPointsVisible() {
        return this.shapesVisible;
    }

    @Override
    public boolean getGradientVisible() {
        return this.gradientVisible;
    }

    @Override
    public String getPointLabelFormat() {
        return this.pointLabelFormat;
    }

    @Override
    public String getXToolTipPattern() {
        return this.xToolTipPattern;
    }

    @Override
    public String getYToolTipPattern() {
        return this.yToolTipPattern;
    }

    protected void setLinesVisible(Boolean visible) {
        this.linesVisible = visible;
    }

    protected void setPointsVisible(Boolean visible) {
        this.shapesVisible = visible;
    }

    protected void setGradientVisible(boolean visible) {
        this.gradientVisible = visible;
    }

    protected void setLineColor(Paint color) {
        this.lineColor = color;
    }

    protected void setLineColor(int color) {
        this.lineColor = PlotUtils.intToColor(this.chart(), color);
    }

    protected void setLineColor(String color) {
        this.lineColor = Color.color((String)color);
    }

    protected void setErrorBarColor(Paint color) {
        this.errorBarColor = color;
    }

    protected void setErrorBarColor(int color) {
        this.setErrorBarColor(PlotUtils.intToColor(this.chart(), color));
    }

    protected void setErrorBarColor(String color) {
        this.setErrorBarColor((Paint)Color.color((String)color));
    }

    protected void setLineStyle(LineStyle style) {
        this.lineStyle = style;
    }

    protected void setPointLabelFormat(String format) {
        this.pointLabelFormat = format;
    }

    protected void setXToolTipPattern(String format) {
        this.xToolTipPattern = format;
    }

    protected void setYToolTipPattern(String format) {
        this.yToolTipPattern = format;
    }
}

