/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot.axisformatters;

import io.deephaven.base.verify.Require;
import io.deephaven.configuration.Configuration;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class ScientificNumberFormatter
extends NumberFormat {
    private static final int DEFAULT_NUMBER_OF_DECIMALS = Configuration.getInstance().getIntegerWithDefault("plot.axis.ticks.numdecimals", 3);
    private static final double DEFAULT_LOWER_LIMIT = Configuration.getInstance().getDoubleWithDefault("plot.axis.ticks.lowerlimit", 1.0E-7);
    private static final double DEFAULT_UPPER_LIMIT = Configuration.getInstance().getDoubleWithDefault("plot.axis.ticks.upperlimit", 1.0E7);
    private final DecimalFormat decimalFormat = new DecimalFormat();
    private final DecimalFormat scientificFormat;
    private final double lowerLimit;
    private final double upperLimit;

    public ScientificNumberFormatter() {
        this(DEFAULT_NUMBER_OF_DECIMALS, DEFAULT_LOWER_LIMIT, DEFAULT_UPPER_LIMIT);
    }

    public ScientificNumberFormatter(int numDecimals, double lowerLimit, double upperLimit) {
        Require.geq((int)numDecimals, (String)"numDecimals", (int)0);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        Object format = "0.";
        for (int i = 0; i < numDecimals; ++i) {
            format = (String)format + "#";
        }
        format = (String)format + "E0";
        this.scientificFormat = new DecimalFormat((String)format);
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.formatInternal(Math.abs(number), toAppendTo, pos, 0L, number, false);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.formatInternal(Math.abs(number), toAppendTo, pos, number, 0.0, true);
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        return this.decimalFormat.parse(source, parsePosition);
    }

    private StringBuffer formatInternal(double abs, StringBuffer toAppendTo, FieldPosition pos, long number1, double number2, boolean isLong) {
        if (abs < this.lowerLimit && abs > 0.0 || abs > this.upperLimit) {
            if (isLong) {
                return this.scientificFormat.format(number1, toAppendTo, pos);
            }
            return this.scientificFormat.format(number2, toAppendTo, pos);
        }
        if (isLong) {
            return this.decimalFormat.format(number1, toAppendTo, pos);
        }
        return this.decimalFormat.format(number2, toAppendTo, pos);
    }
}

