/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot;

import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.AxesLocation;
import io.deephaven.plot.BaseFigureImpl;
import io.deephaven.plot.SeriesInternal;
import java.io.Serializable;

public class SeriesLocation
implements Serializable {
    private static final long serialVersionUID = 3878962519670912774L;
    private final AxesLocation axesLocation;
    private final int id;

    public SeriesLocation(SeriesInternal series) {
        this.axesLocation = new AxesLocation(series.axes());
        this.id = series.id();
    }

    public SeriesInternal get(BaseFigureImpl figure) {
        AxesImpl axes = this.axesLocation.get(figure);
        return axes.series(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeriesLocation that = (SeriesLocation)o;
        if (this.id != that.id) {
            return false;
        }
        return this.axesLocation != null ? this.axesLocation.equals(that.axesLocation) : that.axesLocation == null;
    }

    public int hashCode() {
        int result = this.axesLocation != null ? this.axesLocation.hashCode() : 0;
        result = 31 * result + this.id;
        return result;
    }
}

