/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot;

import io.deephaven.plot.util.PlotUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class LineStyle
implements Serializable {
    private static final long serialVersionUID = 7567372312882381923L;
    private static final double DEFAULT_WIDTH = 1.0;
    private static final LineEndStyle DEFAULT_ENDSTYLE = LineEndStyle.ROUND;
    private static final LineJoinStyle DEFAULT_JOINSTYLE = LineJoinStyle.ROUND;
    private static final double[] DEFAULT_DASHPATTERN = null;
    private final double width;
    private final LineEndStyle endStyle;
    private final LineJoinStyle joinStyle;
    private final float[] dashPattern;

    public static LineEndStyle lineEndStyle(String style) {
        if (style == null) {
            throw new IllegalArgumentException("LineEndStyle can not be null");
        }
        try {
            return LineEndStyle.valueOf(style.toUpperCase());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("LineEndStyle " + style + " is not defined");
        }
    }

    public static String[] lineEndStyleNames() {
        return (String[])Arrays.stream(LineEndStyle.values()).map(Enum::name).toArray(String[]::new);
    }

    public static LineJoinStyle lineJoinStyle(String style) {
        if (style == null) {
            throw new IllegalArgumentException("LineJoinStyle can not be null");
        }
        try {
            return LineJoinStyle.valueOf(style.toUpperCase());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("LineJoinStyle " + style + " is not defined");
        }
    }

    public static String[] lineJoinStyleNames() {
        return (String[])Arrays.stream(LineJoinStyle.values()).map(Enum::name).toArray(String[]::new);
    }

    public LineStyle(double width, LineEndStyle endStyle, LineJoinStyle joinStyle, double ... dashPattern) {
        this.width = width;
        this.endStyle = endStyle;
        this.joinStyle = joinStyle;
        this.dashPattern = PlotUtils.toFloat(dashPattern);
        this.assertDashPatternOk(dashPattern);
    }

    public <T extends Number> LineStyle(double width, LineEndStyle endStyle, LineJoinStyle joinStyle, List<T> dashPattern) {
        this(width, endStyle, joinStyle, dashPattern == null ? null : dashPattern.stream().mapToDouble(x -> x == null ? Double.NaN : x.doubleValue()).toArray());
    }

    public LineStyle(double width, String endStyle, String joinStyle, double ... dashPattern) {
        this(width, LineStyle.lineEndStyle(endStyle), LineStyle.lineJoinStyle(joinStyle), dashPattern);
    }

    public <T extends Number> LineStyle(double width, String endStyle, String joinStyle, List<T> dashPattern) {
        this(width, LineStyle.lineEndStyle(endStyle), LineStyle.lineJoinStyle(joinStyle), dashPattern == null ? null : dashPattern.stream().mapToDouble(x -> x == null ? Double.NaN : x.doubleValue()).toArray());
    }

    public LineStyle(double width) {
        this(width, DEFAULT_ENDSTYLE, DEFAULT_JOINSTYLE, DEFAULT_DASHPATTERN);
    }

    public LineStyle(double width, double[] dashPattern) {
        this(width, DEFAULT_ENDSTYLE, DEFAULT_JOINSTYLE, dashPattern);
    }

    public LineStyle(double width, int[] dashPattern) {
        this(width, DEFAULT_ENDSTYLE, DEFAULT_JOINSTYLE, PlotUtils.toDouble(dashPattern));
    }

    public LineStyle(double width, long[] dashPattern) {
        this(width, DEFAULT_ENDSTYLE, DEFAULT_JOINSTYLE, PlotUtils.toDouble(dashPattern));
    }

    public LineStyle(double width, float[] dashPattern) {
        this(width, DEFAULT_ENDSTYLE, DEFAULT_JOINSTYLE, PlotUtils.toDouble(dashPattern));
    }

    public <T extends Number> LineStyle(double width, T[] dashPattern) {
        this(width, DEFAULT_ENDSTYLE, DEFAULT_JOINSTYLE, PlotUtils.toDouble(dashPattern));
    }

    public <T extends Number> LineStyle(double width, List<T> dashPattern) {
        this(width, DEFAULT_ENDSTYLE, DEFAULT_JOINSTYLE, dashPattern);
    }

    public LineStyle(double ... dashPattern) {
        this(1.0, DEFAULT_ENDSTYLE, DEFAULT_JOINSTYLE, dashPattern);
    }

    public <T extends Number> LineStyle(List<T> dashPattern) {
        this(1.0, DEFAULT_ENDSTYLE, DEFAULT_JOINSTYLE, dashPattern);
    }

    public LineStyle(String endStyle, String joinStyle) {
        this(1.0, LineStyle.lineEndStyle(endStyle), LineStyle.lineJoinStyle(joinStyle), DEFAULT_DASHPATTERN);
    }

    public LineStyle() {
        this(1.0, DEFAULT_ENDSTYLE, DEFAULT_JOINSTYLE, DEFAULT_DASHPATTERN);
    }

    public static LineStyle lineStyle(double width, LineEndStyle endStyle, LineJoinStyle joinStyle, double ... dashPattern) {
        return new LineStyle(width, endStyle, joinStyle, dashPattern);
    }

    public static <T extends Number> LineStyle lineStyle(double width, LineEndStyle endStyle, LineJoinStyle joinStyle, List<T> dashPattern) {
        return new LineStyle(width, endStyle, joinStyle, dashPattern);
    }

    public static LineStyle lineStyle(double width, String endStyle, String joinStyle, double ... dashPattern) {
        return new LineStyle(width, endStyle, joinStyle, dashPattern);
    }

    public static <T extends Number> LineStyle lineStyle(double width, String endStyle, String joinStyle, List<T> dashPattern) {
        return new LineStyle(width, endStyle, joinStyle, dashPattern);
    }

    public static LineStyle lineStyle(double width) {
        return new LineStyle(width);
    }

    public static LineStyle lineStyle(double width, double[] dashPattern) {
        return new LineStyle(width, dashPattern);
    }

    public static LineStyle lineStyle(double width, int[] dashPattern) {
        return new LineStyle(width, dashPattern);
    }

    public static LineStyle lineStyle(double width, long[] dashPattern) {
        return new LineStyle(width, dashPattern);
    }

    public static LineStyle lineStyle(double width, float[] dashPattern) {
        return new LineStyle(width, dashPattern);
    }

    public static <T extends Number> LineStyle lineStyle(double width, T[] dashPattern) {
        return new LineStyle(width, dashPattern);
    }

    public static <T extends Number> LineStyle lineStyle(double width, List<T> dashPattern) {
        return new LineStyle(width, dashPattern);
    }

    public static LineStyle lineStyle(double ... dashPattern) {
        return new LineStyle(dashPattern);
    }

    public static <T extends Number> LineStyle lineStyle(List<T> dashPattern) {
        return new LineStyle(dashPattern);
    }

    public static LineStyle lineStyle(String endStyle, String joinStyle) {
        return new LineStyle(endStyle, joinStyle);
    }

    public static LineStyle lineStyle() {
        return new LineStyle();
    }

    public double getWidth() {
        return this.width;
    }

    public LineEndStyle getEndStyle() {
        return this.endStyle;
    }

    public LineJoinStyle getJoinStyle() {
        return this.joinStyle;
    }

    public float[] getDashPattern() {
        return this.dashPattern;
    }

    private void assertDashPatternOk(double[] dash) {
        if (dash == null) {
            return;
        }
        if (dash.length == 0) {
            throw new IllegalArgumentException("Dash pattern is empty. dash=" + Arrays.toString(dash));
        }
        for (double aDash : dash) {
            if (!(aDash <= 0.0)) continue;
            throw new IllegalArgumentException("Dash pattern contains zero or negative values: dash=" + Arrays.toString(dash));
        }
    }

    public String toString() {
        return "LineStyle{width=" + this.width + ", endStyle=" + String.valueOf((Object)this.endStyle) + ", joinStyle=" + String.valueOf((Object)this.joinStyle) + ", dashPattern=" + Arrays.toString(this.dashPattern) + "}";
    }

    public static enum LineEndStyle {
        BUTT,
        ROUND,
        SQUARE;

    }

    public static enum LineJoinStyle {
        BEVEL,
        MITER,
        ROUND;

    }
}

