/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot;

import groovy.lang.Closure;
import io.deephaven.base.verify.Require;
import io.deephaven.engine.table.PartitionedTable;
import io.deephaven.engine.table.Table;
import io.deephaven.gui.color.Paint;
import io.deephaven.gui.shape.Shape;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.AxesLocation;
import io.deephaven.plot.AxisImpl;
import io.deephaven.plot.AxisLocation;
import io.deephaven.plot.BaseFigureImpl;
import io.deephaven.plot.ChartImpl;
import io.deephaven.plot.ChartLocation;
import io.deephaven.plot.Figure;
import io.deephaven.plot.FigureWidget;
import io.deephaven.plot.Font;
import io.deephaven.plot.LineStyle;
import io.deephaven.plot.PlotStyle;
import io.deephaven.plot.Series;
import io.deephaven.plot.SeriesInternal;
import io.deephaven.plot.SeriesLocation;
import io.deephaven.plot.axisformatters.AxisFormat;
import io.deephaven.plot.axistransformations.AxisTransform;
import io.deephaven.plot.datasets.DataSeries;
import io.deephaven.plot.datasets.DataSeriesInternal;
import io.deephaven.plot.datasets.category.CategoryDataSeries;
import io.deephaven.plot.datasets.category.CategoryDataSeriesInternal;
import io.deephaven.plot.datasets.category.CategoryDataSeriesPartitionedTable;
import io.deephaven.plot.datasets.category.CategoryDataSeriesSwappablePartitionedTable;
import io.deephaven.plot.datasets.data.IndexableData;
import io.deephaven.plot.datasets.data.IndexableNumericData;
import io.deephaven.plot.datasets.interval.IntervalXYDataSeries;
import io.deephaven.plot.datasets.interval.IntervalXYDataSeriesArray;
import io.deephaven.plot.datasets.multiseries.MultiCatSeries;
import io.deephaven.plot.datasets.multiseries.MultiCatSeriesSwappable;
import io.deephaven.plot.datasets.multiseries.MultiOHLCSeries;
import io.deephaven.plot.datasets.multiseries.MultiOHLCSeriesSwappable;
import io.deephaven.plot.datasets.multiseries.MultiSeries;
import io.deephaven.plot.datasets.multiseries.MultiXYErrorBarSeries;
import io.deephaven.plot.datasets.multiseries.MultiXYErrorBarSeriesSwappable;
import io.deephaven.plot.datasets.multiseries.MultiXYSeries;
import io.deephaven.plot.datasets.multiseries.MultiXYSeriesSwappable;
import io.deephaven.plot.datasets.ohlc.OHLCDataSeries;
import io.deephaven.plot.datasets.ohlc.OHLCDataSeriesArray;
import io.deephaven.plot.datasets.ohlc.OHLCDataSeriesTableArray;
import io.deephaven.plot.datasets.xy.XYDataSeries;
import io.deephaven.plot.datasets.xy.XYDataSeriesArray;
import io.deephaven.plot.datasets.xy.XYDataSeriesFunction;
import io.deephaven.plot.datasets.xy.XYDataSeriesFunctionImpl;
import io.deephaven.plot.datasets.xyerrorbar.XYErrorBarDataSeries;
import io.deephaven.plot.datasets.xyerrorbar.XYErrorBarDataSeriesArray;
import io.deephaven.plot.errors.PlotRuntimeException;
import io.deephaven.plot.errors.PlotUnsupportedOperationException;
import io.deephaven.plot.filters.SelectableDataSet;
import io.deephaven.plot.util.functions.FigureImplFunction;
import io.deephaven.plot.util.tables.PartitionedTableHandle;
import io.deephaven.plot.util.tables.TableBackedPartitionedTableHandle;
import io.deephaven.plot.util.tables.TableHandle;
import io.deephaven.time.calendar.BusinessCalendar;
import io.deephaven.util.type.ArrayTypeUtils;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;

public class FigureImpl
implements Figure {
    private static final long serialVersionUID = -4519904656095275663L;
    private final BaseFigureImpl figure;
    private final ChartLocation lastChart;
    private final AxesLocation lastAxes;
    private final AxisLocation lastAxis;
    private final SeriesLocation lastSeries;
    private final Map<ChartLocation, AxesLocation> lastAxesMap;
    private final Map<AxesLocation, AxisLocation> lastAxisMap;
    private final Map<AxesLocation, SeriesLocation> lastSeriesMap;

    private FigureImpl(BaseFigureImpl figure, ChartLocation lastChart, AxesLocation lastAxes, AxisLocation lastAxis, SeriesLocation lastSeries, Map<ChartLocation, AxesLocation> lastAxesMap, Map<AxesLocation, AxisLocation> lastAxisMap, Map<AxesLocation, SeriesLocation> lastSeriesMap) {
        this.figure = (BaseFigureImpl)Require.neqNull((Object)figure, (String)"figure");
        this.lastChart = lastChart;
        this.lastAxes = lastAxes;
        this.lastAxis = lastAxis;
        this.lastSeries = lastSeries;
        this.lastAxesMap = new HashMap<ChartLocation, AxesLocation>(lastAxesMap);
        this.lastAxisMap = new HashMap<AxesLocation, AxisLocation>(lastAxisMap);
        this.lastSeriesMap = new HashMap<AxesLocation, SeriesLocation>(lastSeriesMap);
        if (this.lastAxes != null) {
            this.lastAxesMap.put(this.lastChart, this.lastAxes);
        }
        if (this.lastAxis != null) {
            this.lastAxisMap.put(this.lastAxes, this.lastAxis);
        }
        if (this.lastSeries != null) {
            this.lastSeriesMap.put(this.lastAxes, this.lastSeries);
        }
    }

    public FigureImpl(FigureImpl figure) {
        this.figure = ((FigureImpl)Require.neqNull((Object)figure, (String)"figure")).figure;
        this.lastChart = figure.lastChart;
        this.lastAxes = figure.lastAxes;
        this.lastAxis = figure.lastAxis;
        this.lastSeries = figure.lastSeries;
        this.lastAxesMap = figure.lastAxesMap;
        this.lastAxisMap = figure.lastAxisMap;
        this.lastSeriesMap = figure.lastSeriesMap;
    }

    private FigureImpl(BaseFigureImpl figure) {
        this(figure, null, null, null, null, new HashMap<ChartLocation, AxesLocation>(), new HashMap<AxesLocation, AxisLocation>(), new HashMap<AxesLocation, SeriesLocation>());
    }

    FigureImpl() {
        this(new BaseFigureImpl());
    }

    FigureImpl(int numRows, int numCols) {
        this(new BaseFigureImpl(numRows, numCols));
    }

    private AxesLocation resolveLastAxes(BaseFigureImpl figure, ChartLocation chartLoc) {
        if (chartLoc == null) {
            return null;
        }
        AxesLocation a0 = this.lastAxesMap.get(chartLoc);
        if (a0 != null) {
            return a0;
        }
        List<AxesImpl> axs = chartLoc.get(figure).getAxes();
        return axs.isEmpty() ? null : new AxesLocation(axs.get(axs.size() - 1));
    }

    private AxisLocation resolveLastAxis(BaseFigureImpl figure, AxesLocation axesLoc) {
        if (axesLoc == null) {
            return null;
        }
        AxisLocation a0 = this.lastAxisMap.get(axesLoc);
        if (a0 != null) {
            return a0;
        }
        AxesImpl axs = axesLoc.get(figure);
        return axs.dimension() <= 0 ? null : new AxisLocation(axs.axis(axs.dimension() - 1));
    }

    private SeriesLocation resolveLastSeries(BaseFigureImpl figure, AxesLocation axesLoc) {
        if (axesLoc == null) {
            return null;
        }
        SeriesLocation s0 = this.lastSeriesMap.get(axesLoc);
        if (s0 != null) {
            return s0;
        }
        SeriesInternal s1 = axesLoc.get(figure).dataSeries().lastSeries();
        return s1 == null ? null : new SeriesLocation(s1);
    }

    public BaseFigureImpl getFigure() {
        return this.figure;
    }

    private FigureImpl make(BaseFigureImpl figure) {
        ChartLocation chartLoc = this.lastChart;
        AxesLocation axesLoc = this.lastAxes;
        AxisLocation axisLoc = this.lastAxis;
        SeriesLocation seriesLoc = this.lastSeries;
        return new FigureImpl(figure, chartLoc, axesLoc, axisLoc, seriesLoc, this.lastAxesMap, this.lastAxisMap, this.lastSeriesMap);
    }

    private FigureImpl make(ChartImpl chart) {
        BaseFigureImpl figure = chart.figure();
        ChartLocation chartLoc = new ChartLocation(chart);
        AxesLocation axesLoc = this.resolveLastAxes(figure, chartLoc);
        AxisLocation axisLoc = this.resolveLastAxis(figure, axesLoc);
        SeriesLocation seriesLoc = this.resolveLastSeries(figure, axesLoc);
        return new FigureImpl(figure, chartLoc, axesLoc, axisLoc, seriesLoc, this.lastAxesMap, this.lastAxisMap, this.lastSeriesMap);
    }

    private FigureImpl make(AxesImpl axes) {
        BaseFigureImpl figure = axes.chart().figure();
        ChartLocation chartLoc = new ChartLocation(axes.chart());
        AxesLocation axesLoc = new AxesLocation(axes);
        AxisLocation axisLoc = this.resolveLastAxis(figure, axesLoc);
        SeriesLocation seriesLoc = this.resolveLastSeries(figure, axesLoc);
        return new FigureImpl(figure, chartLoc, axesLoc, axisLoc, seriesLoc, this.lastAxesMap, this.lastAxisMap, this.lastSeriesMap);
    }

    private FigureImpl make(AxesImpl axes, AxisImpl axis) {
        BaseFigureImpl figure = axis.chart().figure();
        ChartLocation chartLoc = new ChartLocation(axis.chart());
        AxesLocation axesLoc = axes == null ? this.lastAxes : new AxesLocation(axes);
        AxisLocation axisLoc = new AxisLocation(axis);
        SeriesLocation seriesLoc = this.resolveLastSeries(figure, axesLoc);
        return new FigureImpl(figure, chartLoc, axesLoc, axisLoc, seriesLoc, this.lastAxesMap, this.lastAxisMap, this.lastSeriesMap);
    }

    private FigureImpl make(SeriesInternal series) {
        BaseFigureImpl figure = series.axes().chart().figure();
        ChartLocation chartLoc = new ChartLocation(series.axes().chart());
        AxesLocation axesLoc = new AxesLocation(series.axes());
        AxisLocation axisLoc = this.resolveLastAxis(figure, axesLoc);
        SeriesLocation seriesLoc = new SeriesLocation(series);
        return new FigureImpl(figure, chartLoc, axesLoc, axisLoc, seriesLoc, this.lastAxesMap, this.lastAxisMap, this.lastSeriesMap);
    }

    private BaseFigureImpl figure(BaseFigureImpl figure) {
        return figure;
    }

    private ChartImpl chart(BaseFigureImpl figure) {
        if (this.lastChart == null) {
            return figure.newChart();
        }
        ChartImpl c = this.lastChart.get(figure);
        if (c == null) {
            c = figure.newChart();
        }
        return c;
    }

    private AxesImpl axes(BaseFigureImpl figure) {
        if (this.lastAxes == null) {
            return this.chart(figure).newAxes();
        }
        AxesImpl a = this.lastAxes.get(figure);
        if (a == null) {
            ChartImpl c = this.chart(figure);
            a = c.newAxes();
        }
        return a;
    }

    private AxisImpl axis(BaseFigureImpl figure) {
        if (this.lastAxis == null) {
            throw new PlotRuntimeException("No axes have been selected.", figure);
        }
        AxisImpl a = this.lastAxis.get(figure);
        if (a == null) {
            throw new PlotRuntimeException("No axes have been selected.", figure);
        }
        return a;
    }

    private Series series(BaseFigureImpl figure) {
        if (this.lastSeries == null) {
            throw new PlotRuntimeException("No series has been selected.", figure);
        }
        SeriesInternal s = this.lastSeries.get(figure);
        if (s == null) {
            throw new PlotRuntimeException("No series has been selected.", figure);
        }
        return s;
    }

    @Override
    public FigureImpl show() {
        BaseFigureImpl fc = this.onDisplay();
        return new FigureWidget(this.make(fc));
    }

    @Override
    public FigureImpl save(String path) {
        BaseFigureImpl fc = this.onDisplay();
        this.figure(fc).save(path);
        return this.make(fc);
    }

    @Override
    public FigureImpl save(String path, int width, int height) {
        BaseFigureImpl fc = this.onDisplay();
        this.figure(fc).save(path, width, height);
        return this.make(fc);
    }

    @Override
    public FigureImpl save(String path, boolean wait, long timeoutSeconds) {
        BaseFigureImpl fc = this.onDisplay();
        this.figure(fc).save(path, wait, timeoutSeconds);
        return this.make(fc);
    }

    @Override
    public FigureImpl save(String path, int width, int height, boolean wait, long timeoutSeconds) {
        BaseFigureImpl fc = this.onDisplay();
        this.figure(fc).save(path, width, height, wait, timeoutSeconds);
        return this.make(fc);
    }

    private BaseFigureImpl onDisplay() {
        FigureImpl fig = this.applyFunctionalProperties();
        BaseFigureImpl fc = fig.figure.copy();
        fc.validateInitialization();
        return fc;
    }

    private FigureImpl applyFunctionalProperties() {
        Map<Table, Set<Function<Table, Table>>> tableFunctionMap = this.getFigure().getTableFunctionMap();
        Map<PartitionedTable, Set<Function<PartitionedTable, PartitionedTable>>> partitionedTableFunctionMap = this.getFigure().getPartitionedTableFunctionMap();
        List<FigureImplFunction> figureFunctionList = this.getFigure().getFigureFunctionList();
        HashMap<Table, Table> finalTableComputation = new HashMap<Table, Table>();
        HashMap<PartitionedTable, PartitionedTable> finalPartitionedTableComputation = new HashMap<PartitionedTable, PartitionedTable>();
        HashSet<Table> allTables = new HashSet<Table>();
        HashSet<PartitionedTable> allPartitionedTables = new HashSet<PartitionedTable>();
        for (TableHandle tableHandle : this.getFigure().getTableHandles()) {
            allTables.add(tableHandle.getTable());
        }
        for (PartitionedTableHandle partitionedTableHandle : this.getFigure().getPartitionedTableHandles()) {
            if (partitionedTableHandle instanceof TableBackedPartitionedTableHandle) {
                allTables.add(((TableBackedPartitionedTableHandle)partitionedTableHandle).getTable());
            }
            if (partitionedTableHandle.getPartitionedTable() == null) continue;
            allPartitionedTables.add(partitionedTableHandle.getPartitionedTable());
        }
        for (Table table : allTables) {
            if (tableFunctionMap.get(table) != null) {
                finalTableComputation.computeIfAbsent(table, t -> {
                    Set functions = (Set)tableFunctionMap.get(initTable);
                    Table resultTable = initTable;
                    for (Function f : functions) {
                        resultTable = (Table)f.apply(resultTable);
                    }
                    return resultTable;
                });
                continue;
            }
            finalTableComputation.put(table, table);
        }
        for (TableHandle tableHandle : this.getFigure().getTableHandles()) {
            tableHandle.setTable((Table)finalTableComputation.get(tableHandle.getTable()));
        }
        for (PartitionedTableHandle partitionedTableHandle : this.getFigure().getPartitionedTableHandles()) {
            if (!(partitionedTableHandle instanceof TableBackedPartitionedTableHandle)) continue;
            ((TableBackedPartitionedTableHandle)partitionedTableHandle).setTable((Table)finalTableComputation.get(((TableBackedPartitionedTableHandle)partitionedTableHandle).getTable()));
        }
        for (PartitionedTable partitionedTable : allPartitionedTables) {
            if (partitionedTableFunctionMap.get(partitionedTable) != null) {
                finalPartitionedTableComputation.computeIfAbsent(partitionedTable, t -> {
                    Set functions = (Set)partitionedTableFunctionMap.get(initPartitionedTable);
                    PartitionedTable resultPartitionedTable = initPartitionedTable;
                    for (Function f : functions) {
                        resultPartitionedTable = (PartitionedTable)f.apply(resultPartitionedTable);
                    }
                    return resultPartitionedTable;
                });
                continue;
            }
            finalPartitionedTableComputation.put(partitionedTable, partitionedTable);
        }
        for (PartitionedTableHandle partitionedTableHandle : this.getFigure().getPartitionedTableHandles()) {
            partitionedTableHandle.setPartitionedTable((PartitionedTable)finalPartitionedTableComputation.get(partitionedTableHandle.getPartitionedTable()));
        }
        FigureImpl finalFigure = this;
        for (Function function : figureFunctionList) {
            finalFigure = (FigureImpl)function.apply(finalFigure);
        }
        tableFunctionMap.clear();
        partitionedTableFunctionMap.clear();
        figureFunctionList.clear();
        return finalFigure;
    }

    @Override
    public FigureImpl axes(String name) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = (AxesImpl)this.chart(fc).axes(name);
        return this.make(axes);
    }

    @Override
    public FigureImpl axes(int id) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = (AxesImpl)this.chart(fc).axes(id);
        return this.make(axes);
    }

    @Override
    public FigureImpl axesRemoveSeries(String ... removeSeriesNames) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).axesRemoveSeries(removeSeriesNames);
        return this.make(axes);
    }

    @Override
    public FigureImpl axis(int dim) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc);
        AxisImpl axis = axes.axis(dim);
        return this.make(axes, axis);
    }

    @Override
    public FigureImpl axisColor(String color) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).axisColor(color);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl axisColor(Paint color) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).axisColor(color);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl axisFormat(AxisFormat axisFormat) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).axisFormat(axisFormat);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl axisFormatPattern(String axisFormatPattern) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).axisFormatPattern(axisFormatPattern);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl axisLabel(String label) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).axisLabel(label);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl axisLabelFont(Font font) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).axisLabelFont(font);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl axisLabelFont(String family, String style, int size) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).axisLabelFont(family, style, size);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl businessTime() {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).businessTime();
        return this.make(null, axis);
    }

    @Override
    public FigureImpl businessTime(boolean useBusinessTime) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).businessTime(useBusinessTime);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl businessTime(BusinessCalendar calendar) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).businessTime(calendar);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl businessTime(SelectableDataSet sds, String calendar) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).businessTime(sds, calendar);
        return this.make(null, axis);
    }

    @Override
    public <T0 extends Comparable, T1 extends Number, T2 extends Number, T3 extends Number> FigureImpl catErrorBar(Comparable seriesName, T0[] categories, T1[] y, T2[] yLow, T3[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catErrorBar(seriesName, (Comparable[])categories, (Number[])y, (Number[])yLow, (Number[])yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catErrorBar(Comparable seriesName, T0[] categories, double[] y, double[] yLow, double[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catErrorBar(seriesName, (Comparable[])categories, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catErrorBar(Comparable seriesName, T0[] categories, float[] y, float[] yLow, float[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catErrorBar(seriesName, (Comparable[])categories, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catErrorBar(Comparable seriesName, T0[] categories, int[] y, int[] yLow, int[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catErrorBar(seriesName, (Comparable[])categories, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catErrorBar(Comparable seriesName, T0[] categories, long[] y, long[] yLow, long[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catErrorBar(seriesName, (Comparable[])categories, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catErrorBar(Comparable seriesName, T0[] categories, Instant[] y, Instant[] yLow, Instant[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catErrorBar(seriesName, (Comparable[])categories, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catErrorBar(Comparable seriesName, T0[] categories, Date[] y, Date[] yLow, Date[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catErrorBar(seriesName, (Comparable[])categories, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catErrorBar(Comparable seriesName, T0[] categories, short[] y, short[] yLow, short[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catErrorBar(seriesName, (Comparable[])categories, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable, T1 extends Number, T2 extends Number, T3 extends Number> FigureImpl catErrorBar(Comparable seriesName, T0[] categories, List<T1> y, List<T2> yLow, List<T3> yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catErrorBar(seriesName, (Comparable[])categories, (List)y, (List)yLow, (List)yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable, T1 extends Number, T2 extends Number, T3 extends Number> FigureImpl catErrorBar(Comparable seriesName, List<T0> categories, T1[] y, T2[] yLow, T3[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catErrorBar(seriesName, (List)categories, (Number[])y, (Number[])yLow, (Number[])yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catErrorBar(Comparable seriesName, List<T0> categories, double[] y, double[] yLow, double[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catErrorBar(seriesName, (List)categories, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catErrorBar(Comparable seriesName, List<T0> categories, float[] y, float[] yLow, float[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catErrorBar(seriesName, (List)categories, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catErrorBar(Comparable seriesName, List<T0> categories, int[] y, int[] yLow, int[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catErrorBar(seriesName, (List)categories, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catErrorBar(Comparable seriesName, List<T0> categories, long[] y, long[] yLow, long[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catErrorBar(seriesName, (List)categories, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catErrorBar(Comparable seriesName, List<T0> categories, short[] y, short[] yLow, short[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catErrorBar(seriesName, (List)categories, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable, T1 extends Number, T2 extends Number, T3 extends Number> FigureImpl catErrorBar(Comparable seriesName, List<T0> categories, List<T1> y, List<T2> yLow, List<T3> yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catErrorBar(seriesName, (List)categories, (List)y, (List)yLow, (List)yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl catErrorBar(Comparable seriesName, Table t, String categories, String y, String yLow, String yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        DataSeriesInternal series = (DataSeriesInternal)((Object)this.axes(fc).catErrorBar(seriesName, t, categories, y, yLow, yHigh));
        return this.make(series);
    }

    @Override
    public FigureImpl catErrorBar(Comparable seriesName, SelectableDataSet sds, String categories, String y, String yLow, String yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        DataSeriesInternal series = (DataSeriesInternal)((Object)this.axes(fc).catErrorBar(seriesName, sds, categories, y, yLow, yHigh));
        return this.make(series);
    }

    @Override
    public FigureImpl catErrorBarBy(Comparable seriesName, Table t, String categories, String y, String yLow, String yHigh, String ... byColumns) {
        BaseFigureImpl fc = this.figure.copy();
        SeriesInternal series = (SeriesInternal)((Object)this.axes(fc).catErrorBarBy(seriesName, t, categories, y, yLow, yHigh, byColumns));
        return this.make(series);
    }

    @Override
    public FigureImpl catErrorBarBy(Comparable seriesName, SelectableDataSet sds, String categories, String y, String yLow, String yHigh, String ... byColumns) {
        BaseFigureImpl fc = this.figure.copy();
        SeriesInternal series = (SeriesInternal)((Object)this.axes(fc).catErrorBarBy(seriesName, sds, categories, y, yLow, yHigh, byColumns));
        return this.make(series);
    }

    @Override
    public <T extends Comparable> FigureImpl catHistPlot(Comparable seriesName, T[] categories) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catHistPlot(seriesName, (Comparable[])categories);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl catHistPlot(Comparable seriesName, double[] categories) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeriesPartitionedTable series = this.axes(fc).catHistPlot(seriesName, categories);
        return this.make(series);
    }

    @Override
    public FigureImpl catHistPlot(Comparable seriesName, float[] categories) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeriesPartitionedTable series = this.axes(fc).catHistPlot(seriesName, categories);
        return this.make(series);
    }

    @Override
    public FigureImpl catHistPlot(Comparable seriesName, int[] categories) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeriesPartitionedTable series = this.axes(fc).catHistPlot(seriesName, categories);
        return this.make(series);
    }

    @Override
    public FigureImpl catHistPlot(Comparable seriesName, long[] categories) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeriesPartitionedTable series = this.axes(fc).catHistPlot(seriesName, categories);
        return this.make(series);
    }

    @Override
    public <T extends Comparable> FigureImpl catHistPlot(Comparable seriesName, List<T> categories) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catHistPlot(seriesName, (List)categories);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl catHistPlot(Comparable seriesName, Table t, String categories) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeriesPartitionedTable series = this.axes(fc).catHistPlot(seriesName, t, categories);
        return this.make(series);
    }

    @Override
    public FigureImpl catHistPlot(Comparable seriesName, SelectableDataSet sds, String categories) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeriesSwappablePartitionedTable series = this.axes(fc).catHistPlot(seriesName, sds, categories);
        return this.make(series);
    }

    @Override
    public <T0 extends Comparable, T1 extends Number> FigureImpl catPlot(Comparable seriesName, T0[] categories, T1[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (Comparable[])categories, (Number[])y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catPlot(Comparable seriesName, T0[] categories, double[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (Comparable[])categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catPlot(Comparable seriesName, T0[] categories, float[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (Comparable[])categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catPlot(Comparable seriesName, T0[] categories, int[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (Comparable[])categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catPlot(Comparable seriesName, T0[] categories, long[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (Comparable[])categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catPlot(Comparable seriesName, T0[] categories, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (Comparable[])categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catPlot(Comparable seriesName, T0[] categories, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (Comparable[])categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catPlot(Comparable seriesName, T0[] categories, short[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (Comparable[])categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable, T1 extends Number> FigureImpl catPlot(Comparable seriesName, T0[] categories, List<T1> y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (Comparable[])categories, (List)y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T1 extends Comparable> FigureImpl catPlot(Comparable seriesName, IndexableData<T1> categories, IndexableNumericData y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (IndexableData)categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable, T1 extends Number> FigureImpl catPlot(Comparable seriesName, List<T0> categories, T1[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (List)categories, (Number[])y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catPlot(Comparable seriesName, List<T0> categories, double[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (List)categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catPlot(Comparable seriesName, List<T0> categories, float[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (List)categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catPlot(Comparable seriesName, List<T0> categories, int[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (List)categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catPlot(Comparable seriesName, List<T0> categories, long[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (List)categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catPlot(Comparable seriesName, List<T0> categories, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (List)categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catPlot(Comparable seriesName, List<T0> categories, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (List)categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl catPlot(Comparable seriesName, List<T0> categories, short[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (List)categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable, T1 extends Number> FigureImpl catPlot(Comparable seriesName, List<T0> categories, List<T1> y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).catPlot(seriesName, (List)categories, (List)y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl catPlot(Comparable seriesName, Table t, String categories, String y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeriesInternal series = this.axes(fc).catPlot(seriesName, t, categories, y);
        return this.make(series);
    }

    @Override
    public FigureImpl catPlot(Comparable seriesName, SelectableDataSet sds, String categories, String y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeriesInternal series = this.axes(fc).catPlot(seriesName, sds, categories, y);
        return this.make(series);
    }

    @Override
    public FigureImpl catPlotBy(Comparable seriesName, Table t, String categories, String y, String ... byColumns) {
        BaseFigureImpl fc = this.figure.copy();
        MultiCatSeries series = this.axes(fc).catPlotBy(seriesName, t, categories, y, byColumns);
        return this.make(series);
    }

    @Override
    public FigureImpl catPlotBy(Comparable seriesName, SelectableDataSet sds, String categories, String y, String ... byColumns) {
        BaseFigureImpl fc = this.figure.copy();
        MultiCatSeriesSwappable series = this.axes(fc).catPlotBy(seriesName, sds, categories, y, byColumns);
        return this.make(series);
    }

    @Override
    public FigureImpl chart(int index) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.figure(fc).chart(index);
        return this.make(chart);
    }

    @Override
    public FigureImpl chart(int rowNum, int colNum) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.figure(fc).chart(rowNum, colNum);
        return this.make(chart);
    }

    @Override
    public FigureImpl chartRemoveSeries(String ... removeSeriesNames) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.chart(fc).chartRemoveSeries(removeSeriesNames);
        return this.make(chart);
    }

    @Override
    public FigureImpl chartTitle(String title) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.chart(fc).chartTitle(title);
        return this.make(chart);
    }

    @Override
    public FigureImpl chartTitle(Table t, String ... titleColumns) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = (ChartImpl)this.chart(fc).chartTitle(t, titleColumns);
        return this.make(chart);
    }

    @Override
    public FigureImpl chartTitle(SelectableDataSet sds, String ... titleColumns) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = (ChartImpl)this.chart(fc).chartTitle(sds, titleColumns);
        return this.make(chart);
    }

    @Override
    public FigureImpl chartTitle(boolean showColumnNamesInTitle, Table t, String ... titleColumns) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = (ChartImpl)this.chart(fc).chartTitle(showColumnNamesInTitle, t, titleColumns);
        return this.make(chart);
    }

    @Override
    public FigureImpl chartTitle(boolean showColumnNamesInTitle, SelectableDataSet sds, String ... titleColumns) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = (ChartImpl)this.chart(fc).chartTitle(showColumnNamesInTitle, sds, titleColumns);
        return this.make(chart);
    }

    @Override
    public FigureImpl chartTitle(String titleFormat, Table t, String ... titleColumns) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.chart(fc).chartTitle(titleFormat, t, titleColumns);
        return this.make(chart);
    }

    @Override
    public FigureImpl chartTitle(String titleFormat, SelectableDataSet sds, String ... titleColumns) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.chart(fc).chartTitle(titleFormat, sds, titleColumns);
        return this.make(chart);
    }

    @Override
    public FigureImpl chartTitleColor(String color) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.chart(fc).chartTitleColor(color);
        return this.make(chart);
    }

    @Override
    public FigureImpl chartTitleColor(Paint color) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.chart(fc).chartTitleColor(color);
        return this.make(chart);
    }

    @Override
    public FigureImpl chartTitleFont(Font font) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.chart(fc).chartTitleFont(font);
        return this.make(chart);
    }

    @Override
    public FigureImpl chartTitleFont(String family, String style, int size) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.chart(fc).chartTitleFont(family, style, size);
        return this.make(chart);
    }

    @Override
    public FigureImpl colSpan(int colSpan) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.chart(fc).colSpan(colSpan);
        return this.make(chart);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number, T3 extends Number> FigureImpl errorBarX(Comparable seriesName, T0[] x, T1[] xLow, T2[] xHigh, T3[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarX(seriesName, (Number[])x, (Number[])xLow, (Number[])xHigh, (Number[])y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number> FigureImpl errorBarX(Comparable seriesName, T0[] x, T1[] xLow, T2[] xHigh, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarX(seriesName, (Number[])x, (Number[])xLow, (Number[])xHigh, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number> FigureImpl errorBarX(Comparable seriesName, T0[] x, T1[] xLow, T2[] xHigh, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarX(seriesName, (Number[])x, (Number[])xLow, (Number[])xHigh, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, double[] x, double[] xLow, double[] xHigh, double[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, double[] x, double[] xLow, double[] xHigh, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, double[] x, double[] xLow, double[] xHigh, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, float[] x, float[] xLow, float[] xHigh, float[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, float[] x, float[] xLow, float[] xHigh, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, float[] x, float[] xLow, float[] xHigh, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, int[] x, int[] xLow, int[] xHigh, int[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, int[] x, int[] xLow, int[] xHigh, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, int[] x, int[] xLow, int[] xHigh, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, long[] x, long[] xLow, long[] xHigh, long[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, long[] x, long[] xLow, long[] xHigh, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, long[] x, long[] xLow, long[] xHigh, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public <T3 extends Number> FigureImpl errorBarX(Comparable seriesName, Instant[] x, Instant[] xLow, Instant[] xHigh, T3[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, (Number[])y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, Instant[] x, Instant[] xLow, Instant[] xHigh, double[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, Instant[] x, Instant[] xLow, Instant[] xHigh, float[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, Instant[] x, Instant[] xLow, Instant[] xHigh, int[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, Instant[] x, Instant[] xLow, Instant[] xHigh, long[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, Instant[] x, Instant[] xLow, Instant[] xHigh, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, Instant[] x, Instant[] xLow, Instant[] xHigh, short[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public <T3 extends Number> FigureImpl errorBarX(Comparable seriesName, Instant[] x, Instant[] xLow, Instant[] xHigh, List<T3> y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, (List)y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T3 extends Number> FigureImpl errorBarX(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, T3[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, (Number[])y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, double[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, float[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, int[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, long[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, short[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public <T3 extends Number> FigureImpl errorBarX(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, List<T3> y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, (List)y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, short[] x, short[] xLow, short[] xHigh, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, short[] x, short[] xLow, short[] xHigh, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, short[] x, short[] xLow, short[] xHigh, short[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarX(seriesName, x, xLow, xHigh, y);
        return this.make(series);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number> FigureImpl errorBarX(Comparable seriesName, List<T0> x, List<T1> xLow, List<T2> xHigh, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarX(seriesName, (List)x, (List)xLow, (List)xHigh, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number> FigureImpl errorBarX(Comparable seriesName, List<T0> x, List<T1> xLow, List<T2> xHigh, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarX(seriesName, (List)x, (List)xLow, (List)xHigh, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number, T3 extends Number> FigureImpl errorBarX(Comparable seriesName, List<T0> x, List<T1> xLow, List<T2> xHigh, List<T3> y) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarX(seriesName, (List)x, (List)xLow, (List)xHigh, (List)y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, Table t, String x, String xLow, String xHigh, String y) {
        BaseFigureImpl fc = this.figure.copy();
        DataSeriesInternal series = (DataSeriesInternal)((Object)this.axes(fc).errorBarX(seriesName, t, x, xLow, xHigh, y));
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarX(Comparable seriesName, SelectableDataSet sds, String x, String xLow, String xHigh, String y) {
        BaseFigureImpl fc = this.figure.copy();
        DataSeriesInternal series = (DataSeriesInternal)((Object)this.axes(fc).errorBarX(seriesName, sds, x, xLow, xHigh, y));
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXBy(Comparable seriesName, Table t, String x, String xLow, String xHigh, String y, String ... byColumns) {
        BaseFigureImpl fc = this.figure.copy();
        MultiXYErrorBarSeries series = this.axes(fc).errorBarXBy(seriesName, t, x, xLow, xHigh, y, byColumns);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXBy(Comparable seriesName, SelectableDataSet sds, String x, String xLow, String xHigh, String y, String ... byColumns) {
        BaseFigureImpl fc = this.figure.copy();
        MultiXYErrorBarSeriesSwappable series = this.axes(fc).errorBarXBy(seriesName, sds, x, xLow, xHigh, y, byColumns);
        return this.make(series);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number, T3 extends Number, T4 extends Number, T5 extends Number> FigureImpl errorBarXY(Comparable seriesName, T0[] x, T1[] xLow, T2[] xHigh, T3[] y, T4[] yLow, T5[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarXY(seriesName, (Number[])x, (Number[])xLow, (Number[])xHigh, (Number[])y, (Number[])yLow, (Number[])yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number> FigureImpl errorBarXY(Comparable seriesName, T0[] x, T1[] xLow, T2[] xHigh, Instant[] y, Instant[] yLow, Instant[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarXY(seriesName, (Number[])x, (Number[])xLow, (Number[])xHigh, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number> FigureImpl errorBarXY(Comparable seriesName, T0[] x, T1[] xLow, T2[] xHigh, Date[] y, Date[] yLow, Date[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarXY(seriesName, (Number[])x, (Number[])xLow, (Number[])xHigh, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, double[] x, double[] xLow, double[] xHigh, double[] y, double[] yLow, double[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, double[] x, double[] xLow, double[] xHigh, Instant[] y, Instant[] yLow, Instant[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, double[] x, double[] xLow, double[] xHigh, Date[] y, Date[] yLow, Date[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, float[] x, float[] xLow, float[] xHigh, float[] y, float[] yLow, float[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, float[] x, float[] xLow, float[] xHigh, Instant[] y, Instant[] yLow, Instant[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, float[] x, float[] xLow, float[] xHigh, Date[] y, Date[] yLow, Date[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, int[] x, int[] xLow, int[] xHigh, int[] y, int[] yLow, int[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, int[] x, int[] xLow, int[] xHigh, Instant[] y, Instant[] yLow, Instant[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, int[] x, int[] xLow, int[] xHigh, Date[] y, Date[] yLow, Date[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, long[] x, long[] xLow, long[] xHigh, long[] y, long[] yLow, long[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, long[] x, long[] xLow, long[] xHigh, Instant[] y, Instant[] yLow, Instant[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, long[] x, long[] xLow, long[] xHigh, Date[] y, Date[] yLow, Date[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public <T3 extends Number, T4 extends Number, T5 extends Number> FigureImpl errorBarXY(Comparable seriesName, Instant[] x, Instant[] xLow, Instant[] xHigh, T3[] y, T4[] yLow, T5[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, (Number[])y, (Number[])yLow, (Number[])yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, Instant[] x, Instant[] xLow, Instant[] xHigh, double[] y, double[] yLow, double[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, Instant[] x, Instant[] xLow, Instant[] xHigh, float[] y, float[] yLow, float[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, Instant[] x, Instant[] xLow, Instant[] xHigh, int[] y, int[] yLow, int[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, Instant[] x, Instant[] xLow, Instant[] xHigh, long[] y, long[] yLow, long[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, Instant[] x, Instant[] xLow, Instant[] xHigh, Instant[] y, Instant[] yLow, Instant[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, Instant[] x, Instant[] xLow, Instant[] xHigh, short[] y, short[] yLow, short[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public <T3 extends Number, T4 extends Number, T5 extends Number> FigureImpl errorBarXY(Comparable seriesName, Instant[] x, Instant[] xLow, Instant[] xHigh, List<T3> y, List<T4> yLow, List<T5> yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, (List)y, (List)yLow, (List)yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T3 extends Number, T4 extends Number, T5 extends Number> FigureImpl errorBarXY(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, T3[] y, T4[] yLow, T5[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, (Number[])y, (Number[])yLow, (Number[])yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, double[] y, double[] yLow, double[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, float[] y, float[] yLow, float[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, int[] y, int[] yLow, int[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, long[] y, long[] yLow, long[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, Date[] y, Date[] yLow, Date[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, short[] y, short[] yLow, short[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public <T3 extends Number, T4 extends Number, T5 extends Number> FigureImpl errorBarXY(Comparable seriesName, Date[] x, Date[] xLow, Date[] xHigh, List<T3> y, List<T4> yLow, List<T5> yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, (List)y, (List)yLow, (List)yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, short[] x, short[] xLow, short[] xHigh, Instant[] y, Instant[] yLow, Instant[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, short[] x, short[] xLow, short[] xHigh, Date[] y, Date[] yLow, Date[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, short[] x, short[] xLow, short[] xHigh, short[] y, short[] yLow, short[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number> FigureImpl errorBarXY(Comparable seriesName, List<T0> x, List<T1> xLow, List<T2> xHigh, Instant[] y, Instant[] yLow, Instant[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarXY(seriesName, (List)x, (List)xLow, (List)xHigh, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number> FigureImpl errorBarXY(Comparable seriesName, List<T0> x, List<T1> xLow, List<T2> xHigh, Date[] y, Date[] yLow, Date[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarXY(seriesName, (List)x, (List)xLow, (List)xHigh, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number, T3 extends Number, T4 extends Number, T5 extends Number> FigureImpl errorBarXY(Comparable seriesName, List<T0> x, List<T1> xLow, List<T2> xHigh, List<T3> y, List<T4> yLow, List<T5> yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarXY(seriesName, (List)x, (List)xLow, (List)xHigh, (List)y, (List)yLow, (List)yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, Table t, String x, String xLow, String xHigh, String y, String yLow, String yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, t, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXY(Comparable seriesName, SelectableDataSet sds, String x, String xLow, String xHigh, String y, String yLow, String yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarXY(seriesName, sds, x, xLow, xHigh, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXYBy(Comparable seriesName, Table t, String x, String xLow, String xHigh, String y, String yLow, String yHigh, String ... byColumns) {
        BaseFigureImpl fc = this.figure.copy();
        MultiXYErrorBarSeries series = this.axes(fc).errorBarXYBy(seriesName, t, x, xLow, xHigh, y, yLow, yHigh, byColumns);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarXYBy(Comparable seriesName, SelectableDataSet sds, String x, String xLow, String xHigh, String y, String yLow, String yHigh, String ... byColumns) {
        BaseFigureImpl fc = this.figure.copy();
        MultiXYErrorBarSeriesSwappable series = this.axes(fc).errorBarXYBy(seriesName, sds, x, xLow, xHigh, y, yLow, yHigh, byColumns);
        return this.make(series);
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number, T3 extends Number> FigureImpl errorBarY(Comparable seriesName, T0[] x, T1[] y, T2[] yLow, T3[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarY(seriesName, (Number[])x, (Number[])y, (Number[])yLow, (Number[])yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number> FigureImpl errorBarY(Comparable seriesName, T0[] x, Instant[] y, Instant[] yLow, Instant[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarY(seriesName, (Number[])x, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number> FigureImpl errorBarY(Comparable seriesName, T0[] x, Date[] y, Date[] yLow, Date[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarY(seriesName, (Number[])x, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, double[] x, double[] y, double[] yLow, double[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, double[] x, Instant[] y, Instant[] yLow, Instant[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, double[] x, Date[] y, Date[] yLow, Date[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, float[] x, float[] y, float[] yLow, float[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, float[] x, Instant[] y, Instant[] yLow, Instant[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, float[] x, Date[] y, Date[] yLow, Date[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, int[] x, int[] y, int[] yLow, int[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, int[] x, Instant[] y, Instant[] yLow, Instant[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, int[] x, Date[] y, Date[] yLow, Date[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, long[] x, long[] y, long[] yLow, long[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, long[] x, Instant[] y, Instant[] yLow, Instant[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, long[] x, Date[] y, Date[] yLow, Date[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public <T1 extends Number, T2 extends Number, T3 extends Number> FigureImpl errorBarY(Comparable seriesName, Instant[] x, T1[] y, T2[] yLow, T3[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarY(seriesName, x, (Number[])y, (Number[])yLow, (Number[])yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, Instant[] x, double[] y, double[] yLow, double[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, Instant[] x, float[] y, float[] yLow, float[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, Instant[] x, int[] y, int[] yLow, int[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, Instant[] x, long[] y, long[] yLow, long[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, Instant[] x, Instant[] y, Instant[] yLow, Instant[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, Instant[] x, short[] y, short[] yLow, short[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public <T1 extends Number, T2 extends Number, T3 extends Number> FigureImpl errorBarY(Comparable seriesName, Instant[] x, List<T1> y, List<T2> yLow, List<T3> yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarY(seriesName, x, (List)y, (List)yLow, (List)yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T1 extends Number, T2 extends Number, T3 extends Number> FigureImpl errorBarY(Comparable seriesName, Date[] x, T1[] y, T2[] yLow, T3[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarY(seriesName, x, (Number[])y, (Number[])yLow, (Number[])yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, Date[] x, double[] y, double[] yLow, double[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, Date[] x, float[] y, float[] yLow, float[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, Date[] x, int[] y, int[] yLow, int[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, Date[] x, long[] y, long[] yLow, long[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, Date[] x, Date[] y, Date[] yLow, Date[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, Date[] x, short[] y, short[] yLow, short[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public <T1 extends Number, T2 extends Number, T3 extends Number> FigureImpl errorBarY(Comparable seriesName, Date[] x, List<T1> y, List<T2> yLow, List<T3> yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarY(seriesName, x, (List)y, (List)yLow, (List)yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, short[] x, Instant[] y, Instant[] yLow, Instant[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, short[] x, Date[] y, Date[] yLow, Date[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, short[] x, short[] y, short[] yLow, short[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeriesArray series = this.axes(fc).errorBarY(seriesName, x, y, yLow, yHigh);
        return this.make(series);
    }

    @Override
    public <T0 extends Number> FigureImpl errorBarY(Comparable seriesName, List<T0> x, Instant[] y, Instant[] yLow, Instant[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarY(seriesName, (List)x, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number> FigureImpl errorBarY(Comparable seriesName, List<T0> x, Date[] y, Date[] yLow, Date[] yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarY(seriesName, (List)x, y, yLow, yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number, T1 extends Number, T2 extends Number, T3 extends Number> FigureImpl errorBarY(Comparable seriesName, List<T0> x, List<T1> y, List<T2> yLow, List<T3> yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        XYErrorBarDataSeries series = this.axes(fc).errorBarY(seriesName, (List)x, (List)y, (List)yLow, (List)yHigh);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, Table t, String x, String y, String yLow, String yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        DataSeriesInternal series = (DataSeriesInternal)((Object)this.axes(fc).errorBarY(seriesName, t, x, y, yLow, yHigh));
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarY(Comparable seriesName, SelectableDataSet sds, String x, String y, String yLow, String yHigh) {
        BaseFigureImpl fc = this.figure.copy();
        DataSeriesInternal series = (DataSeriesInternal)((Object)this.axes(fc).errorBarY(seriesName, sds, x, y, yLow, yHigh));
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarYBy(Comparable seriesName, Table t, String x, String y, String yLow, String yHigh, String ... byColumns) {
        BaseFigureImpl fc = this.figure.copy();
        MultiXYErrorBarSeries series = this.axes(fc).errorBarYBy(seriesName, t, x, y, yLow, yHigh, byColumns);
        return this.make(series);
    }

    @Override
    public FigureImpl errorBarYBy(Comparable seriesName, SelectableDataSet sds, String x, String y, String yLow, String yHigh, String ... byColumns) {
        BaseFigureImpl fc = this.figure.copy();
        MultiXYErrorBarSeriesSwappable series = this.axes(fc).errorBarYBy(seriesName, sds, x, y, yLow, yHigh, byColumns);
        return this.make(series);
    }

    @Override
    public FigureImpl figureRemoveSeries(String ... removeSeriesNames) {
        BaseFigureImpl fc = this.figure.copy();
        this.figure(fc).figureRemoveSeries(removeSeriesNames);
        return this.make(fc);
    }

    @Override
    public FigureImpl figureTitle(String title) {
        BaseFigureImpl fc = this.figure.copy();
        this.figure(fc).figureTitle(title);
        return this.make(fc);
    }

    @Override
    public FigureImpl figureTitleColor(String color) {
        BaseFigureImpl fc = this.figure.copy();
        this.figure(fc).figureTitleColor(color);
        return this.make(fc);
    }

    @Override
    public FigureImpl figureTitleColor(Paint color) {
        BaseFigureImpl fc = this.figure.copy();
        this.figure(fc).figureTitleColor(color);
        return this.make(fc);
    }

    @Override
    public FigureImpl figureTitleFont(Font font) {
        BaseFigureImpl fc = this.figure.copy();
        this.figure(fc).figureTitleFont(font);
        return this.make(fc);
    }

    @Override
    public FigureImpl figureTitleFont(String family, String style, int size) {
        BaseFigureImpl fc = this.figure.copy();
        this.figure(fc).figureTitleFont(family, style, size);
        return this.make(fc);
    }

    @Override
    public FigureImpl gridLinesVisible(boolean gridVisible) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = (ChartImpl)this.chart(fc).gridLinesVisible(gridVisible);
        return this.make(chart);
    }

    @Override
    public FigureImpl histPlot(Comparable seriesName, Table t) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeriesArray series = this.axes(fc).histPlot(seriesName, t);
        return this.make(series);
    }

    @Override
    public <T0 extends Number> FigureImpl histPlot(Comparable seriesName, T0[] x, int nbins) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeries series = this.axes(fc).histPlot(seriesName, (Number[])x, nbins);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl histPlot(Comparable seriesName, double[] x, int nbins) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeriesArray series = this.axes(fc).histPlot(seriesName, x, nbins);
        return this.make(series);
    }

    @Override
    public FigureImpl histPlot(Comparable seriesName, float[] x, int nbins) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeriesArray series = this.axes(fc).histPlot(seriesName, x, nbins);
        return this.make(series);
    }

    @Override
    public FigureImpl histPlot(Comparable seriesName, int[] x, int nbins) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeriesArray series = this.axes(fc).histPlot(seriesName, x, nbins);
        return this.make(series);
    }

    @Override
    public FigureImpl histPlot(Comparable seriesName, long[] x, int nbins) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeriesArray series = this.axes(fc).histPlot(seriesName, x, nbins);
        return this.make(series);
    }

    @Override
    public FigureImpl histPlot(Comparable seriesName, short[] x, int nbins) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeriesArray series = this.axes(fc).histPlot(seriesName, x, nbins);
        return this.make(series);
    }

    @Override
    public <T0 extends Number> FigureImpl histPlot(Comparable seriesName, List<T0> x, int nbins) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeries series = this.axes(fc).histPlot(seriesName, (List)x, nbins);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl histPlot(Comparable seriesName, Table t, String x, int nbins) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeriesArray series = this.axes(fc).histPlot(seriesName, t, x, nbins);
        return this.make(series);
    }

    @Override
    public FigureImpl histPlot(Comparable seriesName, SelectableDataSet sds, String x, int nbins) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeriesArray series = this.axes(fc).histPlot(seriesName, sds, x, nbins);
        return this.make(series);
    }

    @Override
    public <T0 extends Number> FigureImpl histPlot(Comparable seriesName, T0[] x, double xmin, double xmax, int nbins) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeries series = this.axes(fc).histPlot(seriesName, (Number[])x, xmin, xmax, nbins);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl histPlot(Comparable seriesName, double[] x, double xmin, double xmax, int nbins) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeriesArray series = this.axes(fc).histPlot(seriesName, x, xmin, xmax, nbins);
        return this.make(series);
    }

    @Override
    public FigureImpl histPlot(Comparable seriesName, float[] x, double xmin, double xmax, int nbins) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeriesArray series = this.axes(fc).histPlot(seriesName, x, xmin, xmax, nbins);
        return this.make(series);
    }

    @Override
    public FigureImpl histPlot(Comparable seriesName, int[] x, double xmin, double xmax, int nbins) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeriesArray series = this.axes(fc).histPlot(seriesName, x, xmin, xmax, nbins);
        return this.make(series);
    }

    @Override
    public FigureImpl histPlot(Comparable seriesName, long[] x, double xmin, double xmax, int nbins) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeriesArray series = this.axes(fc).histPlot(seriesName, x, xmin, xmax, nbins);
        return this.make(series);
    }

    @Override
    public FigureImpl histPlot(Comparable seriesName, short[] x, double xmin, double xmax, int nbins) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeriesArray series = this.axes(fc).histPlot(seriesName, x, xmin, xmax, nbins);
        return this.make(series);
    }

    @Override
    public <T0 extends Number> FigureImpl histPlot(Comparable seriesName, List<T0> x, double xmin, double xmax, int nbins) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeries series = this.axes(fc).histPlot(seriesName, (List)x, xmin, xmax, nbins);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl histPlot(Comparable seriesName, Table t, String x, double xmin, double xmax, int nbins) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeriesArray series = this.axes(fc).histPlot(seriesName, t, x, xmin, xmax, nbins);
        return this.make(series);
    }

    @Override
    public FigureImpl histPlot(Comparable seriesName, SelectableDataSet sds, String x, double xmin, double xmax, int nbins) {
        BaseFigureImpl fc = this.figure.copy();
        IntervalXYDataSeriesArray series = this.axes(fc).histPlot(seriesName, sds, x, xmin, xmax, nbins);
        return this.make(series);
    }

    @Override
    public FigureImpl invert() {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).invert();
        return this.make(null, axis);
    }

    @Override
    public FigureImpl invert(boolean invert) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).invert(invert);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl legendColor(String color) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.chart(fc).legendColor(color);
        return this.make(chart);
    }

    @Override
    public FigureImpl legendColor(Paint color) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.chart(fc).legendColor(color);
        return this.make(chart);
    }

    @Override
    public FigureImpl legendFont(Font font) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.chart(fc).legendFont(font);
        return this.make(chart);
    }

    @Override
    public FigureImpl legendFont(String family, String style, int size) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.chart(fc).legendFont(family, style, size);
        return this.make(chart);
    }

    @Override
    public FigureImpl legendVisible(boolean visible) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.chart(fc).legendVisible(visible);
        return this.make(chart);
    }

    @Override
    public FigureImpl log() {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).log();
        return this.make(null, axis);
    }

    @Override
    public FigureImpl log(boolean useLog) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = (AxisImpl)this.axis(fc).log(useLog);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl max(double max) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).max(max);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl max(SelectableDataSet sds, String max) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).max(sds, max);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl maxRowsInTitle(int maxTitleRows) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = (ChartImpl)this.chart(fc).maxRowsInTitle(maxTitleRows);
        return this.make(chart);
    }

    @Override
    public FigureImpl min(double min) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).min(min);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl min(SelectableDataSet sds, String min) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).min(sds, min);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl minorTicks(int nminor) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).minorTicks(nminor);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl minorTicksVisible(boolean visible) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).minorTicksVisible(visible);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl newAxes() {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.chart(fc).newAxes();
        return this.make(axes);
    }

    @Override
    public FigureImpl newAxes(String name) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.chart(fc).newAxes(name);
        return this.make(axes);
    }

    @Override
    public FigureImpl newAxes(int dim) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.chart(fc).newAxes(dim);
        return this.make(axes);
    }

    @Override
    public FigureImpl newAxes(String name, int dim) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.chart(fc).newAxes(name, dim);
        return this.make(axes);
    }

    @Override
    public FigureImpl newChart() {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.figure(fc).newChart();
        return this.make(chart);
    }

    @Override
    public FigureImpl newChart(int index) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.figure(fc).newChart(index);
        return this.make(chart);
    }

    @Override
    public FigureImpl newChart(int rowNum, int colNum) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.figure(fc).newChart(rowNum, colNum);
        return this.make(chart);
    }

    @Override
    public <T1 extends Number, T2 extends Number, T3 extends Number, T4 extends Number> FigureImpl ohlcPlot(Comparable seriesName, Instant[] time, T1[] open, T2[] high, T3[] low, T4[] close) {
        BaseFigureImpl fc = this.figure.copy();
        OHLCDataSeries series = this.axes(fc).ohlcPlot(seriesName, time, (Number[])open, (Number[])high, (Number[])low, (Number[])close);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl ohlcPlot(Comparable seriesName, Instant[] time, double[] open, double[] high, double[] low, double[] close) {
        BaseFigureImpl fc = this.figure.copy();
        OHLCDataSeriesArray series = this.axes(fc).ohlcPlot(seriesName, time, open, high, low, close);
        return this.make(series);
    }

    @Override
    public FigureImpl ohlcPlot(Comparable seriesName, Instant[] time, float[] open, float[] high, float[] low, float[] close) {
        BaseFigureImpl fc = this.figure.copy();
        OHLCDataSeriesArray series = this.axes(fc).ohlcPlot(seriesName, time, open, high, low, close);
        return this.make(series);
    }

    @Override
    public FigureImpl ohlcPlot(Comparable seriesName, Instant[] time, int[] open, int[] high, int[] low, int[] close) {
        BaseFigureImpl fc = this.figure.copy();
        OHLCDataSeriesArray series = this.axes(fc).ohlcPlot(seriesName, time, open, high, low, close);
        return this.make(series);
    }

    @Override
    public FigureImpl ohlcPlot(Comparable seriesName, Instant[] time, long[] open, long[] high, long[] low, long[] close) {
        BaseFigureImpl fc = this.figure.copy();
        OHLCDataSeriesArray series = this.axes(fc).ohlcPlot(seriesName, time, open, high, low, close);
        return this.make(series);
    }

    @Override
    public FigureImpl ohlcPlot(Comparable seriesName, Instant[] time, short[] open, short[] high, short[] low, short[] close) {
        BaseFigureImpl fc = this.figure.copy();
        OHLCDataSeriesArray series = this.axes(fc).ohlcPlot(seriesName, time, open, high, low, close);
        return this.make(series);
    }

    @Override
    public <T1 extends Number, T2 extends Number, T3 extends Number, T4 extends Number> FigureImpl ohlcPlot(Comparable seriesName, Instant[] time, List<T1> open, List<T2> high, List<T3> low, List<T4> close) {
        BaseFigureImpl fc = this.figure.copy();
        OHLCDataSeries series = this.axes(fc).ohlcPlot(seriesName, time, (List)open, (List)high, (List)low, (List)close);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T1 extends Number, T2 extends Number, T3 extends Number, T4 extends Number> FigureImpl ohlcPlot(Comparable seriesName, Date[] time, T1[] open, T2[] high, T3[] low, T4[] close) {
        BaseFigureImpl fc = this.figure.copy();
        OHLCDataSeries series = this.axes(fc).ohlcPlot(seriesName, time, (Number[])open, (Number[])high, (Number[])low, (Number[])close);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl ohlcPlot(Comparable seriesName, Date[] time, double[] open, double[] high, double[] low, double[] close) {
        BaseFigureImpl fc = this.figure.copy();
        OHLCDataSeriesArray series = this.axes(fc).ohlcPlot(seriesName, time, open, high, low, close);
        return this.make(series);
    }

    @Override
    public FigureImpl ohlcPlot(Comparable seriesName, Date[] time, float[] open, float[] high, float[] low, float[] close) {
        BaseFigureImpl fc = this.figure.copy();
        OHLCDataSeriesArray series = this.axes(fc).ohlcPlot(seriesName, time, open, high, low, close);
        return this.make(series);
    }

    @Override
    public FigureImpl ohlcPlot(Comparable seriesName, Date[] time, int[] open, int[] high, int[] low, int[] close) {
        BaseFigureImpl fc = this.figure.copy();
        OHLCDataSeriesArray series = this.axes(fc).ohlcPlot(seriesName, time, open, high, low, close);
        return this.make(series);
    }

    @Override
    public FigureImpl ohlcPlot(Comparable seriesName, Date[] time, long[] open, long[] high, long[] low, long[] close) {
        BaseFigureImpl fc = this.figure.copy();
        OHLCDataSeriesArray series = this.axes(fc).ohlcPlot(seriesName, time, open, high, low, close);
        return this.make(series);
    }

    @Override
    public FigureImpl ohlcPlot(Comparable seriesName, Date[] time, short[] open, short[] high, short[] low, short[] close) {
        BaseFigureImpl fc = this.figure.copy();
        OHLCDataSeriesArray series = this.axes(fc).ohlcPlot(seriesName, time, open, high, low, close);
        return this.make(series);
    }

    @Override
    public <T1 extends Number, T2 extends Number, T3 extends Number, T4 extends Number> FigureImpl ohlcPlot(Comparable seriesName, Date[] time, List<T1> open, List<T2> high, List<T3> low, List<T4> close) {
        BaseFigureImpl fc = this.figure.copy();
        OHLCDataSeries series = this.axes(fc).ohlcPlot(seriesName, time, (List)open, (List)high, (List)low, (List)close);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl ohlcPlot(Comparable seriesName, IndexableNumericData time, IndexableNumericData open, IndexableNumericData high, IndexableNumericData low, IndexableNumericData close) {
        BaseFigureImpl fc = this.figure.copy();
        OHLCDataSeriesArray series = this.axes(fc).ohlcPlot(seriesName, time, open, high, low, close);
        return this.make(series);
    }

    @Override
    public FigureImpl ohlcPlot(Comparable seriesName, Table t, String time, String open, String high, String low, String close) {
        BaseFigureImpl fc = this.figure.copy();
        OHLCDataSeriesTableArray series = this.axes(fc).ohlcPlot(seriesName, t, time, open, high, low, close);
        return this.make(series);
    }

    @Override
    public FigureImpl ohlcPlot(Comparable seriesName, SelectableDataSet sds, String time, String open, String high, String low, String close) {
        BaseFigureImpl fc = this.figure.copy();
        OHLCDataSeriesArray series = this.axes(fc).ohlcPlot(seriesName, sds, time, open, high, low, close);
        return this.make(series);
    }

    @Override
    public FigureImpl ohlcPlotBy(Comparable seriesName, Table t, String time, String open, String high, String low, String close, String ... byColumns) {
        BaseFigureImpl fc = this.figure.copy();
        MultiOHLCSeries series = this.axes(fc).ohlcPlotBy(seriesName, t, time, open, high, low, close, byColumns);
        return this.make(series);
    }

    @Override
    public FigureImpl ohlcPlotBy(Comparable seriesName, SelectableDataSet sds, String time, String open, String high, String low, String close, String ... byColumns) {
        BaseFigureImpl fc = this.figure.copy();
        MultiOHLCSeriesSwappable series = this.axes(fc).ohlcPlotBy(seriesName, sds, time, open, high, low, close, byColumns);
        return this.make(series);
    }

    @Override
    public <T0 extends Comparable, T1 extends Number> FigureImpl piePlot(Comparable seriesName, T0[] categories, T1[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).piePlot(seriesName, (Comparable[])categories, (Number[])y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl piePlot(Comparable seriesName, T0[] categories, double[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).piePlot(seriesName, (Comparable[])categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl piePlot(Comparable seriesName, T0[] categories, float[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).piePlot(seriesName, (Comparable[])categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl piePlot(Comparable seriesName, T0[] categories, int[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).piePlot(seriesName, (Comparable[])categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl piePlot(Comparable seriesName, T0[] categories, long[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).piePlot(seriesName, (Comparable[])categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl piePlot(Comparable seriesName, T0[] categories, short[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).piePlot(seriesName, (Comparable[])categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable, T1 extends Number> FigureImpl piePlot(Comparable seriesName, T0[] categories, List<T1> y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).piePlot(seriesName, (Comparable[])categories, (List)y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T1 extends Comparable> FigureImpl piePlot(Comparable seriesName, IndexableData<T1> categories, IndexableNumericData y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).piePlot(seriesName, (IndexableData)categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable, T1 extends Number> FigureImpl piePlot(Comparable seriesName, List<T0> categories, T1[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).piePlot(seriesName, (List)categories, (Number[])y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl piePlot(Comparable seriesName, List<T0> categories, double[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).piePlot(seriesName, (List)categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl piePlot(Comparable seriesName, List<T0> categories, float[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).piePlot(seriesName, (List)categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl piePlot(Comparable seriesName, List<T0> categories, int[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).piePlot(seriesName, (List)categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl piePlot(Comparable seriesName, List<T0> categories, long[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).piePlot(seriesName, (List)categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable> FigureImpl piePlot(Comparable seriesName, List<T0> categories, short[] y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).piePlot(seriesName, (List)categories, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Comparable, T1 extends Number> FigureImpl piePlot(Comparable seriesName, List<T0> categories, List<T1> y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeries series = this.axes(fc).piePlot(seriesName, (List)categories, (List)y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl piePlot(Comparable seriesName, Table t, String categories, String y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeriesInternal series = this.axes(fc).piePlot(seriesName, t, categories, y);
        return this.make(series);
    }

    @Override
    public FigureImpl piePlot(Comparable seriesName, SelectableDataSet sds, String categories, String y) {
        BaseFigureImpl fc = this.figure.copy();
        CategoryDataSeriesInternal series = this.axes(fc).piePlot(seriesName, sds, categories, y);
        return this.make(series);
    }

    @Override
    public <T extends Number> FigureImpl plot(Comparable seriesName, Closure<T> function) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesFunction series = this.axes(fc).plot(seriesName, (Closure)function);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl plot(Comparable seriesName, DoubleUnaryOperator function) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesFunctionImpl series = this.axes(fc).plot(seriesName, function);
        return this.make(series);
    }

    @Override
    public <T0 extends Number, T1 extends Number> FigureImpl plot(Comparable seriesName, T0[] x, T1[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, (Number[])x, (Number[])y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number> FigureImpl plot(Comparable seriesName, T0[] x, double[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, (Number[])x, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number> FigureImpl plot(Comparable seriesName, T0[] x, float[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, (Number[])x, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number> FigureImpl plot(Comparable seriesName, T0[] x, int[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, (Number[])x, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number> FigureImpl plot(Comparable seriesName, T0[] x, long[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, (Number[])x, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number> FigureImpl plot(Comparable seriesName, T0[] x, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, (Number[])x, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number> FigureImpl plot(Comparable seriesName, T0[] x, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, (Number[])x, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number> FigureImpl plot(Comparable seriesName, T0[] x, short[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, (Number[])x, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number, T1 extends Number> FigureImpl plot(Comparable seriesName, T0[] x, List<T1> y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, (Number[])x, (List)y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T1 extends Number> FigureImpl plot(Comparable seriesName, double[] x, T1[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, x, (Number[])y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl plot(Comparable seriesName, double[] x, double[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, double[] x, float[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, double[] x, int[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, double[] x, long[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, double[] x, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, double[] x, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, double[] x, short[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public <T1 extends Number> FigureImpl plot(Comparable seriesName, double[] x, List<T1> y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, x, (List)y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T1 extends Number> FigureImpl plot(Comparable seriesName, float[] x, T1[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, x, (Number[])y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl plot(Comparable seriesName, float[] x, double[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, float[] x, float[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, float[] x, int[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, float[] x, long[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, float[] x, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, float[] x, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, float[] x, short[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public <T1 extends Number> FigureImpl plot(Comparable seriesName, float[] x, List<T1> y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, x, (List)y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T1 extends Number> FigureImpl plot(Comparable seriesName, int[] x, T1[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, x, (Number[])y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl plot(Comparable seriesName, int[] x, double[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, int[] x, float[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, int[] x, int[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, int[] x, long[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, int[] x, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, int[] x, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, int[] x, short[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public <T1 extends Number> FigureImpl plot(Comparable seriesName, int[] x, List<T1> y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, x, (List)y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T1 extends Number> FigureImpl plot(Comparable seriesName, long[] x, T1[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, x, (Number[])y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl plot(Comparable seriesName, long[] x, double[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, long[] x, float[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, long[] x, int[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, long[] x, long[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, long[] x, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, long[] x, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, long[] x, short[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public <T1 extends Number> FigureImpl plot(Comparable seriesName, long[] x, List<T1> y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, x, (List)y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T1 extends Number> FigureImpl plot(Comparable seriesName, Instant[] x, T1[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, x, (Number[])y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl plot(Comparable seriesName, Instant[] x, double[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, Instant[] x, float[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, Instant[] x, int[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, Instant[] x, long[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, Instant[] x, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, Instant[] x, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, Instant[] x, short[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public <T1 extends Number> FigureImpl plot(Comparable seriesName, Instant[] x, List<T1> y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, x, (List)y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T1 extends Number> FigureImpl plot(Comparable seriesName, Date[] x, T1[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, x, (Number[])y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl plot(Comparable seriesName, Date[] x, double[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, Date[] x, float[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, Date[] x, int[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, Date[] x, long[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, Date[] x, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, Date[] x, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, Date[] x, short[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public <T1 extends Number> FigureImpl plot(Comparable seriesName, Date[] x, List<T1> y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, x, (List)y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T1 extends Number> FigureImpl plot(Comparable seriesName, short[] x, T1[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, x, (Number[])y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl plot(Comparable seriesName, short[] x, double[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, short[] x, float[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, short[] x, int[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, short[] x, long[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, short[] x, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, short[] x, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, short[] x, short[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y);
        return this.make(series);
    }

    @Override
    public <T1 extends Number> FigureImpl plot(Comparable seriesName, short[] x, List<T1> y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, x, (List)y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number, T1 extends Number> FigureImpl plot(Comparable seriesName, List<T0> x, T1[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, (List)x, (Number[])y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number> FigureImpl plot(Comparable seriesName, List<T0> x, double[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, (List)x, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number> FigureImpl plot(Comparable seriesName, List<T0> x, float[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, (List)x, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number> FigureImpl plot(Comparable seriesName, List<T0> x, int[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, (List)x, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number> FigureImpl plot(Comparable seriesName, List<T0> x, long[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, (List)x, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number> FigureImpl plot(Comparable seriesName, List<T0> x, Instant[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, (List)x, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number> FigureImpl plot(Comparable seriesName, List<T0> x, Date[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, (List)x, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number> FigureImpl plot(Comparable seriesName, List<T0> x, short[] y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, (List)x, y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public <T0 extends Number, T1 extends Number> FigureImpl plot(Comparable seriesName, List<T0> x, List<T1> y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeries series = this.axes(fc).plot(seriesName, (List)x, (List)y);
        return this.make((SeriesInternal)((Object)series));
    }

    @Override
    public FigureImpl plot(Comparable seriesName, Table t, String x, String y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, t, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, SelectableDataSet sds, String x, String y) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, sds, x, y);
        return this.make(series);
    }

    @Override
    public FigureImpl plot(Comparable seriesName, IndexableNumericData x, IndexableNumericData y, boolean hasXTimeAxis, boolean hasYTimeAxis) {
        BaseFigureImpl fc = this.figure.copy();
        XYDataSeriesArray series = this.axes(fc).plot(seriesName, x, y, hasXTimeAxis, hasYTimeAxis);
        return this.make(series);
    }

    @Override
    public FigureImpl plotBy(Comparable seriesName, Table t, String x, String y, String ... byColumns) {
        BaseFigureImpl fc = this.figure.copy();
        MultiXYSeries series = this.axes(fc).plotBy(seriesName, t, x, y, byColumns);
        return this.make(series);
    }

    @Override
    public FigureImpl plotBy(Comparable seriesName, SelectableDataSet sds, String x, String y, String ... byColumns) {
        BaseFigureImpl fc = this.figure.copy();
        MultiXYSeriesSwappable series = this.axes(fc).plotBy(seriesName, sds, x, y, byColumns);
        return this.make(series);
    }

    @Override
    public FigureImpl plotOrientation(String orientation) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.chart(fc).plotOrientation(orientation);
        return this.make(chart);
    }

    @Override
    public FigureImpl plotStyle(PlotStyle plotStyle) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).plotStyle(plotStyle);
        return this.make(axes);
    }

    @Override
    public FigureImpl plotStyle(String plotStyle) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).plotStyle(plotStyle);
        return this.make(axes);
    }

    @Override
    public FigureImpl range(double min, double max) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).range(min, max);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl removeChart(int removeChartIndex) {
        BaseFigureImpl fc = this.figure.copy();
        this.figure(fc).removeChart(removeChartIndex);
        return this.make(fc);
    }

    @Override
    public FigureImpl removeChart(int removeChartRowNum, int removeChartColNum) {
        BaseFigureImpl fc = this.figure.copy();
        this.figure(fc).removeChart(removeChartRowNum, removeChartColNum);
        return this.make(fc);
    }

    @Override
    public FigureImpl rowSpan(int rowSpan) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.chart(fc).rowSpan(rowSpan);
        return this.make(chart);
    }

    @Override
    public FigureImpl series(int id) {
        BaseFigureImpl fc = this.figure.copy();
        SeriesInternal series = this.axes(fc).series(id);
        return this.make(series);
    }

    @Override
    public FigureImpl series(Comparable name) {
        BaseFigureImpl fc = this.figure.copy();
        SeriesInternal series = this.axes(fc).series(name);
        return this.make(series);
    }

    @Override
    public FigureImpl span(int rowSpan, int colSpan) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = this.chart(fc).span(rowSpan, colSpan);
        return this.make(chart);
    }

    @Override
    public FigureImpl tickLabelAngle(double angle) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).tickLabelAngle(angle);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl ticks(double[] tickLocations) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).ticks(tickLocations);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl ticks(double gapBetweenTicks) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).ticks(gapBetweenTicks);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl ticksFont(Font font) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).ticksFont(font);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl ticksFont(String family, String style, int size) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).ticksFont(family, style, size);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl ticksVisible(boolean visible) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).ticksVisible(visible);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl transform(AxisTransform transform) {
        BaseFigureImpl fc = this.figure.copy();
        AxisImpl axis = this.axis(fc).transform(transform);
        return this.make(null, axis);
    }

    @Override
    public FigureImpl treemapPlot(Comparable seriesName, Table t, String ids, String parents, String values, String labels, String hoverTexts, String colors) {
        BaseFigureImpl fc = this.figure.copy();
        DataSeriesInternal series = (DataSeriesInternal)((Object)this.axes(fc).treemapPlot(seriesName, t, ids, parents, values, labels, hoverTexts, colors));
        return this.make(series);
    }

    @Override
    public FigureImpl twin() {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).twin();
        return this.make(axes);
    }

    @Override
    public FigureImpl twin(String name) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).twin(name);
        return this.make(axes);
    }

    @Override
    public FigureImpl twin(int dim) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).twin(dim);
        return this.make(axes);
    }

    @Override
    public FigureImpl twin(String name, int dim) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).twin(name, dim);
        return this.make(axes);
    }

    @Override
    public FigureImpl twinX() {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).twinX();
        return this.make(axes);
    }

    @Override
    public FigureImpl twinX(String name) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).twinX(name);
        return this.make(axes);
    }

    @Override
    public FigureImpl twinY() {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).twinY();
        return this.make(axes);
    }

    @Override
    public FigureImpl twinY(String name) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).twinY(name);
        return this.make(axes);
    }

    @Override
    public FigureImpl updateInterval(long updateIntervalMillis) {
        BaseFigureImpl fc = this.figure.copy();
        this.figure(fc).updateInterval(updateIntervalMillis);
        return this.make(fc);
    }

    @Override
    public FigureImpl xAxis() {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc);
        AxisImpl axis = axes.xAxis();
        return this.make(axes, axis);
    }

    @Override
    public FigureImpl xBusinessTime() {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xBusinessTime();
        return this.make(axes);
    }

    @Override
    public FigureImpl xBusinessTime(boolean useBusinessTime) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xBusinessTime(useBusinessTime);
        return this.make(axes);
    }

    @Override
    public FigureImpl xBusinessTime(BusinessCalendar calendar) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xBusinessTime(calendar);
        return this.make(axes);
    }

    @Override
    public FigureImpl xBusinessTime(SelectableDataSet sds, String calendar) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xBusinessTime(sds, calendar);
        return this.make(axes);
    }

    @Override
    public FigureImpl xColor(String color) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xColor(color);
        return this.make(axes);
    }

    @Override
    public FigureImpl xColor(Paint color) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xColor(color);
        return this.make(axes);
    }

    @Override
    public FigureImpl xFormat(AxisFormat axisFormat) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xFormat(axisFormat);
        return this.make(axes);
    }

    @Override
    public FigureImpl xFormatPattern(String axisFormatPattern) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xFormatPattern(axisFormatPattern);
        return this.make(axes);
    }

    @Override
    public FigureImpl xGridLinesVisible(boolean xGridVisible) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = (ChartImpl)this.chart(fc).xGridLinesVisible(xGridVisible);
        return this.make(chart);
    }

    @Override
    public FigureImpl xInvert() {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xInvert();
        return this.make(axes);
    }

    @Override
    public FigureImpl xInvert(boolean invert) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xInvert(invert);
        return this.make(axes);
    }

    @Override
    public FigureImpl xLabel(String label) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xLabel(label);
        return this.make(axes);
    }

    @Override
    public FigureImpl xLabelFont(Font font) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xLabelFont(font);
        return this.make(axes);
    }

    @Override
    public FigureImpl xLabelFont(String family, String style, int size) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xLabelFont(family, style, size);
        return this.make(axes);
    }

    @Override
    public FigureImpl xLog() {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xLog();
        return this.make(axes);
    }

    @Override
    public FigureImpl xLog(boolean useLog) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xLog(useLog);
        return this.make(axes);
    }

    @Override
    public FigureImpl xMax(double max) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xMax(max);
        return this.make(axes);
    }

    @Override
    public FigureImpl xMax(SelectableDataSet sds, String max) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xMax(sds, max);
        return this.make(axes);
    }

    @Override
    public FigureImpl xMin(double min) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xMin(min);
        return this.make(axes);
    }

    @Override
    public FigureImpl xMin(SelectableDataSet sds, String min) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xMin(sds, min);
        return this.make(axes);
    }

    @Override
    public FigureImpl xMinorTicks(int nminor) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xMinorTicks(nminor);
        return this.make(axes);
    }

    @Override
    public FigureImpl xMinorTicksVisible(boolean visible) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xMinorTicksVisible(visible);
        return this.make(axes);
    }

    @Override
    public FigureImpl xRange(double min, double max) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xRange(min, max);
        return this.make(axes);
    }

    @Override
    public FigureImpl xTickLabelAngle(double angle) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xTickLabelAngle(angle);
        return this.make(axes);
    }

    @Override
    public FigureImpl xTicks(double[] tickLocations) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xTicks(tickLocations);
        return this.make(axes);
    }

    @Override
    public FigureImpl xTicks(double gapBetweenTicks) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xTicks(gapBetweenTicks);
        return this.make(axes);
    }

    @Override
    public FigureImpl xTicksFont(Font font) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xTicksFont(font);
        return this.make(axes);
    }

    @Override
    public FigureImpl xTicksFont(String family, String style, int size) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xTicksFont(family, style, size);
        return this.make(axes);
    }

    @Override
    public FigureImpl xTicksVisible(boolean visible) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xTicksVisible(visible);
        return this.make(axes);
    }

    @Override
    public FigureImpl xTransform(AxisTransform transform) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).xTransform(transform);
        return this.make(axes);
    }

    @Override
    public FigureImpl yAxis() {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc);
        AxisImpl axis = axes.yAxis();
        return this.make(axes, axis);
    }

    @Override
    public FigureImpl yBusinessTime() {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yBusinessTime();
        return this.make(axes);
    }

    @Override
    public FigureImpl yBusinessTime(boolean useBusinessTime) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yBusinessTime(useBusinessTime);
        return this.make(axes);
    }

    @Override
    public FigureImpl yBusinessTime(BusinessCalendar calendar) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yBusinessTime(calendar);
        return this.make(axes);
    }

    @Override
    public FigureImpl yBusinessTime(SelectableDataSet sds, String calendar) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yBusinessTime(sds, calendar);
        return this.make(axes);
    }

    @Override
    public FigureImpl yColor(String color) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yColor(color);
        return this.make(axes);
    }

    @Override
    public FigureImpl yColor(Paint color) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yColor(color);
        return this.make(axes);
    }

    @Override
    public FigureImpl yFormat(AxisFormat axisFormat) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yFormat(axisFormat);
        return this.make(axes);
    }

    @Override
    public FigureImpl yFormatPattern(String axisFormatPattern) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yFormatPattern(axisFormatPattern);
        return this.make(axes);
    }

    @Override
    public FigureImpl yGridLinesVisible(boolean yGridVisible) {
        BaseFigureImpl fc = this.figure.copy();
        ChartImpl chart = (ChartImpl)this.chart(fc).yGridLinesVisible(yGridVisible);
        return this.make(chart);
    }

    @Override
    public FigureImpl yInvert() {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yInvert();
        return this.make(axes);
    }

    @Override
    public FigureImpl yInvert(boolean invert) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yInvert(invert);
        return this.make(axes);
    }

    @Override
    public FigureImpl yLabel(String label) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yLabel(label);
        return this.make(axes);
    }

    @Override
    public FigureImpl yLabelFont(Font font) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yLabelFont(font);
        return this.make(axes);
    }

    @Override
    public FigureImpl yLabelFont(String family, String style, int size) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yLabelFont(family, style, size);
        return this.make(axes);
    }

    @Override
    public FigureImpl yLog() {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yLog();
        return this.make(axes);
    }

    @Override
    public FigureImpl yLog(boolean useLog) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yLog(useLog);
        return this.make(axes);
    }

    @Override
    public FigureImpl yMax(double max) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yMax(max);
        return this.make(axes);
    }

    @Override
    public FigureImpl yMax(SelectableDataSet sds, String max) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yMax(sds, max);
        return this.make(axes);
    }

    @Override
    public FigureImpl yMin(double min) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yMin(min);
        return this.make(axes);
    }

    @Override
    public FigureImpl yMin(SelectableDataSet sds, String min) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yMin(sds, min);
        return this.make(axes);
    }

    @Override
    public FigureImpl yMinorTicks(int nminor) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yMinorTicks(nminor);
        return this.make(axes);
    }

    @Override
    public FigureImpl yMinorTicksVisible(boolean visible) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yMinorTicksVisible(visible);
        return this.make(axes);
    }

    @Override
    public FigureImpl yRange(double min, double max) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yRange(min, max);
        return this.make(axes);
    }

    @Override
    public FigureImpl yTickLabelAngle(double angle) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yTickLabelAngle(angle);
        return this.make(axes);
    }

    @Override
    public FigureImpl yTicks(double[] tickLocations) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yTicks(tickLocations);
        return this.make(axes);
    }

    @Override
    public FigureImpl yTicks(double gapBetweenTicks) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yTicks(gapBetweenTicks);
        return this.make(axes);
    }

    @Override
    public FigureImpl yTicksFont(Font font) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yTicksFont(font);
        return this.make(axes);
    }

    @Override
    public FigureImpl yTicksFont(String family, String style, int size) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yTicksFont(family, style, size);
        return this.make(axes);
    }

    @Override
    public FigureImpl yTicksVisible(boolean visible) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yTicksVisible(visible);
        return this.make(axes);
    }

    @Override
    public FigureImpl yTransform(AxisTransform transform) {
        BaseFigureImpl fc = this.figure.copy();
        AxesImpl axes = this.axes(fc).yTransform(transform);
        return this.make(axes);
    }

    @Override
    public FigureImpl errorBarColor(int errorBarColor) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).errorBarColor(errorBarColor);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).errorBarColor(errorBarColor, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl errorBarColor( int errorBarColor )'", this.figure);
    }

    @Override
    public FigureImpl errorBarColor(Paint errorBarColor) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).errorBarColor(errorBarColor);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).errorBarColor(errorBarColor, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl errorBarColor( io.deephaven.gui.color.Paint errorBarColor )'", this.figure);
    }

    @Override
    public FigureImpl errorBarColor(String errorBarColor) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).errorBarColor(errorBarColor);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).errorBarColor(errorBarColor, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl errorBarColor( java.lang.String errorBarColor )'", this.figure);
    }

    @Override
    public FigureImpl gradientVisible(boolean gradientVisible) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).gradientVisible(gradientVisible);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).gradientVisible(gradientVisible, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl gradientVisible( boolean gradientVisible )'", this.figure);
    }

    @Override
    public FigureImpl lineColor(int color) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).lineColor(color);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).lineColor(color, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl lineColor( int color )'", this.figure);
    }

    @Override
    public FigureImpl lineColor(Paint color) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).lineColor(color);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).lineColor(color, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl lineColor( io.deephaven.gui.color.Paint color )'", this.figure);
    }

    @Override
    public FigureImpl lineColor(String color) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).lineColor(color);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).lineColor(color, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl lineColor( java.lang.String color )'", this.figure);
    }

    @Override
    public FigureImpl lineStyle(LineStyle lineStyle) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).lineStyle(lineStyle);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).lineStyle(lineStyle, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl lineStyle( io.deephaven.plot.LineStyle lineStyle )'", this.figure);
    }

    @Override
    public FigureImpl linesVisible(Boolean visible) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).linesVisible(visible);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).linesVisible(visible, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl linesVisible( java.lang.Boolean visible )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(int pointColor) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).pointColor(pointColor);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColor, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( int pointColor )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(Paint pointColor) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).pointColor(pointColor);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColor, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( io.deephaven.gui.color.Paint pointColor )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(String pointColor) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).pointColor(pointColor);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColor, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( java.lang.String pointColor )'", this.figure);
    }

    @Override
    public FigureImpl pointLabel(Object pointLabel) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).pointLabel(pointLabel);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(pointLabel, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointLabel( java.lang.Object pointLabel )'", this.figure);
    }

    @Override
    public FigureImpl pointLabelFormat(String pointLabelFormat) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).pointLabelFormat(pointLabelFormat);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabelFormat(pointLabelFormat, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointLabelFormat( java.lang.String pointLabelFormat )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(Shape pointShape) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).pointShape(pointShape);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(pointShape, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( io.deephaven.gui.shape.Shape pointShape )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(String pointShape) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).pointShape(pointShape);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(pointShape, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( java.lang.String pointShape )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(double pointSize) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).pointSize(pointSize);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSize, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( double pointSize )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(int pointSize) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).pointSize(pointSize);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSize, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( int pointSize )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(Number pointSize) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).pointSize(pointSize);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSize, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( java.lang.Number pointSize )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(long pointSize) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).pointSize(pointSize);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSize, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( long pointSize )'", this.figure);
    }

    @Override
    public FigureImpl pointsVisible(Boolean visible) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).pointsVisible(visible);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointsVisible(visible, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointsVisible( java.lang.Boolean visible )'", this.figure);
    }

    @Override
    public FigureImpl seriesColor(int color) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).seriesColor(color);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).seriesColor(color, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl seriesColor( int color )'", this.figure);
    }

    @Override
    public FigureImpl seriesColor(Paint color) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).seriesColor(color);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).seriesColor(color, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl seriesColor( io.deephaven.gui.color.Paint color )'", this.figure);
    }

    @Override
    public FigureImpl seriesColor(String color) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).seriesColor(color);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).seriesColor(color, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl seriesColor( java.lang.String color )'", this.figure);
    }

    @Override
    public FigureImpl toolTipPattern(String toolTipPattern) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).toolTipPattern(toolTipPattern);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).toolTipPattern(toolTipPattern, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl toolTipPattern( java.lang.String toolTipPattern )'", this.figure);
    }

    @Override
    public FigureImpl xToolTipPattern(String xToolTipPattern) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).xToolTipPattern(xToolTipPattern);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).xToolTipPattern(xToolTipPattern, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl xToolTipPattern( java.lang.String xToolTipPattern )'", this.figure);
    }

    @Override
    public FigureImpl yToolTipPattern(String yToolTipPattern) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof DataSeries) {
            DataSeries result = ((DataSeries)series).yToolTipPattern(yToolTipPattern);
            return this.make((DataSeriesInternal)result);
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).yToolTipPattern(yToolTipPattern, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl yToolTipPattern( java.lang.String yToolTipPattern )'", this.figure);
    }

    @Override
    public FigureImpl group(int group) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).group(group);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).group(group, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl group( int group )'", this.figure);
    }

    @Override
    public FigureImpl piePercentLabelFormat(String pieLabelFormat) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).piePercentLabelFormat(pieLabelFormat);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).piePercentLabelFormat(pieLabelFormat, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl piePercentLabelFormat( java.lang.String pieLabelFormat )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(Table t, String category, String pointColor) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointColor(t, category, pointColor);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(t, category, pointColor, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( io.deephaven.engine.table.Table t, java.lang.String category, java.lang.String pointColor )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(SelectableDataSet sds, String category, String pointColor) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointColor(sds, category, pointColor);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(sds, category, pointColor, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( io.deephaven.plot.filters.SelectableDataSet sds, java.lang.String category, java.lang.String pointColor )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(Comparable category, int pointColor) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointColor(category, pointColor);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(category, pointColor, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( java.lang.Comparable category, int pointColor )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(Comparable category, Paint pointColor) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointColor(category, pointColor);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(category, pointColor, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( java.lang.Comparable category, io.deephaven.gui.color.Paint pointColor )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(Comparable category, String pointColor) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointColor(category, pointColor);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(category, pointColor, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( java.lang.Comparable category, java.lang.String pointColor )'", this.figure);
    }

    @Override
    public FigureImpl pointLabel(Table t, String category, String pointLabel) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointLabel(t, category, pointLabel);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(t, category, pointLabel, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointLabel( io.deephaven.engine.table.Table t, java.lang.String category, java.lang.String pointLabel )'", this.figure);
    }

    @Override
    public FigureImpl pointLabel(SelectableDataSet sds, String category, String pointLabel) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointLabel(sds, category, pointLabel);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(sds, category, pointLabel, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointLabel( io.deephaven.plot.filters.SelectableDataSet sds, java.lang.String category, java.lang.String pointLabel )'", this.figure);
    }

    @Override
    public FigureImpl pointLabel(Comparable category, Object pointLabel) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointLabel(category, pointLabel);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(category, pointLabel, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointLabel( java.lang.Comparable category, java.lang.Object pointLabel )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(Closure<String> pointShapes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointShape(pointShapes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(pointShapes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( groovy.lang.Closure<java.lang.String> pointShapes )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(Table t, String category, String pointShape) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointShape(t, category, pointShape);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(t, category, pointShape, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( io.deephaven.engine.table.Table t, java.lang.String category, java.lang.String pointShape )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(SelectableDataSet sds, String category, String pointShape) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointShape(sds, category, pointShape);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(sds, category, pointShape, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( io.deephaven.plot.filters.SelectableDataSet sds, java.lang.String category, java.lang.String pointShape )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(Comparable category, Shape pointShape) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointShape(category, pointShape);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(category, pointShape, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( java.lang.Comparable category, io.deephaven.gui.shape.Shape pointShape )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(Comparable category, String pointShape) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointShape(category, pointShape);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(category, pointShape, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( java.lang.Comparable category, java.lang.String pointShape )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(Function<Comparable, String> pointShapes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointShape(pointShapes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(pointShapes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( java.util.function.Function<java.lang.Comparable, java.lang.String> pointShapes )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(Table t, String category, String pointSize) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointSize(t, category, pointSize);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(t, category, pointSize, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( io.deephaven.engine.table.Table t, java.lang.String category, java.lang.String pointSize )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(SelectableDataSet sds, String category, String pointSize) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointSize(sds, category, pointSize);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(sds, category, pointSize, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( io.deephaven.plot.filters.SelectableDataSet sds, java.lang.String category, java.lang.String pointSize )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(Comparable category, double pointSize) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointSize(category, pointSize);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(category, pointSize, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( java.lang.Comparable category, double pointSize )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(Comparable category, int pointSize) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointSize(category, pointSize);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(category, pointSize, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( java.lang.Comparable category, int pointSize )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(Comparable category, Number pointSize) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointSize(category, pointSize);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(category, pointSize, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( java.lang.Comparable category, java.lang.Number pointSize )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(Comparable category, long pointSize) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointSize(category, pointSize);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(category, pointSize, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( java.lang.Comparable category, long pointSize )'", this.figure);
    }

    @Override
    public FigureImpl errorBarColor(int errorBarColor, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).errorBarColor(errorBarColor, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl errorBarColor( int errorBarColor, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl errorBarColor(Paint errorBarColor, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).errorBarColor(errorBarColor, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl errorBarColor( io.deephaven.gui.color.Paint errorBarColor, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl errorBarColor(String errorBarColor, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).errorBarColor(errorBarColor, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl errorBarColor( java.lang.String errorBarColor, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl gradientVisible(boolean gradientVisible, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).gradientVisible(gradientVisible, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl gradientVisible( boolean gradientVisible, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl group(int group, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).group(group, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl group( int group, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl lineColor(int color, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).lineColor(color, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl lineColor( int color, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl lineColor(Paint color, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).lineColor(color, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl lineColor( io.deephaven.gui.color.Paint color, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl lineColor(String color, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).lineColor(color, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl lineColor( java.lang.String color, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl lineStyle(LineStyle lineStyle, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).lineStyle(lineStyle, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl lineStyle( io.deephaven.plot.LineStyle lineStyle, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl linesVisible(Boolean visible, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).linesVisible(visible, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl linesVisible( java.lang.Boolean visible, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl piePercentLabelFormat(String pieLabelFormat, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).piePercentLabelFormat(pieLabelFormat, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl piePercentLabelFormat( java.lang.String pieLabelFormat, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(int pointColor, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColor, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( int pointColor, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(int[] pointColors, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColors, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( int[] pointColors, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(Table t, String category, String pointColor, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(t, category, pointColor, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( io.deephaven.engine.table.Table t, java.lang.String category, java.lang.String pointColor, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(Table t, String pointColors, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(t, pointColors, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( io.deephaven.engine.table.Table t, java.lang.String pointColors, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(Paint pointColor, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColor, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( io.deephaven.gui.color.Paint pointColor, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(Paint[] pointColor, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColor, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( io.deephaven.gui.color.Paint[] pointColor, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(SelectableDataSet sds, String category, String pointColor, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(sds, category, pointColor, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( io.deephaven.plot.filters.SelectableDataSet sds, java.lang.String category, java.lang.String pointColor, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(SelectableDataSet sds, String pointColors, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(sds, pointColors, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( io.deephaven.plot.filters.SelectableDataSet sds, java.lang.String pointColors, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(Comparable category, int pointColor, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(category, pointColor, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( java.lang.Comparable category, int pointColor, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(Comparable category, Paint pointColor, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(category, pointColor, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( java.lang.Comparable category, io.deephaven.gui.color.Paint pointColor, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(Comparable category, String pointColor, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(category, pointColor, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( java.lang.Comparable category, java.lang.String pointColor, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(Integer[] pointColors, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColors, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( java.lang.Integer[] pointColors, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(String pointColor, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColor, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( java.lang.String pointColor, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(String[] pointColors, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColors, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( java.lang.String[] pointColors, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointColorInteger(IndexableData<Integer> colors, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColorInteger(colors, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColorInteger( io.deephaven.plot.datasets.data.IndexableData<java.lang.Integer> colors, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointLabel(Table t, String category, String pointLabel, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(t, category, pointLabel, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointLabel( io.deephaven.engine.table.Table t, java.lang.String category, java.lang.String pointLabel, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointLabel(Table t, String pointLabel, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(t, pointLabel, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointLabel( io.deephaven.engine.table.Table t, java.lang.String pointLabel, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointLabel(IndexableData<?> pointLabels, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(pointLabels, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointLabel( io.deephaven.plot.datasets.data.IndexableData<?> pointLabels, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointLabel(SelectableDataSet sds, String category, String pointLabel, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(sds, category, pointLabel, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointLabel( io.deephaven.plot.filters.SelectableDataSet sds, java.lang.String category, java.lang.String pointLabel, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointLabel(SelectableDataSet sds, String pointLabel, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(sds, pointLabel, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointLabel( io.deephaven.plot.filters.SelectableDataSet sds, java.lang.String pointLabel, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointLabel(Comparable category, Object pointLabel, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(category, pointLabel, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointLabel( java.lang.Comparable category, java.lang.Object pointLabel, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointLabel(Object pointLabel, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(pointLabel, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointLabel( java.lang.Object pointLabel, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointLabel(Object[] pointLabels, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(pointLabels, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointLabel( java.lang.Object[] pointLabels, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointLabelFormat(String pointLabelFormat, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabelFormat(pointLabelFormat, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointLabelFormat( java.lang.String pointLabelFormat, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(Closure<String> pointShapes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(pointShapes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( groovy.lang.Closure<java.lang.String> pointShapes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(Table t, String category, String pointShape, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(t, category, pointShape, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( io.deephaven.engine.table.Table t, java.lang.String category, java.lang.String pointShape, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(Table t, String pointShape, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(t, pointShape, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( io.deephaven.engine.table.Table t, java.lang.String pointShape, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(Shape pointShape, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(pointShape, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( io.deephaven.gui.shape.Shape pointShape, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(Shape[] pointShapes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(pointShapes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( io.deephaven.gui.shape.Shape[] pointShapes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(IndexableData<String> pointShapes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(pointShapes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( io.deephaven.plot.datasets.data.IndexableData<java.lang.String> pointShapes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(SelectableDataSet sds, String category, String pointShape, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(sds, category, pointShape, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( io.deephaven.plot.filters.SelectableDataSet sds, java.lang.String category, java.lang.String pointShape, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(SelectableDataSet sds, String pointShape, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(sds, pointShape, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( io.deephaven.plot.filters.SelectableDataSet sds, java.lang.String pointShape, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(Comparable category, Shape pointShape, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(category, pointShape, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( java.lang.Comparable category, io.deephaven.gui.shape.Shape pointShape, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(Comparable category, String pointShape, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(category, pointShape, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( java.lang.Comparable category, java.lang.String pointShape, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(String pointShape, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(pointShape, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( java.lang.String pointShape, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(String[] pointShapes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(pointShapes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( java.lang.String[] pointShapes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(Function<Comparable, String> pointShapes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(pointShapes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( java.util.function.Function<java.lang.Comparable, java.lang.String> pointShapes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(double[] pointSizes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSizes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( double[] pointSizes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(int[] pointSizes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSizes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( int[] pointSizes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(Table t, String category, String pointSize, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(t, category, pointSize, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( io.deephaven.engine.table.Table t, java.lang.String category, java.lang.String pointSize, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(Table t, String pointSizes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(t, pointSizes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( io.deephaven.engine.table.Table t, java.lang.String pointSizes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(IndexableData<Double> pointSizes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSizes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( io.deephaven.plot.datasets.data.IndexableData<java.lang.Double> pointSizes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(SelectableDataSet sds, String category, String pointSize, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(sds, category, pointSize, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( io.deephaven.plot.filters.SelectableDataSet sds, java.lang.String category, java.lang.String pointSize, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(SelectableDataSet sds, String pointSize, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(sds, pointSize, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( io.deephaven.plot.filters.SelectableDataSet sds, java.lang.String pointSize, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(Comparable category, double pointSize, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(category, pointSize, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( java.lang.Comparable category, double pointSize, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(Comparable category, int pointSize, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(category, pointSize, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( java.lang.Comparable category, int pointSize, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(Comparable category, Number pointSize, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(category, pointSize, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( java.lang.Comparable category, java.lang.Number pointSize, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(Comparable category, long pointSize, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(category, pointSize, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( java.lang.Comparable category, long pointSize, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(Number pointSize, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSize, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( java.lang.Number pointSize, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(long[] pointSizes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSizes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( long[] pointSizes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointsVisible(Boolean visible, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointsVisible(visible, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointsVisible( java.lang.Boolean visible, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl seriesColor(int color, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).seriesColor(color, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl seriesColor( int color, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl seriesColor(Paint color, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).seriesColor(color, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl seriesColor( io.deephaven.gui.color.Paint color, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl seriesColor(String color, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).seriesColor(color, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl seriesColor( java.lang.String color, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl seriesNamingFunction(Closure<String> namingFunction) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).seriesNamingFunction(namingFunction);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl seriesNamingFunction( groovy.lang.Closure<java.lang.String> namingFunction )'", this.figure);
    }

    @Override
    public FigureImpl seriesNamingFunction(Function<Object, String> namingFunction) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).seriesNamingFunction(namingFunction);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl seriesNamingFunction( java.util.function.Function<java.lang.Object, java.lang.String> namingFunction )'", this.figure);
    }

    @Override
    public FigureImpl toolTipPattern(String toolTipPattern, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).toolTipPattern(toolTipPattern, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl toolTipPattern( java.lang.String toolTipPattern, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl xToolTipPattern(String xToolTipPattern, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).xToolTipPattern(xToolTipPattern, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl xToolTipPattern( java.lang.String xToolTipPattern, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl yToolTipPattern(String yToolTipPattern, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).yToolTipPattern(yToolTipPattern, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl yToolTipPattern( java.lang.String yToolTipPattern, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(int ... pointColors) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointColor(pointColors);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColors, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( int... pointColors )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(Table t, String pointColors) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointColor(t, pointColors);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(t, pointColors, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( io.deephaven.engine.table.Table t, java.lang.String pointColors )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(Paint ... pointColor) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointColor(pointColor);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColor, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( io.deephaven.gui.color.Paint... pointColor )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(SelectableDataSet sds, String pointColors) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointColor(sds, pointColors);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(sds, pointColors, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( io.deephaven.plot.filters.SelectableDataSet sds, java.lang.String pointColors )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(Integer ... pointColors) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointColor(pointColors);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColors, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( java.lang.Integer... pointColors )'", this.figure);
    }

    @Override
    public FigureImpl pointColor(String ... pointColors) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointColor(pointColors);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColors, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColor( java.lang.String... pointColors )'", this.figure);
    }

    @Override
    public FigureImpl pointColorInteger(IndexableData<Integer> colors) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointColorInteger(colors);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColorInteger(colors, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointColorInteger( io.deephaven.plot.datasets.data.IndexableData<java.lang.Integer> colors )'", this.figure);
    }

    @Override
    public FigureImpl pointLabel(Table t, String pointLabel) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointLabel(t, pointLabel);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(t, pointLabel, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointLabel( io.deephaven.engine.table.Table t, java.lang.String pointLabel )'", this.figure);
    }

    @Override
    public FigureImpl pointLabel(IndexableData<?> pointLabels) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointLabel(pointLabels);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(pointLabels, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointLabel( io.deephaven.plot.datasets.data.IndexableData<?> pointLabels )'", this.figure);
    }

    @Override
    public FigureImpl pointLabel(SelectableDataSet sds, String pointLabel) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointLabel(sds, pointLabel);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(sds, pointLabel, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointLabel( io.deephaven.plot.filters.SelectableDataSet sds, java.lang.String pointLabel )'", this.figure);
    }

    @Override
    public FigureImpl pointLabel(Object ... pointLabels) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointLabel(pointLabels);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(pointLabels, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointLabel( java.lang.Object... pointLabels )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(Table t, String pointShape) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointShape(t, pointShape);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(t, pointShape, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( io.deephaven.engine.table.Table t, java.lang.String pointShape )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(Shape ... pointShapes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointShape(pointShapes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(pointShapes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( io.deephaven.gui.shape.Shape... pointShapes )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(IndexableData<String> pointShapes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointShape(pointShapes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(pointShapes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( io.deephaven.plot.datasets.data.IndexableData<java.lang.String> pointShapes )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(SelectableDataSet sds, String pointShape) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointShape(sds, pointShape);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(sds, pointShape, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( io.deephaven.plot.filters.SelectableDataSet sds, java.lang.String pointShape )'", this.figure);
    }

    @Override
    public FigureImpl pointShape(String ... pointShapes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointShape(pointShapes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(pointShapes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointShape( java.lang.String... pointShapes )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(double ... pointSizes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointSize(pointSizes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSizes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( double... pointSizes )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(int ... pointSizes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointSize(pointSizes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSizes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( int... pointSizes )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(Table t, String pointSizes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointSize(t, pointSizes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(t, pointSizes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( io.deephaven.engine.table.Table t, java.lang.String pointSizes )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(IndexableData<Double> pointSizes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointSize(pointSizes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSizes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( io.deephaven.plot.datasets.data.IndexableData<java.lang.Double> pointSizes )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(SelectableDataSet sds, String pointSize) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointSize(sds, pointSize);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(sds, pointSize, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( io.deephaven.plot.filters.SelectableDataSet sds, java.lang.String pointSize )'", this.figure);
    }

    @Override
    public FigureImpl pointSize(long ... pointSizes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointSize(pointSizes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSizes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl pointSize( long... pointSizes )'", this.figure);
    }

    @Override
    public FigureImpl funcNPoints(int npoints) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeriesFunction) {
            XYDataSeriesFunction result = ((XYDataSeriesFunction)series).funcNPoints(npoints);
            return this.make((DataSeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl funcNPoints( int npoints )'", this.figure);
    }

    @Override
    public FigureImpl funcRange(double xmin, double xmax) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeriesFunction) {
            XYDataSeriesFunction result = ((XYDataSeriesFunction)series).funcRange(xmin, xmax);
            return this.make((DataSeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl funcRange( double xmin, double xmax )'", this.figure);
    }

    @Override
    public FigureImpl funcRange(double xmin, double xmax, int npoints) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeriesFunction) {
            XYDataSeriesFunction result = ((XYDataSeriesFunction)series).funcRange(xmin, xmax, npoints);
            return this.make((DataSeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public  FigureImpl funcRange( double xmin, double xmax, int npoints )'", this.figure);
    }

    @Override
    public <CATEGORY extends Comparable, COLOR extends Paint> FigureImpl pointColor(Map<CATEGORY, COLOR> pointColor) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointColor(pointColor);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColor, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <CATEGORY extends java.lang.Comparable,COLOR extends io.deephaven.gui.color.Paint> FigureImpl pointColor( java.util.Map<CATEGORY, COLOR> pointColor )'", this.figure);
    }

    @Override
    public <CATEGORY extends Comparable, COLOR extends Paint> FigureImpl pointColor(Map<CATEGORY, COLOR> pointColor, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColor, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <CATEGORY extends java.lang.Comparable,COLOR extends io.deephaven.gui.color.Paint> FigureImpl pointColor( java.util.Map<CATEGORY, COLOR> pointColor, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <CATEGORY extends Comparable, COLOR extends Integer> FigureImpl pointColorInteger(Map<CATEGORY, COLOR> colors) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointColorInteger(colors);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColorInteger(colors, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <CATEGORY extends java.lang.Comparable,COLOR extends java.lang.Integer> FigureImpl pointColorInteger( java.util.Map<CATEGORY, COLOR> colors )'", this.figure);
    }

    @Override
    public <CATEGORY extends Comparable, COLOR extends Integer> FigureImpl pointColorInteger(Map<CATEGORY, COLOR> colors, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColorInteger(colors, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <CATEGORY extends java.lang.Comparable,COLOR extends java.lang.Integer> FigureImpl pointColorInteger( java.util.Map<CATEGORY, COLOR> colors, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <CATEGORY extends Comparable, LABEL> FigureImpl pointLabel(Map<CATEGORY, LABEL> pointLabels) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointLabel(pointLabels);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(pointLabels, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <CATEGORY extends java.lang.Comparable,LABEL> FigureImpl pointLabel( java.util.Map<CATEGORY, LABEL> pointLabels )'", this.figure);
    }

    @Override
    public <CATEGORY extends Comparable, LABEL> FigureImpl pointLabel(Map<CATEGORY, LABEL> pointLabels, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(pointLabels, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <CATEGORY extends java.lang.Comparable,LABEL> FigureImpl pointLabel( java.util.Map<CATEGORY, LABEL> pointLabels, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <CATEGORY extends Comparable, NUMBER extends Number> FigureImpl pointSize(CATEGORY[] categories, NUMBER[] pointSizes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointSize((Comparable[])categories, (Number[])pointSizes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize((Comparable[])categories, (Number[])pointSizes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <CATEGORY extends java.lang.Comparable,NUMBER extends java.lang.Number> FigureImpl pointSize( CATEGORY[] categories, NUMBER[] pointSizes )'", this.figure);
    }

    @Override
    public <CATEGORY extends Comparable, NUMBER extends Number> FigureImpl pointSize(Map<CATEGORY, NUMBER> pointSizes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointSize(pointSizes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSizes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <CATEGORY extends java.lang.Comparable,NUMBER extends java.lang.Number> FigureImpl pointSize( java.util.Map<CATEGORY, NUMBER> pointSizes )'", this.figure);
    }

    @Override
    public <CATEGORY extends Comparable, NUMBER extends Number> FigureImpl pointSize(CATEGORY[] categories, NUMBER[] pointSizes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize((Comparable[])categories, (Number[])pointSizes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <CATEGORY extends java.lang.Comparable,NUMBER extends java.lang.Number> FigureImpl pointSize( CATEGORY[] categories, NUMBER[] pointSizes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <CATEGORY extends Comparable, NUMBER extends Number> FigureImpl pointSize(Map<CATEGORY, NUMBER> pointSizes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSizes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <CATEGORY extends java.lang.Comparable,NUMBER extends java.lang.Number> FigureImpl pointSize( java.util.Map<CATEGORY, NUMBER> pointSizes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <CATEGORY extends Comparable> FigureImpl pointShape(Map<CATEGORY, String> pointShapes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointShape(pointShapes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(pointShapes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <CATEGORY extends java.lang.Comparable> FigureImpl pointShape( java.util.Map<CATEGORY, java.lang.String> pointShapes )'", this.figure);
    }

    @Override
    public <CATEGORY extends Comparable> FigureImpl pointSize(CATEGORY[] categories, double[] pointSizes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointSize((Comparable[])categories, pointSizes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize((Comparable[])categories, pointSizes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <CATEGORY extends java.lang.Comparable> FigureImpl pointSize( CATEGORY[] categories, double[] pointSizes )'", this.figure);
    }

    @Override
    public <CATEGORY extends Comparable> FigureImpl pointSize(CATEGORY[] categories, int[] pointSizes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointSize((Comparable[])categories, pointSizes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize((Comparable[])categories, pointSizes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <CATEGORY extends java.lang.Comparable> FigureImpl pointSize( CATEGORY[] categories, int[] pointSizes )'", this.figure);
    }

    @Override
    public <CATEGORY extends Comparable> FigureImpl pointSize(CATEGORY[] categories, long[] pointSizes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointSize((Comparable[])categories, pointSizes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize((Comparable[])categories, pointSizes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <CATEGORY extends java.lang.Comparable> FigureImpl pointSize( CATEGORY[] categories, long[] pointSizes )'", this.figure);
    }

    @Override
    public <CATEGORY extends Comparable> FigureImpl pointShape(Map<CATEGORY, String> pointShapes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointShape(pointShapes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <CATEGORY extends java.lang.Comparable> FigureImpl pointShape( java.util.Map<CATEGORY, java.lang.String> pointShapes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <CATEGORY extends Comparable> FigureImpl pointSize(CATEGORY[] categories, double[] pointSizes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize((Comparable[])categories, pointSizes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <CATEGORY extends java.lang.Comparable> FigureImpl pointSize( CATEGORY[] categories, double[] pointSizes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <CATEGORY extends Comparable> FigureImpl pointSize(CATEGORY[] categories, int[] pointSizes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize((Comparable[])categories, pointSizes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <CATEGORY extends java.lang.Comparable> FigureImpl pointSize( CATEGORY[] categories, int[] pointSizes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <CATEGORY extends Comparable> FigureImpl pointSize(CATEGORY[] categories, long[] pointSizes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize((Comparable[])categories, pointSizes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <CATEGORY extends java.lang.Comparable> FigureImpl pointSize( CATEGORY[] categories, long[] pointSizes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <COLOR extends Paint> FigureImpl pointColor(Closure<COLOR> pointColor) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointColor(pointColor);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColor, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <COLOR extends io.deephaven.gui.color.Paint> FigureImpl pointColor( groovy.lang.Closure<COLOR> pointColor )'", this.figure);
    }

    @Override
    public <COLOR extends Paint> FigureImpl pointColor(Function<Comparable, COLOR> pointColor) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointColor(pointColor);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColor, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <COLOR extends io.deephaven.gui.color.Paint> FigureImpl pointColor( java.util.function.Function<java.lang.Comparable, COLOR> pointColor )'", this.figure);
    }

    @Override
    public <COLOR extends Paint> FigureImpl pointColor(Closure<COLOR> pointColor, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColor, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <COLOR extends io.deephaven.gui.color.Paint> FigureImpl pointColor( groovy.lang.Closure<COLOR> pointColor, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <COLOR extends Paint> FigureImpl pointColor(Function<Comparable, COLOR> pointColor, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColor, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <COLOR extends io.deephaven.gui.color.Paint> FigureImpl pointColor( java.util.function.Function<java.lang.Comparable, COLOR> pointColor, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <COLOR extends Integer> FigureImpl pointColorInteger(Closure<COLOR> colors) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointColorInteger(colors);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColorInteger(colors, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <COLOR extends java.lang.Integer> FigureImpl pointColorInteger( groovy.lang.Closure<COLOR> colors )'", this.figure);
    }

    @Override
    public <COLOR extends Integer> FigureImpl pointColorInteger(Function<Comparable, COLOR> colors) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointColorInteger(colors);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColorInteger(colors, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <COLOR extends java.lang.Integer> FigureImpl pointColorInteger( java.util.function.Function<java.lang.Comparable, COLOR> colors )'", this.figure);
    }

    @Override
    public <COLOR extends Integer> FigureImpl pointColorInteger(Closure<COLOR> colors, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColorInteger(colors, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <COLOR extends java.lang.Integer> FigureImpl pointColorInteger( groovy.lang.Closure<COLOR> colors, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <COLOR extends Integer> FigureImpl pointColorInteger(Function<Comparable, COLOR> colors, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColorInteger(colors, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <COLOR extends java.lang.Integer> FigureImpl pointColorInteger( java.util.function.Function<java.lang.Comparable, COLOR> colors, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <LABEL> FigureImpl pointLabel(Closure<LABEL> pointLabels) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointLabel(pointLabels);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(pointLabels, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <LABEL> FigureImpl pointLabel( groovy.lang.Closure<LABEL> pointLabels )'", this.figure);
    }

    @Override
    public <LABEL> FigureImpl pointLabel(Function<Comparable, LABEL> pointLabels) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointLabel(pointLabels);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(pointLabels, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <LABEL> FigureImpl pointLabel( java.util.function.Function<java.lang.Comparable, LABEL> pointLabels )'", this.figure);
    }

    @Override
    public <LABEL> FigureImpl pointLabel(Closure<LABEL> pointLabels, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(pointLabels, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <LABEL> FigureImpl pointLabel( groovy.lang.Closure<LABEL> pointLabels, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <LABEL> FigureImpl pointLabel(Function<Comparable, LABEL> pointLabels, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointLabel(pointLabels, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <LABEL> FigureImpl pointLabel( java.util.function.Function<java.lang.Comparable, LABEL> pointLabels, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <NUMBER extends Number> FigureImpl pointSize(Closure<NUMBER> pointSizes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointSize(pointSizes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSizes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <NUMBER extends java.lang.Number> FigureImpl pointSize( groovy.lang.Closure<NUMBER> pointSizes )'", this.figure);
    }

    @Override
    public <NUMBER extends Number> FigureImpl pointSize(Function<Comparable, NUMBER> pointSizes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof CategoryDataSeries) {
            CategoryDataSeries result = ((CategoryDataSeries)series).pointSize(pointSizes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSizes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <NUMBER extends java.lang.Number> FigureImpl pointSize( java.util.function.Function<java.lang.Comparable, NUMBER> pointSizes )'", this.figure);
    }

    @Override
    public <NUMBER extends Number> FigureImpl pointSize(Closure<NUMBER> pointSizes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSizes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <NUMBER extends java.lang.Number> FigureImpl pointSize( groovy.lang.Closure<NUMBER> pointSizes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <NUMBER extends Number> FigureImpl pointSize(Function<Comparable, NUMBER> pointSizes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize(pointSizes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <NUMBER extends java.lang.Number> FigureImpl pointSize( java.util.function.Function<java.lang.Comparable, NUMBER> pointSizes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <T extends Paint> FigureImpl pointColor(IndexableData<T> pointColor, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColor, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <T extends io.deephaven.gui.color.Paint> FigureImpl pointColor( io.deephaven.plot.datasets.data.IndexableData<T> pointColor, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <T extends Paint> FigureImpl pointColor(IndexableData<T> pointColor) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointColor(pointColor);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointColor(pointColor, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <T extends io.deephaven.gui.color.Paint> FigureImpl pointColor( io.deephaven.plot.datasets.data.IndexableData<T> pointColor )'", this.figure);
    }

    @Override
    public <T extends Number> FigureImpl pointSize(T[] pointSizes, Object ... multiSeriesKey) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize((Number[])pointSizes, multiSeriesKey);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <T extends java.lang.Number> FigureImpl pointSize( T[] pointSizes, java.lang.Object... multiSeriesKey )'", this.figure);
    }

    @Override
    public <T extends Number> FigureImpl pointSize(T[] pointSizes) {
        BaseFigureImpl fc = this.figure.copy();
        Series series = this.series(fc);
        if (series instanceof XYDataSeries) {
            XYDataSeries result = ((XYDataSeries)series).pointSize((Number[])pointSizes);
            return this.make((DataSeriesInternal)((Object)result));
        }
        if (series instanceof MultiSeries) {
            MultiSeries result = ((MultiSeries)series).pointSize((Number[])pointSizes, ArrayTypeUtils.EMPTY_OBJECT_ARRAY);
            return this.make((SeriesInternal)((Object)result));
        }
        throw new PlotUnsupportedOperationException("Series type does not support this method.  seriesType=" + String.valueOf(series.getClass()) + " method='@Override public <T extends java.lang.Number> FigureImpl pointSize( T[] pointSizes )'", this.figure);
    }
}

