/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot;

import io.deephaven.engine.table.Table;
import io.deephaven.plot.ChartTitle;
import io.deephaven.plot.datasets.data.IndexableData;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.util.tables.PartitionedTableHandle;
import io.deephaven.plot.util.tables.SwappablePartitionedTable;
import io.deephaven.plot.util.tables.SwappableTable;
import io.deephaven.plot.util.tables.TableHandle;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class DynamicChartTitle
extends ChartTitle {
    String titleFormat;
    String dynamicTitleString;

    DynamicChartTitle(String titleFormat, PlotInfo plotInfo, int maxVisibleRowsCount) {
        super(plotInfo, maxVisibleRowsCount);
        this.titleFormat = titleFormat;
    }

    void copy(DynamicChartTitle chartTitle) {
        super.copy(chartTitle);
        this.titleFormat = chartTitle.titleFormat;
        this.dynamicTitleString = chartTitle.dynamicTitleString;
    }

    @Override
    public synchronized String getTitle() {
        return this.dynamicTitleString == null ? "" : this.dynamicTitleString;
    }

    private static String getStringValue(IndexableData indexableData, int index) {
        return indexableData.get(index) == null ? "" : indexableData.get(index).toString();
    }

    public static class ChartTitleTable
    extends DynamicChartTitleTable {
        private TableHandle tableHandle;

        public TableHandle getTableHandle() {
            return this.tableHandle;
        }

        ChartTitleTable(String titleFormat, TableHandle tableHandle, PlotInfo plotInfo, int maxVisibleRowsCount, String ... titleColumns) {
            super(titleFormat, new LinkedHashSet<String>(Arrays.asList(titleColumns)), plotInfo, maxVisibleRowsCount);
            this.tableHandle = tableHandle;
        }
    }

    public static class ChartTitleSwappableTable
    extends DynamicChartTitleTable {
        private SwappableTable swappableTable;
        private PartitionedTableHandle partitionedTableHandle;
        private transient Table localTable;

        ChartTitleSwappableTable(String titleFormat, SwappableTable swappableTable, PlotInfo plotInfo, int maxVisibleRowsCount, String ... titleColumns) {
            super(titleFormat, new LinkedHashSet<String>(Arrays.asList(titleColumns)), plotInfo, maxVisibleRowsCount);
            this.swappableTable = swappableTable;
            if (swappableTable instanceof SwappablePartitionedTable) {
                this.partitionedTableHandle = ((SwappablePartitionedTable)((Object)swappableTable)).getPartitionedTableHandle();
            }
        }

        void copy(ChartTitleSwappableTable chartTitle) {
            super.copy(chartTitle);
            this.swappableTable = chartTitle.swappableTable;
            this.partitionedTableHandle = chartTitle.partitionedTableHandle;
            this.localTable = chartTitle.localTable;
        }

        public SwappableTable getSwappableTable() {
            return this.swappableTable;
        }

        public PartitionedTableHandle getPartitionedTableHandle() {
            return this.partitionedTableHandle;
        }
    }

    public static abstract class DynamicChartTitleTable
    extends DynamicChartTitle {
        private final Set<String> titleColumns;

        DynamicChartTitleTable(String titleFormat, Set<String> titleColumns, PlotInfo plotInfo, int maxVisibleRowsCount) {
            super(titleFormat, plotInfo, maxVisibleRowsCount);
            this.titleColumns = titleColumns;
        }

        void copy(DynamicChartTitleTable chartTitle) {
            super.copy(chartTitle);
            this.titleColumns.addAll(chartTitle.titleColumns);
        }

        static String defaultTitleFormatWithColumnNames(String ... titleColumns) {
            if (titleColumns != null && titleColumns.length > 0) {
                String titleColumn;
                int i;
                StringBuilder sb = new StringBuilder();
                for (i = 0; i < titleColumns.length - 1; ++i) {
                    titleColumn = titleColumns[i];
                    sb.append(titleColumn).append(": {").append(i).append("}        ");
                }
                for (i = titleColumns.length - 1; i < titleColumns.length; ++i) {
                    titleColumn = titleColumns[i];
                    sb.append(titleColumn).append(": {").append(i).append("}");
                }
                return sb.toString();
            }
            return "";
        }

        static String defaultTitleFormat(String ... titleColumns) {
            if (titleColumns != null && titleColumns.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < titleColumns.length; ++i) {
                    sb.append("{").append(i).append("}").append(i == titleColumns.length - 1 ? "" : "        ");
                }
                return sb.toString();
            }
            return "";
        }
    }
}

