/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot;

import io.deephaven.plot.BaseFigureImpl;
import io.deephaven.plot.ChartArray;
import io.deephaven.plot.ChartImpl;
import java.io.Serializable;

class ChartLocation
implements Serializable {
    private static final long serialVersionUID = 1594957448496772360L;
    private final int row;
    private final int col;

    ChartLocation(ChartImpl chart) {
        this.row = chart.row();
        this.col = chart.column();
    }

    ChartImpl get(BaseFigureImpl figure) {
        ChartArray charts = figure.getCharts();
        return charts.getChart(this.row, this.col);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChartLocation location = (ChartLocation)o;
        if (this.row != location.row) {
            return false;
        }
        return this.col == location.col;
    }

    public int hashCode() {
        int result = this.row;
        result = 31 * result + this.col;
        return result;
    }
}

