/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot;

import io.deephaven.configuration.Configuration;
import io.deephaven.engine.table.Table;
import io.deephaven.gui.color.Color;
import io.deephaven.gui.color.Paint;
import io.deephaven.plot.Axes;
import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.AxisImpl;
import io.deephaven.plot.BaseFigureImpl;
import io.deephaven.plot.Chart;
import io.deephaven.plot.ChartTitle;
import io.deephaven.plot.ChartType;
import io.deephaven.plot.DynamicChartTitle;
import io.deephaven.plot.Font;
import io.deephaven.plot.SeriesCollection;
import io.deephaven.plot.SeriesInternal;
import io.deephaven.plot.errors.PlotExceptionCause;
import io.deephaven.plot.errors.PlotIllegalArgumentException;
import io.deephaven.plot.errors.PlotInfo;
import io.deephaven.plot.errors.PlotRuntimeException;
import io.deephaven.plot.errors.PlotUnsupportedOperationException;
import io.deephaven.plot.filters.SelectableDataSet;
import io.deephaven.plot.util.ArgumentValidations;
import io.deephaven.plot.util.tables.SwappableTable;
import io.deephaven.plot.util.tables.TableHandle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.IntStream;

public class ChartImpl
implements Chart,
PlotExceptionCause {
    private static final long serialVersionUID = 9007248026427087347L;
    private final BaseFigureImpl figure;
    private final List<AxisImpl>[] axis = new List[]{new ArrayList(), new ArrayList()};
    private final List<AxesImpl> axes = new ArrayList<AxesImpl>();
    private ChartType chartType;
    private Font titleFont;
    private Paint titleColor;
    private Font legendFont;
    private Paint legendColor;
    private int colspan = 1;
    private int rowspan = 1;
    private boolean showLegend = true;
    private final int row;
    private final int column;
    private PlotOrientation plotOrientation = PlotOrientation.VERTICAL;
    private boolean initialized = false;
    private ChartTitle chartTitle;
    private int maxVisibleRowsCount;
    private Boolean displayXGridLines = null;
    private Boolean displayYGridLines = null;

    ChartImpl(BaseFigureImpl figure, int row, int column) {
        this.figure = figure;
        this.row = row;
        this.column = column;
        this.maxVisibleRowsCount = Configuration.getInstance().getIntegerWithDefault("Plot.chartTitle.maxRowsInTitle", 0);
    }

    private ChartImpl(ChartImpl chart, BaseFigureImpl figure) {
        this(figure, chart.row, chart.column);
        int i;
        this.chartType = chart.chartType;
        this.titleFont = chart.titleFont;
        this.titleColor = chart.titleColor;
        this.legendFont = chart.legendFont;
        this.legendColor = chart.legendColor;
        this.colspan = chart.colspan;
        this.rowspan = chart.rowspan;
        this.showLegend = chart.showLegend;
        this.plotOrientation = chart.plotOrientation;
        this.initialized = chart.initialized;
        this.chartTitle = chart.chartTitle;
        this.maxVisibleRowsCount = chart.maxVisibleRowsCount;
        this.displayXGridLines = chart.displayXGridLines;
        this.displayYGridLines = chart.displayYGridLines;
        for (i = 0; i < chart.axis.length; ++i) {
            List<AxisImpl> axisList = chart.axis[i];
            List<AxisImpl> copyAxisList = this.axis[i];
            for (int j = 0; j < axisList.size(); ++j) {
                copyAxisList.add(axisList.get(j).copy(this));
            }
        }
        for (i = 0; i < chart.axes.size(); ++i) {
            this.axes.add(chart.axes.get(i).copy(this));
        }
    }

    ChartImpl copy(BaseFigureImpl figure) {
        return new ChartImpl(this, figure);
    }

    public BaseFigureImpl figure() {
        return this.figure;
    }

    public int colSpan() {
        return this.colspan;
    }

    public int rowSpan() {
        return this.rowspan;
    }

    private void resize(int rowspan, int colspan) {
        if (rowspan < 1 || colspan < 1) {
            throw new PlotIllegalArgumentException("Row and column span must be at least one! rowspan=" + rowspan + ", colspan=" + colspan, this);
        }
        this.figure.resizePlot(this.row, this.column, rowspan, colspan);
        this.rowspan = rowspan;
        this.colspan = colspan;
    }

    public int column() {
        return this.column;
    }

    public int row() {
        return this.row;
    }

    void setChartType(ChartType chartType) {
        if (this.chartType == null) {
            this.chartType = chartType;
        } else if (this.chartType != chartType) {
            throw new PlotUnsupportedOperationException("Attempting to create inconsistent plot types: " + String.valueOf((Object)this.chartType) + ", " + String.valueOf((Object)chartType), this);
        }
    }

    AxisImpl newAxis(int dim) {
        int id = this.axis[dim].size();
        AxisImpl a = new AxisImpl(this, dim, id);
        this.axis[dim].add(a);
        return a;
    }

    AxesImpl newAxes(AxisImpl[] ax, String name) {
        int id = this.axes.size();
        String n = name == null ? Integer.toString(id) : name;
        for (AxesImpl aa : this.axes) {
            if (!aa.name().equals(n)) continue;
            throw new PlotRuntimeException("Axis with this name already exists. name=" + aa.name(), this);
        }
        AxesImpl a = new AxesImpl(id, n, this, ax);
        this.axes.add(a);
        return a;
    }

    public int dimension() {
        int d = -1;
        for (AxesImpl a : this.axes) {
            int dd = a.dimension();
            if (dd == -1) continue;
            if (d != -1 && d != dd) {
                throw new PlotRuntimeException("Inconsistent axis dimensions in chart: dim1=" + d + " dim2=" + dd, this);
            }
            d = dd;
        }
        return d;
    }

    void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    public List<AxisImpl>[] getAxis() {
        return this.axis;
    }

    public List<AxesImpl> getAxes() {
        return this.axes;
    }

    public ChartType getChartType() {
        return this.chartType;
    }

    public String getTitle() {
        return this.chartTitle == null ? "" : this.chartTitle.getTitle();
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public Paint getTitleColor() {
        return this.titleColor;
    }

    public Font getLegendFont() {
        return this.legendFont;
    }

    public Paint getLegendColor() {
        return this.legendColor;
    }

    public Boolean isDisplayXGridLines() {
        return this.displayXGridLines;
    }

    public Boolean isDisplayYGridLines() {
        return this.displayYGridLines;
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public PlotOrientation getPlotOrientation() {
        return this.plotOrientation;
    }

    @Override
    public PlotInfo getPlotInfo() {
        return new PlotInfo(this.figure(), this, (SeriesInternal)null);
    }

    private Set<TableHandle> getTableHandles() {
        HashSet<TableHandle> result = new HashSet<TableHandle>();
        for (AxesImpl axes : this.getAxes()) {
            for (SeriesCollection.SeriesDescription seriesDescription : axes.dataSeries().getSeriesDescriptions().values()) {
                result.addAll(seriesDescription.getSeries().getTableHandles());
            }
        }
        if (this.getChartTitle() instanceof DynamicChartTitle.ChartTitleTable) {
            result.add(((DynamicChartTitle.ChartTitleTable)this.getChartTitle()).getTableHandle());
        }
        return result;
    }

    private Set<SwappableTable> getSwappableTables() {
        HashSet<SwappableTable> result = new HashSet<SwappableTable>();
        for (AxesImpl axes : this.getAxes()) {
            for (SeriesCollection.SeriesDescription seriesDescription : axes.dataSeries().getSeriesDescriptions().values()) {
                result.addAll(seriesDescription.getSeries().getSwappableTables());
            }
        }
        if (this.getChartTitle() instanceof DynamicChartTitle.ChartTitleSwappableTable) {
            result.add(((DynamicChartTitle.ChartTitleSwappableTable)this.getChartTitle()).getSwappableTable());
        }
        return result;
    }

    public ChartTitle getChartTitle() {
        return this.chartTitle;
    }

    @Override
    public ChartImpl chartRemoveSeries(String ... removeSeriesNames) {
        for (Axes axes : this.axes) {
            axes.axesRemoveSeries(removeSeriesNames);
        }
        return this;
    }

    @Override
    public ChartImpl chartTitle(String title) {
        if (this.chartTitle == null) {
            this.chartTitle = new ChartTitle(this.getPlotInfo());
        }
        this.chartTitle.setStaticTitle(title == null ? "" : title);
        return this;
    }

    @Override
    public ChartImpl chartTitle(String titleFormat, Table t, String ... titleColumns) {
        ArgumentValidations.assertNotNull(t, "table", this.getPlotInfo());
        ArgumentValidations.assertNotNull(titleColumns, "titleColumns", this.getPlotInfo());
        ArgumentValidations.assertGreaterThan0(titleColumns.length, "titleColumns size", this.getPlotInfo());
        IntStream.range(0, titleColumns.length).forEachOrdered(i -> ArgumentValidations.assertNotNull(titleColumns[i], "titleColumn[" + i + "]", this.getPlotInfo()));
        ArgumentValidations.assertColumnsInTable(t, this.getPlotInfo(), titleColumns);
        TableHandle tableHandle = new TableHandle(t, titleColumns);
        this.chartTitle = new DynamicChartTitle.ChartTitleTable(titleFormat, tableHandle, this.getPlotInfo(), this.maxVisibleRowsCount, titleColumns);
        return this;
    }

    @Override
    public ChartImpl chartTitle(String titleFormat, SelectableDataSet sds, String ... titleColumns) {
        ArgumentValidations.assertNotNull(sds, "sds", this.getPlotInfo());
        ArgumentValidations.assertNotNull(titleColumns, "titleColumns", this.getPlotInfo());
        ArgumentValidations.assertGreaterThan0(titleColumns.length, "titleColumns size", this.getPlotInfo());
        for (int i = 0; i < titleColumns.length; ++i) {
            String titleColumn = titleColumns[i];
            ArgumentValidations.assertNotNull(titleColumn, "titleColumn[" + i + "]", this.getPlotInfo());
        }
        SwappableTable swappableTable = sds.getSwappableTable((Comparable)((Object)"ChartTitle"), this, (Function<Table, Table> & Serializable)table -> table, titleColumns);
        ArgumentValidations.assertColumnsInTable(swappableTable.getTableDefinition(), this.getPlotInfo(), titleColumns);
        this.chartTitle = new DynamicChartTitle.ChartTitleSwappableTable(titleFormat, swappableTable, this.getPlotInfo(), this.maxVisibleRowsCount, titleColumns);
        return this;
    }

    @Override
    public Chart maxRowsInTitle(int maxTitleRows) {
        if (this.chartTitle == null) {
            this.chartTitle = new ChartTitle(this.getPlotInfo());
        }
        this.maxVisibleRowsCount = maxTitleRows;
        this.chartTitle.maxVisibleRowsCount = maxTitleRows;
        return this;
    }

    @Override
    public ChartImpl chartTitleFont(Font font) {
        this.titleFont = font;
        return this;
    }

    @Override
    public ChartImpl chartTitleFont(String family, String style, int size) {
        return this.chartTitleFont(Font.font(family, style, size));
    }

    @Override
    public ChartImpl chartTitleColor(Paint color) {
        this.titleColor = color;
        return this;
    }

    @Override
    public ChartImpl chartTitleColor(String color) {
        this.titleColor = Color.color((String)color);
        return this;
    }

    @Override
    public Chart gridLinesVisible(boolean gridVisible) {
        this.xGridLinesVisible(gridVisible);
        this.yGridLinesVisible(gridVisible);
        return this;
    }

    @Override
    public Chart xGridLinesVisible(boolean xGridVisible) {
        this.displayXGridLines = xGridVisible;
        return this;
    }

    @Override
    public Chart yGridLinesVisible(boolean yGridVisible) {
        this.displayYGridLines = yGridVisible;
        return this;
    }

    @Override
    public ChartImpl legendVisible(boolean visible) {
        this.showLegend = visible;
        return this;
    }

    @Override
    public ChartImpl legendFont(Font font) {
        this.legendFont = font;
        this.legendVisible(true);
        return this;
    }

    @Override
    public ChartImpl legendFont(String family, String style, int size) {
        return this.legendFont(Font.font(family, style, size));
    }

    @Override
    public ChartImpl legendColor(Paint color) {
        this.legendColor = color;
        this.legendVisible(true);
        return this;
    }

    @Override
    public ChartImpl legendColor(String color) {
        this.legendColor = Color.color((String)color);
        this.legendVisible(true);
        return this;
    }

    @Override
    public ChartImpl span(int rowSpan, int colSpan) {
        this.rowSpan(rowSpan);
        this.colSpan(colSpan);
        return this;
    }

    @Override
    public ChartImpl colSpan(int colSpan) {
        this.resize(this.rowspan, colSpan);
        return this;
    }

    @Override
    public ChartImpl rowSpan(int rowSpan) {
        this.resize(rowSpan, this.colspan);
        return this;
    }

    @Override
    public AxesImpl newAxes() {
        return this.newAxes(2);
    }

    @Override
    public AxesImpl newAxes(String name) {
        return this.newAxes(name, 2);
    }

    @Override
    public AxesImpl newAxes(int dim) {
        return this.newAxes(null, dim);
    }

    @Override
    public AxesImpl newAxes(String name, int dim) {
        ArgumentValidations.assertGreaterThan0(dim, "dim", this.getPlotInfo());
        AxisImpl[] ax = new AxisImpl[dim];
        for (int i = 0; i < dim; ++i) {
            ax[i] = this.newAxis(i);
        }
        return this.newAxes(ax, name);
    }

    @Override
    public Axes axes(int id) {
        List<AxesImpl> axes = this.getAxes();
        int size = axes.size();
        if (id < 0 || id >= size) {
            throw new PlotIllegalArgumentException("Axes not in chart: index=" + id + ", required in range = [0," + (size - 1) + "]", this);
        }
        return axes.get(id);
    }

    @Override
    public Axes axes(String name) {
        for (AxesImpl a : this.getAxes()) {
            if (!a.name().equals(name)) continue;
            return a;
        }
        return null;
    }

    public ChartImpl plotOrientation(PlotOrientation orientation) {
        this.plotOrientation = orientation;
        return this;
    }

    @Override
    public ChartImpl plotOrientation(String orientation) {
        PlotOrientation plotOrientation;
        try {
            plotOrientation = PlotOrientation.fromString(orientation);
        }
        catch (IllegalArgumentException e) {
            throw new PlotIllegalArgumentException(e.getMessage(), this);
        }
        return this.plotOrientation(plotOrientation);
    }

    public static enum PlotOrientation {
        HORIZONTAL,
        VERTICAL;


        public static PlotOrientation fromString(String s) {
            if (s == null) {
                throw new IllegalArgumentException("Orientation can't be null");
            }
            String horizontal = "HORIZONTAL";
            String vertical = "VERTICAL";
            if (!(s = s.toUpperCase()).isEmpty()) {
                s = "HORIZONTAL".startsWith(s) ? "HORIZONTAL" : ("VERTICAL".startsWith(s) ? "VERTICAL" : s);
            }
            return PlotOrientation.valueOf(s);
        }
    }
}

