/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot;

import io.deephaven.plot.AxisImpl;
import io.deephaven.plot.BaseFigureImpl;
import io.deephaven.plot.ChartImpl;
import io.deephaven.plot.ChartLocation;
import java.io.Serializable;

public class AxisLocation
implements Serializable {
    private static final long serialVersionUID = 9034132734092464678L;
    private final ChartLocation chartLocation;
    private final int dim;
    private final int id;

    AxisLocation(AxisImpl axis) {
        this.chartLocation = new ChartLocation(axis.chart());
        this.dim = axis.dim();
        this.id = axis.id();
    }

    AxisImpl get(BaseFigureImpl figure) {
        ChartImpl chart = this.chartLocation.get(figure);
        return chart.getAxis()[this.dim].get(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AxisLocation that = (AxisLocation)o;
        if (this.dim != that.dim) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        return this.chartLocation != null ? this.chartLocation.equals(that.chartLocation) : that.chartLocation == null;
    }

    public int hashCode() {
        int result = this.chartLocation != null ? this.chartLocation.hashCode() : 0;
        result = 31 * result + this.dim;
        result = 31 * result + this.id;
        return result;
    }
}

