/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.plot;

import io.deephaven.plot.AxesImpl;
import io.deephaven.plot.BaseFigureImpl;
import io.deephaven.plot.ChartImpl;
import io.deephaven.plot.ChartLocation;
import java.io.Serializable;

class AxesLocation
implements Serializable {
    private static final long serialVersionUID = 3878962519670912774L;
    private final ChartLocation chartLocation;
    private final int id;

    AxesLocation(AxesImpl axes) {
        this.chartLocation = new ChartLocation(axes.chart());
        this.id = axes.id();
    }

    AxesImpl get(BaseFigureImpl figure) {
        ChartImpl chart = this.chartLocation.get(figure);
        return chart.getAxes().get(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AxesLocation that = (AxesLocation)o;
        if (this.id != that.id) {
            return false;
        }
        return this.chartLocation != null ? this.chartLocation.equals(that.chartLocation) : that.chartLocation == null;
    }

    public int hashCode() {
        int result = this.chartLocation != null ? this.chartLocation.hashCode() : 0;
        result = 31 * result + this.id;
        return result;
    }
}

