/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.gui.shape;

import io.deephaven.gui.shape.Shape;
import java.util.Arrays;

public enum NamedShape implements Shape
{
    SQUARE,
    CIRCLE,
    UP_TRIANGLE,
    DIAMOND,
    HORIZONTAL_RECTANGLE,
    ELLIPSE,
    RIGHT_TRIANGLE,
    DOWN_TRIANGLE,
    VERTICAL_RECTANGLE,
    LEFT_TRIANGLE;

    private static final NamedShape[] values;
    private static final String shapes;

    public static NamedShape getShape(String shape) {
        try {
            return shape == null ? null : NamedShape.valueOf(shape.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Not a valid shape: `" + shape + "`; valid shapes: " + shapes);
        }
    }

    public static String getShapesString() {
        return shapes;
    }

    static {
        values = NamedShape.values();
        shapes = Arrays.toString(values);
    }
}

