/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.test;

import com.ibm.as400.access.AS400;
import io.debezium.ibmi.db2.journal.data.types.Diagnostics;
import io.debezium.ibmi.db2.journal.retrieve.Connect;
import io.debezium.ibmi.db2.journal.retrieve.JournalInfo;
import io.debezium.ibmi.db2.journal.retrieve.JournalInfoRetrieval;
import io.debezium.ibmi.db2.journal.retrieve.JournalProcessedPosition;
import io.debezium.ibmi.db2.journal.retrieve.JournalReceiver;
import io.debezium.ibmi.db2.journal.retrieve.JournalRecordDecoder;
import io.debezium.ibmi.db2.journal.retrieve.RetrieveConfig;
import io.debezium.ibmi.db2.journal.retrieve.RetrieveConfigBuilder;
import io.debezium.ibmi.db2.journal.retrieve.RetrieveJournal;
import io.debezium.ibmi.db2.journal.retrieve.rjne0200.EntryHeader;
import io.debezium.ibmi.db2.journal.retrieve.rjne0200.FirstHeader;
import io.debezium.ibmi.db2.journal.retrieve.rjne0200.OffsetStatus;
import io.debezium.ibmi.db2.journal.test.TestConnector;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugJournal {
    private static final Logger log = LoggerFactory.getLogger(DebugJournal.class);

    public static void main(String[] args) throws Exception {
        TestConnector connector = new TestConnector();
        Connect<AS400, IOException> as400Connect = connector.getAs400();
        Connect<Connection, SQLException> sqlConnect = connector.getJdbc();
        String schema = connector.getSchema();
        byte[] data = Files.readAllBytes(Paths.get("C:\\dev\\kafka\\journal-parsing\\good-journal\\201218-0616-0", new String[0]));
        JournalInfo journal = JournalInfoRetrieval.getJournal(as400Connect.connection(), schema);
        RetrieveConfig config = new RetrieveConfigBuilder().withAs400(as400Connect).withJournalInfo(journal).build();
        RetrieveJournal rnj = new RetrieveJournal(config, new JournalInfoRetrieval());
        rnj.setOutputData(data, new FirstHeader(data.length, 0, data.length, OffsetStatus.NO_DATA, new JournalProcessedPosition()), new JournalProcessedPosition());
        if (rnj.nextEntry()) {
            EntryHeader entry = rnj.getEntryHeader();
            String code = String.format("%s %s", Character.valueOf(entry.getJournalCode()), entry.getEntryType());
            log.info("code: {}", (Object)code);
            switch (code) {
                case "J NR": {
                    JournalReceiver receiver = rnj.decode(new JournalRecordDecoder());
                    log.info("receiver {}", (Object)receiver);
                    break;
                }
            }
            log.info("header {}", (Object)rnj.getEntryHeader().toString());
            rnj.dumpEntry();
            log.info("dump from entry start");
            log.info(Diagnostics.binAsHex(data, rnj.getOffset() + rnj.getEntryHeader().getEntrySpecificDataOffset(), rnj.getEntryHeader().getLength()));
            log.info(Diagnostics.binAsEbcdic(data, rnj.getOffset() + rnj.getEntryHeader().getEntrySpecificDataOffset(), rnj.getEntryHeader().getLength()));
            rnj.dumpEntry();
        }
    }
}

