/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve.rjne0200;

import io.debezium.ibmi.db2.journal.retrieve.JournalEntryType;
import io.debezium.ibmi.db2.journal.retrieve.StringHelpers;
import java.math.BigInteger;
import java.time.Instant;

public class EntryHeader {
    private final int nextEntryOffset;
    private final int nullValueOffest;
    private final int entrySpecificDataOffset;
    private final BigInteger sequenceNumber;
    private final BigInteger systemSequenceNumber;
    private final Instant timestamp;
    private final char journalCode;
    private final String entryType;
    private final String objectName;
    private final BigInteger commitCycle;
    private final int endOffset;
    private final long pointerHandle;
    private final String receiver;
    private final String receiverLibrary;

    public EntryHeader(int nextEntryOffset, int nullValueOffest, long entrySpecificDataOffset, BigInteger sequenceNumber, BigInteger systemSequenceNumber, Instant timestamp, char journalCode, String entryType, String objectName, BigInteger commitCycle, int endOffset, long pointerHandle, String receiver, String receiverLibrary) {
        this.nextEntryOffset = nextEntryOffset;
        this.nullValueOffest = nullValueOffest;
        this.entrySpecificDataOffset = (int)entrySpecificDataOffset;
        this.sequenceNumber = sequenceNumber;
        this.systemSequenceNumber = systemSequenceNumber;
        this.timestamp = timestamp;
        this.journalCode = journalCode;
        this.entryType = entryType;
        this.objectName = objectName;
        this.commitCycle = commitCycle;
        this.endOffset = endOffset;
        this.pointerHandle = pointerHandle;
        this.receiver = StringHelpers.safeTrim(receiver);
        this.receiverLibrary = StringHelpers.safeTrim(receiverLibrary);
    }

    public String toString() {
        return String.format("EntryHeader [nextEntryOffset=%s, nullValueOffest=%s, entrySpecificDataOffset=%s, sequenceNumber=%s, systemSequenceNumber=%s, timestamp=%s, journalCode=%s, entryType=%s, objectName=%s, commitCycle=%s, endOffset=%s, pointerHandle=%s, receiver=%s, receiverLibrary=%s]", this.nextEntryOffset, this.nullValueOffest, this.entrySpecificDataOffset, this.sequenceNumber, this.systemSequenceNumber, this.timestamp, Character.valueOf(this.journalCode), this.entryType, this.objectName, this.commitCycle, this.endOffset, this.pointerHandle, this.receiver, this.receiverLibrary);
    }

    public int getLength() {
        return this.getEndOffset() - this.getEntrySpecificDataOffset();
    }

    public int getNextEntryOffset() {
        return this.nextEntryOffset;
    }

    public int getEntrySpecificDataOffset() {
        return this.entrySpecificDataOffset;
    }

    public BigInteger getSequenceNumber() {
        return this.sequenceNumber;
    }

    public BigInteger getSystemSequenceNumber() {
        return this.systemSequenceNumber;
    }

    public Instant getTime() {
        if (this.timestamp == null) {
            return Instant.ofEpochSecond(0L);
        }
        return this.timestamp;
    }

    public char getJournalCode() {
        return this.journalCode;
    }

    public String getEntryType() {
        return this.entryType;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public JournalEntryType getJournalEntryType() {
        String entryType = String.format("%s.%s", Character.valueOf(this.getJournalCode()), this.getEntryType());
        return JournalEntryType.toValue(entryType);
    }

    public String getFile() {
        return StringHelpers.safeTrim(this.objectName.substring(0, 10));
    }

    public String getLibrary() {
        return StringHelpers.safeTrim(this.objectName.substring(10, 20));
    }

    public String getMember() {
        return StringHelpers.safeTrim(this.objectName.substring(20, 30));
    }

    public BigInteger getCommitCycle() {
        return this.commitCycle;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getNullValueOffest() {
        return this.nullValueOffest;
    }

    public boolean hasReceiver() {
        return !this.receiver.isEmpty();
    }

    public String getReceiver() {
        return this.receiver;
    }

    public String getReceiverLibrary() {
        return this.receiverLibrary;
    }
}

