/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve;

import com.ibm.as400.access.AS400;
import io.debezium.ibmi.db2.journal.retrieve.Connect;
import io.debezium.ibmi.db2.journal.retrieve.FileFilter;
import io.debezium.ibmi.db2.journal.retrieve.JournalInfo;
import io.debezium.ibmi.db2.journal.retrieve.RetrievalCriteria;
import io.debezium.ibmi.db2.journal.retrieve.RetrieveConfig;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrieveConfigBuilder {
    private static final Logger log = LoggerFactory.getLogger(RetrieveConfigBuilder.class);
    private Connect<AS400, IOException> as400;
    private JournalInfo journalInfo;
    private File dumpFolder;
    private int journalBufferSize = 131072;
    private RetrievalCriteria.JournalCode[] filterCodes = new RetrievalCriteria.JournalCode[0];
    private List<FileFilter> includeFiles = Collections.emptyList();
    private int maxServerSideEntries = 1000000;
    private boolean filtering;

    public RetrieveConfigBuilder withAs400(Connect<AS400, IOException> as400) {
        this.as400 = as400;
        return this;
    }

    public RetrieveConfigBuilder withJournalInfo(JournalInfo journalInfo) {
        this.journalInfo = journalInfo;
        return this;
    }

    public RetrieveConfigBuilder withDumpFolder(String dumpFolder) {
        if (dumpFolder != null && !dumpFolder.isBlank()) {
            File f = new File(dumpFolder);
            if (f.exists()) {
                this.dumpFolder = f;
                return this;
            }
            log.error("ignoring dump folder {} as it doesn't exist", (Object)dumpFolder);
        }
        return this;
    }

    public RetrieveConfigBuilder withJournalBufferSize(int journalBufferSize) {
        this.journalBufferSize = journalBufferSize;
        return this;
    }

    public RetrieveConfigBuilder withFilterCodes(RetrievalCriteria.JournalCode[] filterCodes) {
        this.filterCodes = filterCodes == null ? new RetrievalCriteria.JournalCode[0] : filterCodes;
        return this;
    }

    public RetrieveConfigBuilder withServerFiltering(boolean filtering) {
        this.filtering = filtering;
        return this;
    }

    public RetrieveConfigBuilder withIncludeFiles(List<FileFilter> includeFiles) {
        if (includeFiles != null) {
            if (includeFiles.size() < 300) {
                this.includeFiles = includeFiles;
            } else {
                log.error("ignoring filter list as too many files included {} limit 300", (Object)includeFiles.size());
                this.includeFiles = Collections.emptyList();
            }
        } else {
            this.includeFiles = Collections.emptyList();
        }
        return this;
    }

    public RetrieveConfigBuilder withMaxServerSideEntries(Integer maxServerSideEntries) {
        if (maxServerSideEntries != null) {
            this.maxServerSideEntries = maxServerSideEntries;
        }
        return this;
    }

    public RetrieveConfig build() {
        return new RetrieveConfig(this.as400, this.journalInfo, this.journalBufferSize, this.filtering, this.filterCodes, this.includeFiles, this.maxServerSideEntries, this.dumpFolder);
    }
}

