/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.data.types;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400Boolean
implements AS400DataType {
    private static final long serialVersionUID = 1L;
    private static final Boolean DEFAULT_VALUE = Boolean.FALSE;
    private final AS400ZonedDecimal ZD = new AS400ZonedDecimal(1, 0);

    public Object getDefaultValue() {
        return DEFAULT_VALUE;
    }

    public int getInstanceType() {
        return -1;
    }

    public Class<Boolean> getJavaType() {
        return Boolean.class;
    }

    public Boolean toObject(byte[] as400Value) {
        return this.toBoolean(as400Value, 0);
    }

    public Boolean toObject(byte[] as400Value, int offset) {
        return this.toBoolean(as400Value, offset);
    }

    private Boolean toBoolean(byte[] as400Value, int offset) {
        byte[] oneByte = new byte[]{as400Value[offset]};
        Number n = (Number)this.ZD.toObject(oneByte, 0);
        switch (null != n ? n.intValue() : -1) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return Boolean.TRUE;
            }
        }
        throw new ExtendedIllegalArgumentException(String.valueOf(n), 2);
    }

    public int getByteLength() {
        return 1;
    }

    public byte[] toBytes(Object javaValue) {
        return new byte[0];
    }

    public int toBytes(Object javaValue, byte[] as400Value) {
        return 0;
    }

    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        return 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log((int)2, (String)"Unexpected CloneNotSupportedException:", (Throwable)e);
            throw new InternalErrorException(10);
        }
    }
}

