/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.test;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400JDBCDriverRegistration;
import io.debezium.ibmi.db2.journal.retrieve.Connect;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestConnector {
    private static final Logger log = LoggerFactory.getLogger(TestConnector.class);
    private Connect<AS400, IOException> as400Connect;
    private Connect<Connection, SQLException> sqlConnect;
    private final String schema;
    private final Properties props;
    private final String url;

    public TestConnector() throws SQLException {
        this(System.getenv("ISERIES_SCHEMA"));
    }

    public TestConnector(String schema) throws SQLException {
        this.schema = schema;
        final String user = System.getenv("ISERIES_USER");
        final String password = System.getenv("ISERIES_PASSWORD");
        final String host = System.getenv("ISERIES_HOST");
        String fromCcsid = System.getenv("FROM_CCSID");
        String toCcsid = System.getenv("TO_CCSID");
        this.url = String.format("jdbc:as400:%s", host);
        this.props = new Properties();
        this.props.setProperty("user", user);
        this.props.setProperty("password", password);
        if (fromCcsid != null && toCcsid != null) {
            AS400JDBCDriverRegistration.registerCcsidDriver();
            this.props.setProperty("from.ccsid", fromCcsid);
            this.props.setProperty("to.ccsid", toCcsid);
            log.info("forced ccsid {}", (Object)toCcsid);
        }
        this.as400Connect = new Connect<AS400, IOException>(){
            AS400 as400;
            {
                this.as400 = new AS400(host, user, password.toCharArray());
            }

            @Override
            public AS400 connection() {
                return this.as400;
            }
        };
        this.sqlConnect = new Connect<Connection, SQLException>(){
            Connection con;
            {
                this.con = DriverManager.getConnection(TestConnector.this.url, TestConnector.this.props);
            }

            @Override
            public Connection connection() throws SQLException {
                return this.con;
            }
        };
    }

    public Connect<AS400, IOException> getAs400() {
        return this.as400Connect;
    }

    public Connect<Connection, SQLException> getJdbc() {
        return this.sqlConnect;
    }

    public Connection getNewJdbcConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.props);
    }

    public String getSchema() {
        return this.schema;
    }
}

