/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ibmi.db2.journal.retrieve.rnrn0200;

import io.debezium.ibmi.db2.journal.retrieve.JournalReceiver;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.DetailedJournalReceiver;
import io.debezium.ibmi.db2.journal.retrieve.rnrn0200.JournalStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ReceiverChain {
    DetailedJournalReceiver details;
    Optional<ReceiverChain> next = Optional.empty();
    Optional<ReceiverChain> previous = Optional.empty();

    public ReceiverChain(DetailedJournalReceiver details) {
        if (details == null || details.info() == null || details.info().receiver() == null || details.info().receiver().name() == null) {
            throw new IllegalArgumentException("neither head, head.info or head.info.name can be null " + String.valueOf(details));
        }
        this.details = details;
    }

    public int hashCode() {
        return Objects.hash(this.details.info().receiver());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReceiverChain other = (ReceiverChain)obj;
        return this.details.info().receiver().equals(other.details.info().receiver());
    }

    public String toString() {
        return String.format("ReceiverChain [details=%s, next=%s, previous=%s]", this.details, this.next, this.previous);
    }

    public static List<DetailedJournalReceiver> chainContaining(List<DetailedJournalReceiver> l, DetailedJournalReceiver needle) {
        Map<JournalReceiver, ReceiverChain> m = ReceiverChain.availableSingleChainElement(l);
        ReceiverChain.buildReceiverChains(m);
        Optional<ReceiverChain> lastDetached = ReceiverChain.findChain(m, needle);
        return lastDetached.map(x -> ReceiverChain.chainToList(x)).orElse(Collections.emptyList());
    }

    static Map<JournalReceiver, ReceiverChain> availableSingleChainElement(List<DetailedJournalReceiver> l) {
        List<DetailedJournalReceiver> validReceivers = l.stream().filter(x -> switch (x.info().status()) {
            case JournalStatus.Attached, JournalStatus.OnlineSavedDetached, JournalStatus.SavedDetchedNotFreed -> true;
            default -> false;
        }).toList();
        Map<JournalReceiver, ReceiverChain> m = validReceivers.stream().collect(Collectors.toMap(x -> x.info().receiver(), y -> new ReceiverChain((DetailedJournalReceiver)y)));
        return m;
    }

    static Optional<ReceiverChain> findChain(Map<JournalReceiver, ReceiverChain> m, DetailedJournalReceiver needle) {
        JournalReceiver key = needle.info().receiver();
        if (m.containsKey(key)) {
            ReceiverChain rc = m.get(key);
            while (rc.previous.isPresent()) {
                rc = rc.previous.get();
            }
            return Optional.of(rc);
        }
        return Optional.empty();
    }

    static List<DetailedJournalReceiver> chainToList(ReceiverChain chain) {
        ArrayList<DetailedJournalReceiver> l = new ArrayList<DetailedJournalReceiver>();
        l.add(chain.details);
        while (chain.next.isPresent()) {
            chain = chain.next.get();
            l.add(chain.details);
        }
        return l;
    }

    static Set<ReceiverChain> buildReceiverChains(Map<JournalReceiver, ReceiverChain> m) {
        HashSet<ReceiverChain> noNext = new HashSet<ReceiverChain>(m.values());
        for (ReceiverChain or : m.values()) {
            or.details.nextReceiver().ifPresent(nextReceiver -> {
                if (m.containsKey(nextReceiver)) {
                    ReceiverChain nr = (ReceiverChain)m.get(nextReceiver);
                    noNext.remove(nr);
                    or.next = Optional.of(nr);
                    nr.previous = Optional.of(or);
                }
            });
        }
        return noNext;
    }
}

